// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmPeerCollectionGetParams creates a new SvmPeerCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmPeerCollectionGetParams() *SvmPeerCollectionGetParams {
	return &SvmPeerCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmPeerCollectionGetParamsWithTimeout creates a new SvmPeerCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSvmPeerCollectionGetParamsWithTimeout(timeout time.Duration) *SvmPeerCollectionGetParams {
	return &SvmPeerCollectionGetParams{
		timeout: timeout,
	}
}

// NewSvmPeerCollectionGetParamsWithContext creates a new SvmPeerCollectionGetParams object
// with the ability to set a context for a request.
func NewSvmPeerCollectionGetParamsWithContext(ctx context.Context) *SvmPeerCollectionGetParams {
	return &SvmPeerCollectionGetParams{
		Context: ctx,
	}
}

// NewSvmPeerCollectionGetParamsWithHTTPClient creates a new SvmPeerCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmPeerCollectionGetParamsWithHTTPClient(client *http.Client) *SvmPeerCollectionGetParams {
	return &SvmPeerCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SvmPeerCollectionGetParams contains all the parameters to send to the API endpoint

	for the svm peer collection get operation.

	Typically these are written to a http.Request.
*/
type SvmPeerCollectionGetParams struct {

	/* Applications.

	   Filter by applications
	*/
	Applications *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PeerClusterName.

	   Filter by peer.cluster.name
	*/
	PeerClusterName *string

	/* PeerClusterUUID.

	   Filter by peer.cluster.uuid
	*/
	PeerClusterUUID *string

	/* PeerSvmName.

	   Filter by peer.svm.name
	*/
	PeerSvmName *string

	/* PeerSvmUUID.

	   Filter by peer.svm.uuid
	*/
	PeerSvmUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm peer collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerCollectionGetParams) WithDefaults() *SvmPeerCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm peer collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SvmPeerCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithTimeout(timeout time.Duration) *SvmPeerCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithContext(ctx context.Context) *SvmPeerCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithHTTPClient(client *http.Client) *SvmPeerCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplications adds the applications to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithApplications(applications *string) *SvmPeerCollectionGetParams {
	o.SetApplications(applications)
	return o
}

// SetApplications adds the applications to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetApplications(applications *string) {
	o.Applications = applications
}

// WithFields adds the fields to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithFields(fields []string) *SvmPeerCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithMaxRecords(maxRecords *int64) *SvmPeerCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithName(name *string) *SvmPeerCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithOrderBy(orderBy []string) *SvmPeerCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPeerClusterName adds the peerClusterName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithPeerClusterName(peerClusterName *string) *SvmPeerCollectionGetParams {
	o.SetPeerClusterName(peerClusterName)
	return o
}

// SetPeerClusterName adds the peerClusterName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetPeerClusterName(peerClusterName *string) {
	o.PeerClusterName = peerClusterName
}

// WithPeerClusterUUID adds the peerClusterUUID to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithPeerClusterUUID(peerClusterUUID *string) *SvmPeerCollectionGetParams {
	o.SetPeerClusterUUID(peerClusterUUID)
	return o
}

// SetPeerClusterUUID adds the peerClusterUuid to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetPeerClusterUUID(peerClusterUUID *string) {
	o.PeerClusterUUID = peerClusterUUID
}

// WithPeerSvmName adds the peerSvmName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithPeerSvmName(peerSvmName *string) *SvmPeerCollectionGetParams {
	o.SetPeerSvmName(peerSvmName)
	return o
}

// SetPeerSvmName adds the peerSvmName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetPeerSvmName(peerSvmName *string) {
	o.PeerSvmName = peerSvmName
}

// WithPeerSvmUUID adds the peerSvmUUID to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithPeerSvmUUID(peerSvmUUID *string) *SvmPeerCollectionGetParams {
	o.SetPeerSvmUUID(peerSvmUUID)
	return o
}

// SetPeerSvmUUID adds the peerSvmUuid to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetPeerSvmUUID(peerSvmUUID *string) {
	o.PeerSvmUUID = peerSvmUUID
}

// WithReturnRecords adds the returnRecords to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithReturnRecords(returnRecords *bool) *SvmPeerCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SvmPeerCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithState adds the state to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithState(state *string) *SvmPeerCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSvmName adds the svmName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithSvmName(svmName *string) *SvmPeerCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithSvmUUID(svmUUID *string) *SvmPeerCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) WithUUID(uuid *string) *SvmPeerCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the svm peer collection get params
func (o *SvmPeerCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SvmPeerCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Applications != nil {

		// query param applications
		var qrApplications string

		if o.Applications != nil {
			qrApplications = *o.Applications
		}
		qApplications := qrApplications
		if qApplications != "" {

			if err := r.SetQueryParam("applications", qApplications); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PeerClusterName != nil {

		// query param peer.cluster.name
		var qrPeerClusterName string

		if o.PeerClusterName != nil {
			qrPeerClusterName = *o.PeerClusterName
		}
		qPeerClusterName := qrPeerClusterName
		if qPeerClusterName != "" {

			if err := r.SetQueryParam("peer.cluster.name", qPeerClusterName); err != nil {
				return err
			}
		}
	}

	if o.PeerClusterUUID != nil {

		// query param peer.cluster.uuid
		var qrPeerClusterUUID string

		if o.PeerClusterUUID != nil {
			qrPeerClusterUUID = *o.PeerClusterUUID
		}
		qPeerClusterUUID := qrPeerClusterUUID
		if qPeerClusterUUID != "" {

			if err := r.SetQueryParam("peer.cluster.uuid", qPeerClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.PeerSvmName != nil {

		// query param peer.svm.name
		var qrPeerSvmName string

		if o.PeerSvmName != nil {
			qrPeerSvmName = *o.PeerSvmName
		}
		qPeerSvmName := qrPeerSvmName
		if qPeerSvmName != "" {

			if err := r.SetQueryParam("peer.svm.name", qPeerSvmName); err != nil {
				return err
			}
		}
	}

	if o.PeerSvmUUID != nil {

		// query param peer.svm.uuid
		var qrPeerSvmUUID string

		if o.PeerSvmUUID != nil {
			qrPeerSvmUUID = *o.PeerSvmUUID
		}
		qPeerSvmUUID := qrPeerSvmUUID
		if qPeerSvmUUID != "" {

			if err := r.SetQueryParam("peer.svm.uuid", qPeerSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSvmPeerCollectionGet binds the parameter fields
func (o *SvmPeerCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSvmPeerCollectionGet binds the parameter order_by
func (o *SvmPeerCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
