// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmPeerCollectionGetReader is a Reader for the SvmPeerCollectionGet structure.
type SvmPeerCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmPeerCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmPeerCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmPeerCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmPeerCollectionGetOK creates a SvmPeerCollectionGetOK with default headers values
func NewSvmPeerCollectionGetOK() *SvmPeerCollectionGetOK {
	return &SvmPeerCollectionGetOK{}
}

/*
SvmPeerCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SvmPeerCollectionGetOK struct {
	Payload *models.SvmPeerResponse
}

// IsSuccess returns true when this svm peer collection get o k response has a 2xx status code
func (o *SvmPeerCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer collection get o k response has a 3xx status code
func (o *SvmPeerCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer collection get o k response has a 4xx status code
func (o *SvmPeerCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer collection get o k response has a 5xx status code
func (o *SvmPeerCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer collection get o k response a status code equal to that given
func (o *SvmPeerCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm peer collection get o k response
func (o *SvmPeerCollectionGetOK) Code() int {
	return 200
}

func (o *SvmPeerCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/peers][%d] svmPeerCollectionGetOK %s", 200, payload)
}

func (o *SvmPeerCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/peers][%d] svmPeerCollectionGetOK %s", 200, payload)
}

func (o *SvmPeerCollectionGetOK) GetPayload() *models.SvmPeerResponse {
	return o.Payload
}

func (o *SvmPeerCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmPeerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmPeerCollectionGetDefault creates a SvmPeerCollectionGetDefault with default headers values
func NewSvmPeerCollectionGetDefault(code int) *SvmPeerCollectionGetDefault {
	return &SvmPeerCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	SvmPeerCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 26345578    | Internal error. Unable to retrieve local or peer SVM name. |
| 9896086     | Peer SVM name conflicts with one of the following: a peer SVM in an existing SVM peer relationship, a local SVM, or an IPSpace. Use the \"name\" property to uniquely specify the peer SVM alias name. |
```
<br/>
*/
type SvmPeerCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm peer collection get default response has a 2xx status code
func (o *SvmPeerCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm peer collection get default response has a 3xx status code
func (o *SvmPeerCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm peer collection get default response has a 4xx status code
func (o *SvmPeerCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm peer collection get default response has a 5xx status code
func (o *SvmPeerCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm peer collection get default response a status code equal to that given
func (o *SvmPeerCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm peer collection get default response
func (o *SvmPeerCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SvmPeerCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/peers][%d] svm_peer_collection_get default %s", o._statusCode, payload)
}

func (o *SvmPeerCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/peers][%d] svm_peer_collection_get default %s", o._statusCode, payload)
}

func (o *SvmPeerCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmPeerCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
