// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmPeerDeleteCollectionReader is a Reader for the SvmPeerDeleteCollection structure.
type SvmPeerDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmPeerDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmPeerDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSvmPeerDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmPeerDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmPeerDeleteCollectionOK creates a SvmPeerDeleteCollectionOK with default headers values
func NewSvmPeerDeleteCollectionOK() *SvmPeerDeleteCollectionOK {
	return &SvmPeerDeleteCollectionOK{}
}

/*
SvmPeerDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmPeerDeleteCollectionOK struct {
	Payload *models.SvmPeerJobLinkResponse
}

// IsSuccess returns true when this svm peer delete collection o k response has a 2xx status code
func (o *SvmPeerDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer delete collection o k response has a 3xx status code
func (o *SvmPeerDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer delete collection o k response has a 4xx status code
func (o *SvmPeerDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer delete collection o k response has a 5xx status code
func (o *SvmPeerDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer delete collection o k response a status code equal to that given
func (o *SvmPeerDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm peer delete collection o k response
func (o *SvmPeerDeleteCollectionOK) Code() int {
	return 200
}

func (o *SvmPeerDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svmPeerDeleteCollectionOK %s", 200, payload)
}

func (o *SvmPeerDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svmPeerDeleteCollectionOK %s", 200, payload)
}

func (o *SvmPeerDeleteCollectionOK) GetPayload() *models.SvmPeerJobLinkResponse {
	return o.Payload
}

func (o *SvmPeerDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmPeerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmPeerDeleteCollectionAccepted creates a SvmPeerDeleteCollectionAccepted with default headers values
func NewSvmPeerDeleteCollectionAccepted() *SvmPeerDeleteCollectionAccepted {
	return &SvmPeerDeleteCollectionAccepted{}
}

/*
SvmPeerDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SvmPeerDeleteCollectionAccepted struct {
	Payload *models.SvmPeerJobLinkResponse
}

// IsSuccess returns true when this svm peer delete collection accepted response has a 2xx status code
func (o *SvmPeerDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer delete collection accepted response has a 3xx status code
func (o *SvmPeerDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer delete collection accepted response has a 4xx status code
func (o *SvmPeerDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer delete collection accepted response has a 5xx status code
func (o *SvmPeerDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer delete collection accepted response a status code equal to that given
func (o *SvmPeerDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the svm peer delete collection accepted response
func (o *SvmPeerDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SvmPeerDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svmPeerDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmPeerDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svmPeerDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmPeerDeleteCollectionAccepted) GetPayload() *models.SvmPeerJobLinkResponse {
	return o.Payload
}

func (o *SvmPeerDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmPeerJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmPeerDeleteCollectionDefault creates a SvmPeerDeleteCollectionDefault with default headers values
func NewSvmPeerDeleteCollectionDefault(code int) *SvmPeerDeleteCollectionDefault {
	return &SvmPeerDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmPeerDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 26345578    | Internal error. Unable to retrieve local or peer SVM name. |
| 9895956     | Cannot delete an SVM that is part of an SVM peer or transition peer relationship. |
```
<br/>
*/
type SvmPeerDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm peer delete collection default response has a 2xx status code
func (o *SvmPeerDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm peer delete collection default response has a 3xx status code
func (o *SvmPeerDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm peer delete collection default response has a 4xx status code
func (o *SvmPeerDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm peer delete collection default response has a 5xx status code
func (o *SvmPeerDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm peer delete collection default response a status code equal to that given
func (o *SvmPeerDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm peer delete collection default response
func (o *SvmPeerDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmPeerDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svm_peer_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peers][%d] svm_peer_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmPeerDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmPeerDeleteCollectionBody svm peer delete collection body
swagger:model SvmPeerDeleteCollectionBody
*/
type SvmPeerDeleteCollectionBody struct {

	// svm peer response inline records
	SvmPeerResponseInlineRecords []*models.SvmPeer `json:"records,omitempty"`
}

// Validate validates this svm peer delete collection body
func (o *SvmPeerDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSvmPeerResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerDeleteCollectionBody) validateSvmPeerResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmPeerResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmPeerResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmPeerResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmPeerResponseInlineRecords[i] != nil {
			if err := o.SvmPeerResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm peer delete collection body based on the context it is used
func (o *SvmPeerDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSvmPeerResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerDeleteCollectionBody) contextValidateSvmPeerResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmPeerResponseInlineRecords); i++ {

		if o.SvmPeerResponseInlineRecords[i] != nil {
			if err := o.SvmPeerResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmPeerDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
