// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmPeerDeleteParams creates a new SvmPeerDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmPeerDeleteParams() *SvmPeerDeleteParams {
	return &SvmPeerDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmPeerDeleteParamsWithTimeout creates a new SvmPeerDeleteParams object
// with the ability to set a timeout on a request.
func NewSvmPeerDeleteParamsWithTimeout(timeout time.Duration) *SvmPeerDeleteParams {
	return &SvmPeerDeleteParams{
		timeout: timeout,
	}
}

// NewSvmPeerDeleteParamsWithContext creates a new SvmPeerDeleteParams object
// with the ability to set a context for a request.
func NewSvmPeerDeleteParamsWithContext(ctx context.Context) *SvmPeerDeleteParams {
	return &SvmPeerDeleteParams{
		Context: ctx,
	}
}

// NewSvmPeerDeleteParamsWithHTTPClient creates a new SvmPeerDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmPeerDeleteParamsWithHTTPClient(client *http.Client) *SvmPeerDeleteParams {
	return &SvmPeerDeleteParams{
		HTTPClient: client,
	}
}

/*
SvmPeerDeleteParams contains all the parameters to send to the API endpoint

	for the svm peer delete operation.

	Typically these are written to a http.Request.
*/
type SvmPeerDeleteParams struct {

	/* Force.

	   Use this parameter to delete the SVM peer relationship even when the remote cluster is not accessible. For example, if there are network connectivity issues.
	*/
	Force *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   SVM peer relationship UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm peer delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerDeleteParams) WithDefaults() *SvmPeerDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm peer delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SvmPeerDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm peer delete params
func (o *SvmPeerDeleteParams) WithTimeout(timeout time.Duration) *SvmPeerDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm peer delete params
func (o *SvmPeerDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm peer delete params
func (o *SvmPeerDeleteParams) WithContext(ctx context.Context) *SvmPeerDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm peer delete params
func (o *SvmPeerDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm peer delete params
func (o *SvmPeerDeleteParams) WithHTTPClient(client *http.Client) *SvmPeerDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm peer delete params
func (o *SvmPeerDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the svm peer delete params
func (o *SvmPeerDeleteParams) WithForce(force *bool) *SvmPeerDeleteParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the svm peer delete params
func (o *SvmPeerDeleteParams) SetForce(force *bool) {
	o.Force = force
}

// WithReturnTimeout adds the returnTimeout to the svm peer delete params
func (o *SvmPeerDeleteParams) WithReturnTimeout(returnTimeout *int64) *SvmPeerDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm peer delete params
func (o *SvmPeerDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the svm peer delete params
func (o *SvmPeerDeleteParams) WithUUID(uuid string) *SvmPeerDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the svm peer delete params
func (o *SvmPeerDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SvmPeerDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
