// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmPeerPermissionDeleteCollectionParams creates a new SvmPeerPermissionDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmPeerPermissionDeleteCollectionParams() *SvmPeerPermissionDeleteCollectionParams {
	return &SvmPeerPermissionDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmPeerPermissionDeleteCollectionParamsWithTimeout creates a new SvmPeerPermissionDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSvmPeerPermissionDeleteCollectionParamsWithTimeout(timeout time.Duration) *SvmPeerPermissionDeleteCollectionParams {
	return &SvmPeerPermissionDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSvmPeerPermissionDeleteCollectionParamsWithContext creates a new SvmPeerPermissionDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSvmPeerPermissionDeleteCollectionParamsWithContext(ctx context.Context) *SvmPeerPermissionDeleteCollectionParams {
	return &SvmPeerPermissionDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSvmPeerPermissionDeleteCollectionParamsWithHTTPClient creates a new SvmPeerPermissionDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmPeerPermissionDeleteCollectionParamsWithHTTPClient(client *http.Client) *SvmPeerPermissionDeleteCollectionParams {
	return &SvmPeerPermissionDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SvmPeerPermissionDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the svm peer permission delete collection operation.

	Typically these are written to a http.Request.
*/
type SvmPeerPermissionDeleteCollectionParams struct {

	/* Applications.

	   Filter by applications
	*/
	Applications *string

	/* ClusterPeerName.

	   Filter by cluster_peer.name
	*/
	ClusterPeerName *string

	/* ClusterPeerUUID.

	   Filter by cluster_peer.uuid
	*/
	ClusterPeerUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info SvmPeerPermissionDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm peer permission delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerPermissionDeleteCollectionParams) WithDefaults() *SvmPeerPermissionDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm peer permission delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerPermissionDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SvmPeerPermissionDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithTimeout(timeout time.Duration) *SvmPeerPermissionDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithContext(ctx context.Context) *SvmPeerPermissionDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithHTTPClient(client *http.Client) *SvmPeerPermissionDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplications adds the applications to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithApplications(applications *string) *SvmPeerPermissionDeleteCollectionParams {
	o.SetApplications(applications)
	return o
}

// SetApplications adds the applications to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetApplications(applications *string) {
	o.Applications = applications
}

// WithClusterPeerName adds the clusterPeerName to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithClusterPeerName(clusterPeerName *string) *SvmPeerPermissionDeleteCollectionParams {
	o.SetClusterPeerName(clusterPeerName)
	return o
}

// SetClusterPeerName adds the clusterPeerName to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetClusterPeerName(clusterPeerName *string) {
	o.ClusterPeerName = clusterPeerName
}

// WithClusterPeerUUID adds the clusterPeerUUID to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithClusterPeerUUID(clusterPeerUUID *string) *SvmPeerPermissionDeleteCollectionParams {
	o.SetClusterPeerUUID(clusterPeerUUID)
	return o
}

// SetClusterPeerUUID adds the clusterPeerUuid to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetClusterPeerUUID(clusterPeerUUID *string) {
	o.ClusterPeerUUID = clusterPeerUUID
}

// WithContinueOnFailure adds the continueOnFailure to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SvmPeerPermissionDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithInfo(info SvmPeerPermissionDeleteCollectionBody) *SvmPeerPermissionDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetInfo(info SvmPeerPermissionDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SvmPeerPermissionDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SvmPeerPermissionDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SvmPeerPermissionDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithSvmName(svmName *string) *SvmPeerPermissionDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) WithSvmUUID(svmUUID *string) *SvmPeerPermissionDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the svm peer permission delete collection params
func (o *SvmPeerPermissionDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SvmPeerPermissionDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Applications != nil {

		// query param applications
		var qrApplications string

		if o.Applications != nil {
			qrApplications = *o.Applications
		}
		qApplications := qrApplications
		if qApplications != "" {

			if err := r.SetQueryParam("applications", qApplications); err != nil {
				return err
			}
		}
	}

	if o.ClusterPeerName != nil {

		// query param cluster_peer.name
		var qrClusterPeerName string

		if o.ClusterPeerName != nil {
			qrClusterPeerName = *o.ClusterPeerName
		}
		qClusterPeerName := qrClusterPeerName
		if qClusterPeerName != "" {

			if err := r.SetQueryParam("cluster_peer.name", qClusterPeerName); err != nil {
				return err
			}
		}
	}

	if o.ClusterPeerUUID != nil {

		// query param cluster_peer.uuid
		var qrClusterPeerUUID string

		if o.ClusterPeerUUID != nil {
			qrClusterPeerUUID = *o.ClusterPeerUUID
		}
		qClusterPeerUUID := qrClusterPeerUUID
		if qClusterPeerUUID != "" {

			if err := r.SetQueryParam("cluster_peer.uuid", qClusterPeerUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
