// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmPeerPermissionDeleteCollectionReader is a Reader for the SvmPeerPermissionDeleteCollection structure.
type SvmPeerPermissionDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmPeerPermissionDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmPeerPermissionDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmPeerPermissionDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmPeerPermissionDeleteCollectionOK creates a SvmPeerPermissionDeleteCollectionOK with default headers values
func NewSvmPeerPermissionDeleteCollectionOK() *SvmPeerPermissionDeleteCollectionOK {
	return &SvmPeerPermissionDeleteCollectionOK{}
}

/*
SvmPeerPermissionDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmPeerPermissionDeleteCollectionOK struct {
}

// IsSuccess returns true when this svm peer permission delete collection o k response has a 2xx status code
func (o *SvmPeerPermissionDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer permission delete collection o k response has a 3xx status code
func (o *SvmPeerPermissionDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer permission delete collection o k response has a 4xx status code
func (o *SvmPeerPermissionDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer permission delete collection o k response has a 5xx status code
func (o *SvmPeerPermissionDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer permission delete collection o k response a status code equal to that given
func (o *SvmPeerPermissionDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm peer permission delete collection o k response
func (o *SvmPeerPermissionDeleteCollectionOK) Code() int {
	return 200
}

func (o *SvmPeerPermissionDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /svm/peer-permissions][%d] svmPeerPermissionDeleteCollectionOK", 200)
}

func (o *SvmPeerPermissionDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /svm/peer-permissions][%d] svmPeerPermissionDeleteCollectionOK", 200)
}

func (o *SvmPeerPermissionDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSvmPeerPermissionDeleteCollectionDefault creates a SvmPeerPermissionDeleteCollectionDefault with default headers values
func NewSvmPeerPermissionDeleteCollectionDefault(code int) *SvmPeerPermissionDeleteCollectionDefault {
	return &SvmPeerPermissionDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmPeerPermissionDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 26345574    | Failed to find the SVM or volume name with UUID. |
```
<br/>
*/
type SvmPeerPermissionDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm peer permission delete collection default response has a 2xx status code
func (o *SvmPeerPermissionDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm peer permission delete collection default response has a 3xx status code
func (o *SvmPeerPermissionDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm peer permission delete collection default response has a 4xx status code
func (o *SvmPeerPermissionDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm peer permission delete collection default response has a 5xx status code
func (o *SvmPeerPermissionDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm peer permission delete collection default response a status code equal to that given
func (o *SvmPeerPermissionDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm peer permission delete collection default response
func (o *SvmPeerPermissionDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmPeerPermissionDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peer-permissions][%d] svm_peer_permission_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/peer-permissions][%d] svm_peer_permission_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmPeerPermissionDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmPeerPermissionDeleteCollectionBody svm peer permission delete collection body
swagger:model SvmPeerPermissionDeleteCollectionBody
*/
type SvmPeerPermissionDeleteCollectionBody struct {

	// svm peer permission response inline records
	SvmPeerPermissionResponseInlineRecords []*models.SvmPeerPermission `json:"records,omitempty"`
}

// Validate validates this svm peer permission delete collection body
func (o *SvmPeerPermissionDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSvmPeerPermissionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionDeleteCollectionBody) validateSvmPeerPermissionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmPeerPermissionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmPeerPermissionResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmPeerPermissionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmPeerPermissionResponseInlineRecords[i] != nil {
			if err := o.SvmPeerPermissionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm peer permission delete collection body based on the context it is used
func (o *SvmPeerPermissionDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSvmPeerPermissionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionDeleteCollectionBody) contextValidateSvmPeerPermissionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmPeerPermissionResponseInlineRecords); i++ {

		if o.SvmPeerPermissionResponseInlineRecords[i] != nil {
			if err := o.SvmPeerPermissionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
