// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmPeerPermissionInstanceGetParams creates a new SvmPeerPermissionInstanceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmPeerPermissionInstanceGetParams() *SvmPeerPermissionInstanceGetParams {
	return &SvmPeerPermissionInstanceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmPeerPermissionInstanceGetParamsWithTimeout creates a new SvmPeerPermissionInstanceGetParams object
// with the ability to set a timeout on a request.
func NewSvmPeerPermissionInstanceGetParamsWithTimeout(timeout time.Duration) *SvmPeerPermissionInstanceGetParams {
	return &SvmPeerPermissionInstanceGetParams{
		timeout: timeout,
	}
}

// NewSvmPeerPermissionInstanceGetParamsWithContext creates a new SvmPeerPermissionInstanceGetParams object
// with the ability to set a context for a request.
func NewSvmPeerPermissionInstanceGetParamsWithContext(ctx context.Context) *SvmPeerPermissionInstanceGetParams {
	return &SvmPeerPermissionInstanceGetParams{
		Context: ctx,
	}
}

// NewSvmPeerPermissionInstanceGetParamsWithHTTPClient creates a new SvmPeerPermissionInstanceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmPeerPermissionInstanceGetParamsWithHTTPClient(client *http.Client) *SvmPeerPermissionInstanceGetParams {
	return &SvmPeerPermissionInstanceGetParams{
		HTTPClient: client,
	}
}

/*
SvmPeerPermissionInstanceGetParams contains all the parameters to send to the API endpoint

	for the svm peer permission instance get operation.

	Typically these are written to a http.Request.
*/
type SvmPeerPermissionInstanceGetParams struct {

	/* ClusterPeerUUID.

	   Peer cluster UUID
	*/
	ClusterPeerUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   SVM UUID
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm peer permission instance get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerPermissionInstanceGetParams) WithDefaults() *SvmPeerPermissionInstanceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm peer permission instance get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmPeerPermissionInstanceGetParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(15)
	)

	val := SvmPeerPermissionInstanceGetParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithTimeout(timeout time.Duration) *SvmPeerPermissionInstanceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithContext(ctx context.Context) *SvmPeerPermissionInstanceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithHTTPClient(client *http.Client) *SvmPeerPermissionInstanceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterPeerUUID adds the clusterPeerUUID to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithClusterPeerUUID(clusterPeerUUID string) *SvmPeerPermissionInstanceGetParams {
	o.SetClusterPeerUUID(clusterPeerUUID)
	return o
}

// SetClusterPeerUUID adds the clusterPeerUuid to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetClusterPeerUUID(clusterPeerUUID string) {
	o.ClusterPeerUUID = clusterPeerUUID
}

// WithFields adds the fields to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithFields(fields []string) *SvmPeerPermissionInstanceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithReturnTimeout adds the returnTimeout to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithReturnTimeout(returnTimeout *int64) *SvmPeerPermissionInstanceGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) WithSvmUUID(svmUUID string) *SvmPeerPermissionInstanceGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the svm peer permission instance get params
func (o *SvmPeerPermissionInstanceGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SvmPeerPermissionInstanceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_peer.uuid
	if err := r.SetPathParam("cluster_peer.uuid", o.ClusterPeerUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSvmPeerPermissionInstanceGet binds the parameter fields
func (o *SvmPeerPermissionInstanceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
