// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmPeerPermissionModifyCollectionReader is a Reader for the SvmPeerPermissionModifyCollection structure.
type SvmPeerPermissionModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmPeerPermissionModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmPeerPermissionModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmPeerPermissionModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmPeerPermissionModifyCollectionOK creates a SvmPeerPermissionModifyCollectionOK with default headers values
func NewSvmPeerPermissionModifyCollectionOK() *SvmPeerPermissionModifyCollectionOK {
	return &SvmPeerPermissionModifyCollectionOK{}
}

/*
SvmPeerPermissionModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmPeerPermissionModifyCollectionOK struct {
	Payload *models.SvmPeerPermission
}

// IsSuccess returns true when this svm peer permission modify collection o k response has a 2xx status code
func (o *SvmPeerPermissionModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer permission modify collection o k response has a 3xx status code
func (o *SvmPeerPermissionModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer permission modify collection o k response has a 4xx status code
func (o *SvmPeerPermissionModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer permission modify collection o k response has a 5xx status code
func (o *SvmPeerPermissionModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer permission modify collection o k response a status code equal to that given
func (o *SvmPeerPermissionModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm peer permission modify collection o k response
func (o *SvmPeerPermissionModifyCollectionOK) Code() int {
	return 200
}

func (o *SvmPeerPermissionModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions][%d] svmPeerPermissionModifyCollectionOK %s", 200, payload)
}

func (o *SvmPeerPermissionModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions][%d] svmPeerPermissionModifyCollectionOK %s", 200, payload)
}

func (o *SvmPeerPermissionModifyCollectionOK) GetPayload() *models.SvmPeerPermission {
	return o.Payload
}

func (o *SvmPeerPermissionModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmPeerPermission)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmPeerPermissionModifyCollectionDefault creates a SvmPeerPermissionModifyCollectionDefault with default headers values
func NewSvmPeerPermissionModifyCollectionDefault(code int) *SvmPeerPermissionModifyCollectionDefault {
	return &SvmPeerPermissionModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmPeerPermissionModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 26345572    | {field} is a required field. |
| 26345574    | Failed to find the SVM or volume name with UUID. |
| 9896059     | SVM peer permission does not exist. |
```
<br/>
*/
type SvmPeerPermissionModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm peer permission modify collection default response has a 2xx status code
func (o *SvmPeerPermissionModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm peer permission modify collection default response has a 3xx status code
func (o *SvmPeerPermissionModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm peer permission modify collection default response has a 4xx status code
func (o *SvmPeerPermissionModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm peer permission modify collection default response has a 5xx status code
func (o *SvmPeerPermissionModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm peer permission modify collection default response a status code equal to that given
func (o *SvmPeerPermissionModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm peer permission modify collection default response
func (o *SvmPeerPermissionModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmPeerPermissionModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions][%d] svm_peer_permission_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions][%d] svm_peer_permission_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmPeerPermissionModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmPeerPermissionModifyCollectionBody svm peer permission modify collection body
swagger:model SvmPeerPermissionModifyCollectionBody
*/
type SvmPeerPermissionModifyCollectionBody struct {

	// links
	Links *models.SvmPeerPermissionInlineLinks `json:"_links,omitempty"`

	// cluster peer
	ClusterPeer *models.SvmPeerPermissionInlineClusterPeer `json:"cluster_peer,omitempty"`

	// svm
	Svm *models.SvmPeerPermissionInlineSvm `json:"svm,omitempty"`

	// A list of applications for an SVM peer relationship.
	// Example: ["snapmirror","flexcache"]
	SvmPeerPermissionInlineApplications []*models.SvmPeerPermissionApplications `json:"applications,omitempty"`

	// svm peer permission response inline records
	SvmPeerPermissionResponseInlineRecords []*models.SvmPeerPermission `json:"records,omitempty"`
}

// Validate validates this svm peer permission modify collection body
func (o *SvmPeerPermissionModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClusterPeer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmPeerPermissionInlineApplications(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmPeerPermissionResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) validateClusterPeer(formats strfmt.Registry) error {
	if swag.IsZero(o.ClusterPeer) { // not required
		return nil
	}

	if o.ClusterPeer != nil {
		if err := o.ClusterPeer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) validateSvmPeerPermissionInlineApplications(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmPeerPermissionInlineApplications) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmPeerPermissionInlineApplications); i++ {
		if swag.IsZero(o.SvmPeerPermissionInlineApplications[i]) { // not required
			continue
		}

		if o.SvmPeerPermissionInlineApplications[i] != nil {
			if err := o.SvmPeerPermissionInlineApplications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) validateSvmPeerPermissionResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmPeerPermissionResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmPeerPermissionResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmPeerPermissionResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmPeerPermissionResponseInlineRecords[i] != nil {
			if err := o.SvmPeerPermissionResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm peer permission modify collection body based on the context it is used
func (o *SvmPeerPermissionModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClusterPeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmPeerPermissionInlineApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmPeerPermissionResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) contextValidateClusterPeer(ctx context.Context, formats strfmt.Registry) error {

	if o.ClusterPeer != nil {
		if err := o.ClusterPeer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) contextValidateSvmPeerPermissionInlineApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmPeerPermissionInlineApplications); i++ {

		if o.SvmPeerPermissionInlineApplications[i] != nil {
			if err := o.SvmPeerPermissionInlineApplications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmPeerPermissionModifyCollectionBody) contextValidateSvmPeerPermissionResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmPeerPermissionResponseInlineRecords); i++ {

		if o.SvmPeerPermissionResponseInlineRecords[i] != nil {
			if err := o.SvmPeerPermissionResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmPeerPermissionInlineLinks svm peer permission inline links
swagger:model svm_peer_permission_inline__links
*/
type SvmPeerPermissionInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm peer permission inline links
func (o *SvmPeerPermissionInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer permission inline links based on the context it is used
func (o *SvmPeerPermissionInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmPeerPermissionInlineClusterPeer Peer cluster details
swagger:model svm_peer_permission_inline_cluster_peer
*/
type SvmPeerPermissionInlineClusterPeer struct {

	// links
	Links *models.SvmPeerPermissionInlineClusterPeerInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: ebe27c49-1adf-4496-8335-ab862aebebf2
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer permission inline cluster peer
func (o *SvmPeerPermissionInlineClusterPeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineClusterPeer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer permission inline cluster peer based on the context it is used
func (o *SvmPeerPermissionInlineClusterPeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineClusterPeer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionInlineClusterPeer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionInlineClusterPeer) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionInlineClusterPeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmPeerPermissionInlineClusterPeerInlineLinks svm peer permission inline cluster peer inline links
swagger:model svm_peer_permission_inline_cluster_peer_inline__links
*/
type SvmPeerPermissionInlineClusterPeerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm peer permission inline cluster peer inline links
func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer permission inline cluster peer inline links based on the context it is used
func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster_peer" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionInlineClusterPeerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionInlineClusterPeerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmPeerPermissionInlineSvm Local SVM permitted for peer relationship. To create peer permissions for all SVMs, specify the SVM name as "*".
swagger:model svm_peer_permission_inline_svm
*/
type SvmPeerPermissionInlineSvm struct {

	// links
	Links *models.SvmPeerPermissionInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm peer permission inline svm
func (o *SvmPeerPermissionInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer permission inline svm based on the context it is used
func (o *SvmPeerPermissionInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmPeerPermissionInlineSvmInlineLinks svm peer permission inline svm inline links
swagger:model svm_peer_permission_inline_svm_inline__links
*/
type SvmPeerPermissionInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm peer permission inline svm inline links
func (o *SvmPeerPermissionInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm peer permission inline svm inline links based on the context it is used
func (o *SvmPeerPermissionInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmPeerPermissionInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmPeerPermissionInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmPeerPermissionInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmPeerPermissionInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
