// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmPeerPermissionModifyReader is a Reader for the SvmPeerPermissionModify structure.
type SvmPeerPermissionModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmPeerPermissionModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmPeerPermissionModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmPeerPermissionModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmPeerPermissionModifyOK creates a SvmPeerPermissionModifyOK with default headers values
func NewSvmPeerPermissionModifyOK() *SvmPeerPermissionModifyOK {
	return &SvmPeerPermissionModifyOK{}
}

/*
SvmPeerPermissionModifyOK describes a response with status code 200, with default header values.

OK
*/
type SvmPeerPermissionModifyOK struct {
	Payload *models.SvmPeerPermission
}

// IsSuccess returns true when this svm peer permission modify o k response has a 2xx status code
func (o *SvmPeerPermissionModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm peer permission modify o k response has a 3xx status code
func (o *SvmPeerPermissionModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm peer permission modify o k response has a 4xx status code
func (o *SvmPeerPermissionModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm peer permission modify o k response has a 5xx status code
func (o *SvmPeerPermissionModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm peer permission modify o k response a status code equal to that given
func (o *SvmPeerPermissionModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm peer permission modify o k response
func (o *SvmPeerPermissionModifyOK) Code() int {
	return 200
}

func (o *SvmPeerPermissionModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}][%d] svmPeerPermissionModifyOK %s", 200, payload)
}

func (o *SvmPeerPermissionModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}][%d] svmPeerPermissionModifyOK %s", 200, payload)
}

func (o *SvmPeerPermissionModifyOK) GetPayload() *models.SvmPeerPermission {
	return o.Payload
}

func (o *SvmPeerPermissionModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmPeerPermission)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmPeerPermissionModifyDefault creates a SvmPeerPermissionModifyDefault with default headers values
func NewSvmPeerPermissionModifyDefault(code int) *SvmPeerPermissionModifyDefault {
	return &SvmPeerPermissionModifyDefault{
		_statusCode: code,
	}
}

/*
	SvmPeerPermissionModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 26345572    | {field} is a required field. |
| 26345574    | Failed to find the SVM or volume name with UUID. |
| 9896059     | SVM peer permission does not exist. |
```
<br/>
*/
type SvmPeerPermissionModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm peer permission modify default response has a 2xx status code
func (o *SvmPeerPermissionModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm peer permission modify default response has a 3xx status code
func (o *SvmPeerPermissionModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm peer permission modify default response has a 4xx status code
func (o *SvmPeerPermissionModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm peer permission modify default response has a 5xx status code
func (o *SvmPeerPermissionModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm peer permission modify default response a status code equal to that given
func (o *SvmPeerPermissionModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm peer permission modify default response
func (o *SvmPeerPermissionModifyDefault) Code() int {
	return o._statusCode
}

func (o *SvmPeerPermissionModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}][%d] svm_peer_permission_modify default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}][%d] svm_peer_permission_modify default %s", o._statusCode, payload)
}

func (o *SvmPeerPermissionModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmPeerPermissionModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
