// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTopMetricsSvmFileCollectionGetParams creates a new TopMetricsSvmFileCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTopMetricsSvmFileCollectionGetParams() *TopMetricsSvmFileCollectionGetParams {
	return &TopMetricsSvmFileCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTopMetricsSvmFileCollectionGetParamsWithTimeout creates a new TopMetricsSvmFileCollectionGetParams object
// with the ability to set a timeout on a request.
func NewTopMetricsSvmFileCollectionGetParamsWithTimeout(timeout time.Duration) *TopMetricsSvmFileCollectionGetParams {
	return &TopMetricsSvmFileCollectionGetParams{
		timeout: timeout,
	}
}

// NewTopMetricsSvmFileCollectionGetParamsWithContext creates a new TopMetricsSvmFileCollectionGetParams object
// with the ability to set a context for a request.
func NewTopMetricsSvmFileCollectionGetParamsWithContext(ctx context.Context) *TopMetricsSvmFileCollectionGetParams {
	return &TopMetricsSvmFileCollectionGetParams{
		Context: ctx,
	}
}

// NewTopMetricsSvmFileCollectionGetParamsWithHTTPClient creates a new TopMetricsSvmFileCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewTopMetricsSvmFileCollectionGetParamsWithHTTPClient(client *http.Client) *TopMetricsSvmFileCollectionGetParams {
	return &TopMetricsSvmFileCollectionGetParams{
		HTTPClient: client,
	}
}

/*
TopMetricsSvmFileCollectionGetParams contains all the parameters to send to the API endpoint

	for the top metrics svm file collection get operation.

	Typically these are written to a http.Request.
*/
type TopMetricsSvmFileCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IopsErrorLowerBound.

	   Filter by iops.error.lower_bound
	*/
	IopsErrorLowerBound *int64

	/* IopsErrorUpperBound.

	   Filter by iops.error.upper_bound
	*/
	IopsErrorUpperBound *int64

	/* IopsRead.

	   Filter by iops.read
	*/
	IopsRead *int64

	/* IopsWrite.

	   Filter by iops.write
	*/
	IopsWrite *int64

	/* JunctionPath.

	   Filter by junction-path
	*/
	JunctionPath *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MaxRecordsPerSvm.

	   Max records per svm.
	*/
	MaxRecordsPerSvm *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Path.

	   Filter by path
	*/
	Path *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   SVM UUID
	*/
	SvmUUID string

	/* ThroughputErrorLowerBound.

	   Filter by throughput.error.lower_bound
	*/
	ThroughputErrorLowerBound *int64

	/* ThroughputErrorUpperBound.

	   Filter by throughput.error.upper_bound
	*/
	ThroughputErrorUpperBound *int64

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* TopMetric.

	   I/O activity type

	   Default: "iops.read"
	*/
	TopMetric *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the top metrics svm file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TopMetricsSvmFileCollectionGetParams) WithDefaults() *TopMetricsSvmFileCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the top metrics svm file collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TopMetricsSvmFileCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		topMetricDefault = string("iops.read")
	)

	val := TopMetricsSvmFileCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
		TopMetric:     &topMetricDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithTimeout(timeout time.Duration) *TopMetricsSvmFileCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithContext(ctx context.Context) *TopMetricsSvmFileCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithHTTPClient(client *http.Client) *TopMetricsSvmFileCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithFields(fields []string) *TopMetricsSvmFileCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIopsErrorLowerBound adds the iopsErrorLowerBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithIopsErrorLowerBound(iopsErrorLowerBound *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetIopsErrorLowerBound(iopsErrorLowerBound)
	return o
}

// SetIopsErrorLowerBound adds the iopsErrorLowerBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetIopsErrorLowerBound(iopsErrorLowerBound *int64) {
	o.IopsErrorLowerBound = iopsErrorLowerBound
}

// WithIopsErrorUpperBound adds the iopsErrorUpperBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithIopsErrorUpperBound(iopsErrorUpperBound *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetIopsErrorUpperBound(iopsErrorUpperBound)
	return o
}

// SetIopsErrorUpperBound adds the iopsErrorUpperBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetIopsErrorUpperBound(iopsErrorUpperBound *int64) {
	o.IopsErrorUpperBound = iopsErrorUpperBound
}

// WithIopsRead adds the iopsRead to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithIopsRead(iopsRead *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetIopsRead(iopsRead)
	return o
}

// SetIopsRead adds the iopsRead to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetIopsRead(iopsRead *int64) {
	o.IopsRead = iopsRead
}

// WithIopsWrite adds the iopsWrite to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithIopsWrite(iopsWrite *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetIopsWrite(iopsWrite)
	return o
}

// SetIopsWrite adds the iopsWrite to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetIopsWrite(iopsWrite *int64) {
	o.IopsWrite = iopsWrite
}

// WithJunctionPath adds the junctionPath to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithJunctionPath(junctionPath *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetJunctionPath(junctionPath)
	return o
}

// SetJunctionPath adds the junctionPath to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetJunctionPath(junctionPath *string) {
	o.JunctionPath = junctionPath
}

// WithMaxRecords adds the maxRecords to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithMaxRecords(maxRecords *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMaxRecordsPerSvm adds the maxRecordsPerSvm to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithMaxRecordsPerSvm(maxRecordsPerSvm *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetMaxRecordsPerSvm(maxRecordsPerSvm)
	return o
}

// SetMaxRecordsPerSvm adds the maxRecordsPerSvm to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetMaxRecordsPerSvm(maxRecordsPerSvm *int64) {
	o.MaxRecordsPerSvm = maxRecordsPerSvm
}

// WithOrderBy adds the orderBy to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithOrderBy(orderBy []string) *TopMetricsSvmFileCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPath adds the path to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithPath(path *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetPath(path *string) {
	o.Path = path
}

// WithReturnRecords adds the returnRecords to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithReturnRecords(returnRecords *bool) *TopMetricsSvmFileCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithSvmName(svmName *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithSvmUUID(svmUUID string) *TopMetricsSvmFileCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithThroughputErrorLowerBound adds the throughputErrorLowerBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithThroughputErrorLowerBound(throughputErrorLowerBound *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetThroughputErrorLowerBound(throughputErrorLowerBound)
	return o
}

// SetThroughputErrorLowerBound adds the throughputErrorLowerBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetThroughputErrorLowerBound(throughputErrorLowerBound *int64) {
	o.ThroughputErrorLowerBound = throughputErrorLowerBound
}

// WithThroughputErrorUpperBound adds the throughputErrorUpperBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithThroughputErrorUpperBound(throughputErrorUpperBound *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetThroughputErrorUpperBound(throughputErrorUpperBound)
	return o
}

// SetThroughputErrorUpperBound adds the throughputErrorUpperBound to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetThroughputErrorUpperBound(throughputErrorUpperBound *int64) {
	o.ThroughputErrorUpperBound = throughputErrorUpperBound
}

// WithThroughputRead adds the throughputRead to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithThroughputRead(throughputRead *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputWrite adds the throughputWrite to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithThroughputWrite(throughputWrite *int64) *TopMetricsSvmFileCollectionGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTopMetric adds the topMetric to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithTopMetric(topMetric *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetTopMetric(topMetric)
	return o
}

// SetTopMetric adds the topMetric to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetTopMetric(topMetric *string) {
	o.TopMetric = topMetric
}

// WithVolumeName adds the volumeName to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithVolumeName(volumeName *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) WithVolumeUUID(volumeUUID *string) *TopMetricsSvmFileCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the top metrics svm file collection get params
func (o *TopMetricsSvmFileCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *TopMetricsSvmFileCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IopsErrorLowerBound != nil {

		// query param iops.error.lower_bound
		var qrIopsErrorLowerBound int64

		if o.IopsErrorLowerBound != nil {
			qrIopsErrorLowerBound = *o.IopsErrorLowerBound
		}
		qIopsErrorLowerBound := swag.FormatInt64(qrIopsErrorLowerBound)
		if qIopsErrorLowerBound != "" {

			if err := r.SetQueryParam("iops.error.lower_bound", qIopsErrorLowerBound); err != nil {
				return err
			}
		}
	}

	if o.IopsErrorUpperBound != nil {

		// query param iops.error.upper_bound
		var qrIopsErrorUpperBound int64

		if o.IopsErrorUpperBound != nil {
			qrIopsErrorUpperBound = *o.IopsErrorUpperBound
		}
		qIopsErrorUpperBound := swag.FormatInt64(qrIopsErrorUpperBound)
		if qIopsErrorUpperBound != "" {

			if err := r.SetQueryParam("iops.error.upper_bound", qIopsErrorUpperBound); err != nil {
				return err
			}
		}
	}

	if o.IopsRead != nil {

		// query param iops.read
		var qrIopsRead int64

		if o.IopsRead != nil {
			qrIopsRead = *o.IopsRead
		}
		qIopsRead := swag.FormatInt64(qrIopsRead)
		if qIopsRead != "" {

			if err := r.SetQueryParam("iops.read", qIopsRead); err != nil {
				return err
			}
		}
	}

	if o.IopsWrite != nil {

		// query param iops.write
		var qrIopsWrite int64

		if o.IopsWrite != nil {
			qrIopsWrite = *o.IopsWrite
		}
		qIopsWrite := swag.FormatInt64(qrIopsWrite)
		if qIopsWrite != "" {

			if err := r.SetQueryParam("iops.write", qIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.JunctionPath != nil {

		// query param junction-path
		var qrJunctionPath string

		if o.JunctionPath != nil {
			qrJunctionPath = *o.JunctionPath
		}
		qJunctionPath := qrJunctionPath
		if qJunctionPath != "" {

			if err := r.SetQueryParam("junction-path", qJunctionPath); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MaxRecordsPerSvm != nil {

		// query param max_records_per_svm
		var qrMaxRecordsPerSvm int64

		if o.MaxRecordsPerSvm != nil {
			qrMaxRecordsPerSvm = *o.MaxRecordsPerSvm
		}
		qMaxRecordsPerSvm := swag.FormatInt64(qrMaxRecordsPerSvm)
		if qMaxRecordsPerSvm != "" {

			if err := r.SetQueryParam("max_records_per_svm", qMaxRecordsPerSvm); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.ThroughputErrorLowerBound != nil {

		// query param throughput.error.lower_bound
		var qrThroughputErrorLowerBound int64

		if o.ThroughputErrorLowerBound != nil {
			qrThroughputErrorLowerBound = *o.ThroughputErrorLowerBound
		}
		qThroughputErrorLowerBound := swag.FormatInt64(qrThroughputErrorLowerBound)
		if qThroughputErrorLowerBound != "" {

			if err := r.SetQueryParam("throughput.error.lower_bound", qThroughputErrorLowerBound); err != nil {
				return err
			}
		}
	}

	if o.ThroughputErrorUpperBound != nil {

		// query param throughput.error.upper_bound
		var qrThroughputErrorUpperBound int64

		if o.ThroughputErrorUpperBound != nil {
			qrThroughputErrorUpperBound = *o.ThroughputErrorUpperBound
		}
		qThroughputErrorUpperBound := swag.FormatInt64(qrThroughputErrorUpperBound)
		if qThroughputErrorUpperBound != "" {

			if err := r.SetQueryParam("throughput.error.upper_bound", qThroughputErrorUpperBound); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.TopMetric != nil {

		// query param top_metric
		var qrTopMetric string

		if o.TopMetric != nil {
			qrTopMetric = *o.TopMetric
		}
		qTopMetric := qrTopMetric
		if qTopMetric != "" {

			if err := r.SetQueryParam("top_metric", qTopMetric); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamTopMetricsSvmFileCollectionGet binds the parameter fields
func (o *TopMetricsSvmFileCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamTopMetricsSvmFileCollectionGet binds the parameter order_by
func (o *TopMetricsSvmFileCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
