// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWebSvmGetParams creates a new WebSvmGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebSvmGetParams() *WebSvmGetParams {
	return &WebSvmGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebSvmGetParamsWithTimeout creates a new WebSvmGetParams object
// with the ability to set a timeout on a request.
func NewWebSvmGetParamsWithTimeout(timeout time.Duration) *WebSvmGetParams {
	return &WebSvmGetParams{
		timeout: timeout,
	}
}

// NewWebSvmGetParamsWithContext creates a new WebSvmGetParams object
// with the ability to set a context for a request.
func NewWebSvmGetParamsWithContext(ctx context.Context) *WebSvmGetParams {
	return &WebSvmGetParams{
		Context: ctx,
	}
}

// NewWebSvmGetParamsWithHTTPClient creates a new WebSvmGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebSvmGetParamsWithHTTPClient(client *http.Client) *WebSvmGetParams {
	return &WebSvmGetParams{
		HTTPClient: client,
	}
}

/*
WebSvmGetParams contains all the parameters to send to the API endpoint

	for the web svm get operation.

	Typically these are written to a http.Request.
*/
type WebSvmGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the web svm get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebSvmGetParams) WithDefaults() *WebSvmGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the web svm get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebSvmGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the web svm get params
func (o *WebSvmGetParams) WithTimeout(timeout time.Duration) *WebSvmGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the web svm get params
func (o *WebSvmGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the web svm get params
func (o *WebSvmGetParams) WithContext(ctx context.Context) *WebSvmGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the web svm get params
func (o *WebSvmGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the web svm get params
func (o *WebSvmGetParams) WithHTTPClient(client *http.Client) *WebSvmGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the web svm get params
func (o *WebSvmGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the web svm get params
func (o *WebSvmGetParams) WithFields(fields []string) *WebSvmGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the web svm get params
func (o *WebSvmGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the web svm get params
func (o *WebSvmGetParams) WithSvmUUID(svmUUID string) *WebSvmGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the web svm get params
func (o *WebSvmGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WebSvmGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWebSvmGet binds the parameter fields
func (o *WebSvmGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
