// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WebSvmModifyReader is a Reader for the WebSvmModify structure.
type WebSvmModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebSvmModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebSvmModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWebSvmModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebSvmModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebSvmModifyOK creates a WebSvmModifyOK with default headers values
func NewWebSvmModifyOK() *WebSvmModifyOK {
	return &WebSvmModifyOK{}
}

/*
WebSvmModifyOK describes a response with status code 200, with default header values.

OK
*/
type WebSvmModifyOK struct {
}

// IsSuccess returns true when this web svm modify o k response has a 2xx status code
func (o *WebSvmModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this web svm modify o k response has a 3xx status code
func (o *WebSvmModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this web svm modify o k response has a 4xx status code
func (o *WebSvmModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this web svm modify o k response has a 5xx status code
func (o *WebSvmModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this web svm modify o k response a status code equal to that given
func (o *WebSvmModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the web svm modify o k response
func (o *WebSvmModifyOK) Code() int {
	return 200
}

func (o *WebSvmModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] webSvmModifyOK", 200)
}

func (o *WebSvmModifyOK) String() string {
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] webSvmModifyOK", 200)
}

func (o *WebSvmModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWebSvmModifyAccepted creates a WebSvmModifyAccepted with default headers values
func NewWebSvmModifyAccepted() *WebSvmModifyAccepted {
	return &WebSvmModifyAccepted{}
}

/*
WebSvmModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WebSvmModifyAccepted struct {
	Payload *models.WebSvmJobLinkResponse
}

// IsSuccess returns true when this web svm modify accepted response has a 2xx status code
func (o *WebSvmModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this web svm modify accepted response has a 3xx status code
func (o *WebSvmModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this web svm modify accepted response has a 4xx status code
func (o *WebSvmModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this web svm modify accepted response has a 5xx status code
func (o *WebSvmModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this web svm modify accepted response a status code equal to that given
func (o *WebSvmModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the web svm modify accepted response
func (o *WebSvmModifyAccepted) Code() int {
	return 202
}

func (o *WebSvmModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] webSvmModifyAccepted %s", 202, payload)
}

func (o *WebSvmModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] webSvmModifyAccepted %s", 202, payload)
}

func (o *WebSvmModifyAccepted) GetPayload() *models.WebSvmJobLinkResponse {
	return o.Payload
}

func (o *WebSvmModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WebSvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebSvmModifyDefault creates a WebSvmModifyDefault with default headers values
func NewWebSvmModifyDefault(code int) *WebSvmModifyDefault {
	return &WebSvmModifyDefault{
		_statusCode: code,
	}
}

/*
	WebSvmModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9830442 | Client authentication cannot be enabled without a client ca certificate. |
| 9830488 | The certificate is not a "server" certificate. |
| 9830489 | The certificate does not exist for the given SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type WebSvmModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this web svm modify default response has a 2xx status code
func (o *WebSvmModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this web svm modify default response has a 3xx status code
func (o *WebSvmModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this web svm modify default response has a 4xx status code
func (o *WebSvmModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this web svm modify default response has a 5xx status code
func (o *WebSvmModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this web svm modify default response a status code equal to that given
func (o *WebSvmModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the web svm modify default response
func (o *WebSvmModifyDefault) Code() int {
	return o._statusCode
}

func (o *WebSvmModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] web_svm_modify default %s", o._statusCode, payload)
}

func (o *WebSvmModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms/{svm.uuid}/web][%d] web_svm_modify default %s", o._statusCode, payload)
}

func (o *WebSvmModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WebSvmModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
