// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ACLDelete Manages the DACLS or SACLS.
//
// swagger:model acl_delete
type ACLDelete struct {

	// Specifies whether the ACL is for DACL or SACL. It is a required field.
	// The available values are:
	// * access_allow                     - DACL for allow access
	// * access_deny                      - DACL for deny access
	// * audit_success                    - SACL for success access
	// * audit_failure                    - SACL for failure access
	//
	// Example: access_allow
	// Enum: ["access_allow","access_deny","audit_failure","audit_success"]
	Access *string `json:"access,omitempty"`

	// An Access Control Level specifies the access control of the task to be applied. Valid values
	// are "file-directory" or "Storage-Level Access Guard (SLAG)". SLAG is used to apply the
	// specified security descriptors with the task for the volume or qtree. Otherwise, the
	// security descriptors are applied on files and directories at the specified path.
	// The value SLAG is not supported on FlexGroups volumes. The default value is "file-directory"
	// ('-' and '_' are interchangeable).
	//
	// Example: file_directory
	// Enum: ["file_directory","slag"]
	AccessControl *string `json:"access_control,omitempty"`

	// Specifies that permissions on this file or directory cannot be replaced.
	//
	// Example: ["/dir1/dir2/","/parent/dir3"]
	ACLDeleteInlineIgnorePaths []*string `json:"ignore_paths,omitempty"`

	// apply to
	ApplyTo *ApplyTo `json:"apply_to,omitempty"`

	// Specifies how to propagate security settings to child subfolders and files.
	// This setting determines how child files/folders contained within a parent
	// folder inherit access control and audit information from the parent folder.
	// The available values are:
	// * propagate    - propagate inheritable permissions to all subfolders and files
	// * replace      - replace existing permissions on all subfolders and files with inheritable permissions
	//
	// Enum: ["propagate","replace"]
	PropagationMode *string `json:"propagation_mode,omitempty"`
}

// Validate validates this acl delete
func (m *ACLDelete) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplyTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePropagationMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aclDeleteTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["access_allow","access_deny","audit_failure","audit_success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aclDeleteTypeAccessPropEnum = append(aclDeleteTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access
	// Access
	// access_allow
	// END DEBUGGING
	// ACLDeleteAccessAccessAllow captures enum value "access_allow"
	ACLDeleteAccessAccessAllow string = "access_allow"

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access
	// Access
	// access_deny
	// END DEBUGGING
	// ACLDeleteAccessAccessDeny captures enum value "access_deny"
	ACLDeleteAccessAccessDeny string = "access_deny"

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access
	// Access
	// audit_failure
	// END DEBUGGING
	// ACLDeleteAccessAuditFailure captures enum value "audit_failure"
	ACLDeleteAccessAuditFailure string = "audit_failure"

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access
	// Access
	// audit_success
	// END DEBUGGING
	// ACLDeleteAccessAuditSuccess captures enum value "audit_success"
	ACLDeleteAccessAuditSuccess string = "audit_success"
)

// prop value enum
func (m *ACLDelete) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aclDeleteTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ACLDelete) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessEnum("access", "body", *m.Access); err != nil {
		return err
	}

	return nil
}

var aclDeleteTypeAccessControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file_directory","slag"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aclDeleteTypeAccessControlPropEnum = append(aclDeleteTypeAccessControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access_control
	// AccessControl
	// file_directory
	// END DEBUGGING
	// ACLDeleteAccessControlFileDirectory captures enum value "file_directory"
	ACLDeleteAccessControlFileDirectory string = "file_directory"

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// access_control
	// AccessControl
	// slag
	// END DEBUGGING
	// ACLDeleteAccessControlSlag captures enum value "slag"
	ACLDeleteAccessControlSlag string = "slag"
)

// prop value enum
func (m *ACLDelete) validateAccessControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aclDeleteTypeAccessControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ACLDelete) validateAccessControl(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControl) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessControlEnum("access_control", "body", *m.AccessControl); err != nil {
		return err
	}

	return nil
}

func (m *ACLDelete) validateApplyTo(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplyTo) { // not required
		return nil
	}

	if m.ApplyTo != nil {
		if err := m.ApplyTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("apply_to")
			}
			return err
		}
	}

	return nil
}

var aclDeleteTypePropagationModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["propagate","replace"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aclDeleteTypePropagationModePropEnum = append(aclDeleteTypePropagationModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// propagation_mode
	// PropagationMode
	// propagate
	// END DEBUGGING
	// ACLDeletePropagationModePropagate captures enum value "propagate"
	ACLDeletePropagationModePropagate string = "propagate"

	// BEGIN DEBUGGING
	// acl_delete
	// ACLDelete
	// propagation_mode
	// PropagationMode
	// replace
	// END DEBUGGING
	// ACLDeletePropagationModeReplace captures enum value "replace"
	ACLDeletePropagationModeReplace string = "replace"
)

// prop value enum
func (m *ACLDelete) validatePropagationModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aclDeleteTypePropagationModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ACLDelete) validatePropagationMode(formats strfmt.Registry) error {
	if swag.IsZero(m.PropagationMode) { // not required
		return nil
	}

	// value enum
	if err := m.validatePropagationModeEnum("propagation_mode", "body", *m.PropagationMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this acl delete based on the context it is used
func (m *ACLDelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplyTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ACLDelete) contextValidateApplyTo(ctx context.Context, formats strfmt.Registry) error {

	if m.ApplyTo != nil {
		if err := m.ApplyTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("apply_to")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ACLDelete) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ACLDelete) UnmarshalBinary(b []byte) error {
	var res ACLDelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
