// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ActiveDirectoryDiscoveredServer active directory discovered server
//
// swagger:model active_directory_discovered_server
type ActiveDirectoryDiscoveredServer struct {

	// The Active Directory domain that the discovered server is a member of.
	// Example: server1.com
	Domain *string `json:"domain,omitempty"`

	// node
	Node *ActiveDirectoryDiscoveredServerInlineNode `json:"node,omitempty"`

	// The preference level of the server that was discovered.
	// Example: preferred
	// Enum: ["unknown","preferred","favored","adequate"]
	Preference *string `json:"preference,omitempty"`

	// server
	Server *ActiveDirectoryDiscoveredServerReference `json:"server,omitempty"`

	// The status of the connection to the server that was discovered.
	// Example: ok
	// Enum: ["ok","unavailable","slow","expired","undetermined","unreachable"]
	State *string `json:"state,omitempty"`
}

// Validate validates this active directory discovered server
func (m *ActiveDirectoryDiscoveredServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePreference(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServer) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var activeDirectoryDiscoveredServerTypePreferencePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","preferred","favored","adequate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectoryDiscoveredServerTypePreferencePropEnum = append(activeDirectoryDiscoveredServerTypePreferencePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// preference
	// Preference
	// unknown
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerPreferenceUnknown captures enum value "unknown"
	ActiveDirectoryDiscoveredServerPreferenceUnknown string = "unknown"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// preference
	// Preference
	// preferred
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerPreferencePreferred captures enum value "preferred"
	ActiveDirectoryDiscoveredServerPreferencePreferred string = "preferred"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// preference
	// Preference
	// favored
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerPreferenceFavored captures enum value "favored"
	ActiveDirectoryDiscoveredServerPreferenceFavored string = "favored"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// preference
	// Preference
	// adequate
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerPreferenceAdequate captures enum value "adequate"
	ActiveDirectoryDiscoveredServerPreferenceAdequate string = "adequate"
)

// prop value enum
func (m *ActiveDirectoryDiscoveredServer) validatePreferenceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectoryDiscoveredServerTypePreferencePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServer) validatePreference(formats strfmt.Registry) error {
	if swag.IsZero(m.Preference) { // not required
		return nil
	}

	// value enum
	if err := m.validatePreferenceEnum("preference", "body", *m.Preference); err != nil {
		return err
	}

	return nil
}

func (m *ActiveDirectoryDiscoveredServer) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	if m.Server != nil {
		if err := m.Server.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

var activeDirectoryDiscoveredServerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","unavailable","slow","expired","undetermined","unreachable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectoryDiscoveredServerTypeStatePropEnum = append(activeDirectoryDiscoveredServerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// ok
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateOk captures enum value "ok"
	ActiveDirectoryDiscoveredServerStateOk string = "ok"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// unavailable
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateUnavailable captures enum value "unavailable"
	ActiveDirectoryDiscoveredServerStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// slow
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateSlow captures enum value "slow"
	ActiveDirectoryDiscoveredServerStateSlow string = "slow"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// expired
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateExpired captures enum value "expired"
	ActiveDirectoryDiscoveredServerStateExpired string = "expired"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// undetermined
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateUndetermined captures enum value "undetermined"
	ActiveDirectoryDiscoveredServerStateUndetermined string = "undetermined"

	// BEGIN DEBUGGING
	// active_directory_discovered_server
	// ActiveDirectoryDiscoveredServer
	// state
	// State
	// unreachable
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerStateUnreachable captures enum value "unreachable"
	ActiveDirectoryDiscoveredServerStateUnreachable string = "unreachable"
)

// prop value enum
func (m *ActiveDirectoryDiscoveredServer) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectoryDiscoveredServerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServer) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this active directory discovered server based on the context it is used
func (m *ActiveDirectoryDiscoveredServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServer) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *ActiveDirectoryDiscoveredServer) contextValidateServer(ctx context.Context, formats strfmt.Registry) error {

	if m.Server != nil {
		if err := m.Server.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServer) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryDiscoveredServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ActiveDirectoryDiscoveredServerInlineNode active directory discovered server inline node
//
// swagger:model active_directory_discovered_server_inline_node
type ActiveDirectoryDiscoveredServerInlineNode struct {

	// links
	Links *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this active directory discovered server inline node
func (m *ActiveDirectoryDiscoveredServerInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServerInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory discovered server inline node based on the context it is used
func (m *ActiveDirectoryDiscoveredServerInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServerInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerInlineNode) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryDiscoveredServerInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ActiveDirectoryDiscoveredServerInlineNodeInlineLinks active directory discovered server inline node inline links
//
// swagger:model active_directory_discovered_server_inline_node_inline__links
type ActiveDirectoryDiscoveredServerInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this active directory discovered server inline node inline links
func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active directory discovered server inline node inline links based on the context it is used
func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryDiscoveredServerInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
