// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ActiveDirectoryDiscoveredServerReference active directory discovered server reference
//
// swagger:model active_directory_discovered_server_reference
type ActiveDirectoryDiscoveredServerReference struct {

	// The IP address of the server that was discovered.
	// Example: 7.4.3.1
	IP *string `json:"ip,omitempty"`

	// Server Name
	// Example: scspk0659102001
	Name *string `json:"name,omitempty"`

	// The type of the server that was discovered.
	// Example: kerberos
	// Enum: ["unknown","kerberos","ms_ldap","ms_dc","ldap"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this active directory discovered server reference
func (m *ActiveDirectoryDiscoveredServerReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var activeDirectoryDiscoveredServerReferenceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","kerberos","ms_ldap","ms_dc","ldap"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectoryDiscoveredServerReferenceTypeTypePropEnum = append(activeDirectoryDiscoveredServerReferenceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// active_directory_discovered_server_reference
	// ActiveDirectoryDiscoveredServerReference
	// type
	// Type
	// unknown
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerReferenceTypeUnknown captures enum value "unknown"
	ActiveDirectoryDiscoveredServerReferenceTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// active_directory_discovered_server_reference
	// ActiveDirectoryDiscoveredServerReference
	// type
	// Type
	// kerberos
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerReferenceTypeKerberos captures enum value "kerberos"
	ActiveDirectoryDiscoveredServerReferenceTypeKerberos string = "kerberos"

	// BEGIN DEBUGGING
	// active_directory_discovered_server_reference
	// ActiveDirectoryDiscoveredServerReference
	// type
	// Type
	// ms_ldap
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerReferenceTypeMsLdap captures enum value "ms_ldap"
	ActiveDirectoryDiscoveredServerReferenceTypeMsLdap string = "ms_ldap"

	// BEGIN DEBUGGING
	// active_directory_discovered_server_reference
	// ActiveDirectoryDiscoveredServerReference
	// type
	// Type
	// ms_dc
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerReferenceTypeMsDc captures enum value "ms_dc"
	ActiveDirectoryDiscoveredServerReferenceTypeMsDc string = "ms_dc"

	// BEGIN DEBUGGING
	// active_directory_discovered_server_reference
	// ActiveDirectoryDiscoveredServerReference
	// type
	// Type
	// ldap
	// END DEBUGGING
	// ActiveDirectoryDiscoveredServerReferenceTypeLdap captures enum value "ldap"
	ActiveDirectoryDiscoveredServerReferenceTypeLdap string = "ldap"
)

// prop value enum
func (m *ActiveDirectoryDiscoveredServerReference) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectoryDiscoveredServerReferenceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ActiveDirectoryDiscoveredServerReference) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this active directory discovered server reference based on context it is used
func (m *ActiveDirectoryDiscoveredServerReference) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectoryDiscoveredServerReference) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryDiscoveredServerReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
