// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ActiveDirectoryPreferredDc active directory preferred dc
//
// swagger:model active_directory_preferred_dc
type ActiveDirectoryPreferredDc struct {

	// Fully Qualified Domain Name.
	// Example: test.com
	// Max Length: 254
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of the preferred DC. The address can be either an IPv4 or an IPv6 address.
	// Example: 4.4.4.4
	ServerIP *string `json:"server_ip,omitempty"`
}

// Validate validates this active directory preferred dc
func (m *ActiveDirectoryPreferredDc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFqdn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveDirectoryPreferredDc) validateFqdn(formats strfmt.Registry) error {
	if swag.IsZero(m.Fqdn) { // not required
		return nil
	}

	if err := validate.MaxLength("fqdn", "body", *m.Fqdn, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this active directory preferred dc based on context it is used
func (m *ActiveDirectoryPreferredDc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectoryPreferredDc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectoryPreferredDc) UnmarshalBinary(b []byte) error {
	var res ActiveDirectoryPreferredDc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
