// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ActiveDirectorySecurity active directory security
//
// swagger:model active_directory_security
type ActiveDirectorySecurity struct {

	// advertised kdc encryptions
	AdvertisedKdcEncryptions []*string `json:"advertised_kdc_encryptions,omitempty"`
}

// Validate validates this active directory security
func (m *ActiveDirectorySecurity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdvertisedKdcEncryptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var activeDirectorySecurityAdvertisedKdcEncryptionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["des","rc4","aes_128","aes_256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		activeDirectorySecurityAdvertisedKdcEncryptionsItemsEnum = append(activeDirectorySecurityAdvertisedKdcEncryptionsItemsEnum, v)
	}
}

func (m *ActiveDirectorySecurity) validateAdvertisedKdcEncryptionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, activeDirectorySecurityAdvertisedKdcEncryptionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ActiveDirectorySecurity) validateAdvertisedKdcEncryptions(formats strfmt.Registry) error {
	if swag.IsZero(m.AdvertisedKdcEncryptions) { // not required
		return nil
	}

	for i := 0; i < len(m.AdvertisedKdcEncryptions); i++ {
		if swag.IsZero(m.AdvertisedKdcEncryptions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateAdvertisedKdcEncryptionsItemsEnum("advertised_kdc_encryptions"+"."+strconv.Itoa(i), "body", *m.AdvertisedKdcEncryptions[i]); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this active directory security based on context it is used
func (m *ActiveDirectorySecurity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ActiveDirectorySecurity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveDirectorySecurity) UnmarshalBinary(b []byte) error {
	var res ActiveDirectorySecurity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
