// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AggrSpaceEfficiency aggr space efficiency
//
// swagger:model aggr_space_efficiency
type AggrSpaceEfficiency struct {

	// Indicates whether or not aggregate has auto adaptive compression savings.
	// Read Only: true
	AutoAdaptiveCompressionSavings *bool `json:"auto_adaptive_compression_savings,omitempty"`

	// Indicates whether or not cross volume background deduplication is enabled.
	// Read Only: true
	CrossVolumeBackgroundDedupe *bool `json:"cross_volume_background_dedupe,omitempty"`

	// Indicates whether or not aggregate has cross volume deduplication savings.
	// Read Only: true
	CrossVolumeDedupeSavings *bool `json:"cross_volume_dedupe_savings,omitempty"`

	// Indicates whether or not cross volume inline deduplication is enabled.
	// Read Only: true
	CrossVolumeInlineDedupe *bool `json:"cross_volume_inline_dedupe,omitempty"`

	// Indicates whether Workload Informed TSSE is enabled on the system.
	EnableWorkloadInformedTsse *bool `json:"enable_workload_informed_tsse,omitempty"`

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// Minimum amount of used data in aggregate required to trigger cold compression on TSSE volumes.
	WiseTsseMinUsedCapacityPct *int64 `json:"wise_tsse_min_used_capacity_pct,omitempty"`
}

// Validate validates this aggr space efficiency
func (m *AggrSpaceEfficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggr space efficiency based on the context it is used
func (m *AggrSpaceEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutoAdaptiveCompressionSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeBackgroundDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeDedupeSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeInlineDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggrSpaceEfficiency) contextValidateAutoAdaptiveCompressionSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "auto_adaptive_compression_savings", "body", m.AutoAdaptiveCompressionSavings); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateCrossVolumeBackgroundDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cross_volume_background_dedupe", "body", m.CrossVolumeBackgroundDedupe); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateCrossVolumeDedupeSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cross_volume_dedupe_savings", "body", m.CrossVolumeDedupeSavings); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateCrossVolumeInlineDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cross_volume_inline_dedupe", "body", m.CrossVolumeInlineDedupe); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *AggrSpaceEfficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggrSpaceEfficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggrSpaceEfficiency) UnmarshalBinary(b []byte) error {
	var res AggrSpaceEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
