// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Aggregate aggregate
//
// swagger:model aggregate
type Aggregate struct {

	// links
	Links *AggregateInlineLinks `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	AggregateInlineTags []*string `json:"_tags,omitempty"`

	// block storage
	BlockStorage *AggregateInlineBlockStorage `json:"block_storage,omitempty"`

	// cloud storage
	CloudStorage *AggregateInlineCloudStorage `json:"cloud_storage,omitempty"`

	// Timestamp of aggregate creation.
	// Example: 2018-01-01 12:00:00-04:00
	// Read Only: true
	CreateTime *string `json:"create_time,omitempty"`

	// data encryption
	DataEncryption *AggregateInlineDataEncryption `json:"data_encryption,omitempty"`

	// dr home node
	DrHomeNode *AggregateInlineDrHomeNode `json:"dr_home_node,omitempty"`

	// home node
	HomeNode *AggregateInlineHomeNode `json:"home_node,omitempty"`

	// inactive data reporting
	InactiveDataReporting *AggregateInlineInactiveDataReporting `json:"inactive_data_reporting,omitempty"`

	// inode attributes
	InodeAttributes *AggregateInlineInodeAttributes `json:"inode_attributes,omitempty"`

	// Specifies whether the aggregate is in a spares low condition on any of the RAID groups.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: false
	// Read Only: true
	IsSpareLow *bool `json:"is_spare_low,omitempty"`

	// metric
	Metric *AggregateInlineMetric `json:"metric,omitempty"`

	// Aggregate name.
	// Example: node1_aggr_1
	Name *string `json:"name,omitempty"`

	// node
	Node *AggregateInlineNode `json:"node,omitempty"`

	// Specifies whether or not SIDL is enabled on the aggregate.
	SidlEnabled *bool `json:"sidl_enabled,omitempty"`

	// SnapLock type.
	// Enum: ["non_snaplock","compliance","enterprise"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// snapshot
	Snapshot *AggregateInlineSnapshot `json:"snapshot,omitempty"`

	// space
	Space *AggregateInlineSpace `json:"space,omitempty"`

	// Operational state of the aggregate.
	// Enum: ["online","onlining","offline","offlining","relocating","unmounted","restricted","inconsistent","failed","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *AggregateInlineStatistics `json:"statistics,omitempty"`

	// Aggregate UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Number of volumes in the aggregate.
	// Read Only: true
	VolumeCount *int64 `json:"volume-count,omitempty"`
}

// Validate validates this aggregate
func (m *Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlockStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDrHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInactiveDataReporting(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInodeAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateAggregateInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateInlineTags) { // not required
		return nil
	}

	iAggregateInlineTagsSize := int64(len(m.AggregateInlineTags))

	if err := validate.MaxItems("_tags", "body", iAggregateInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) validateBlockStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockStorage) { // not required
		return nil
	}

	if m.BlockStorage != nil {
		if err := m.BlockStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateCloudStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudStorage) { // not required
		return nil
	}

	if m.CloudStorage != nil {
		if err := m.CloudStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateDataEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEncryption) { // not required
		return nil
	}

	if m.DataEncryption != nil {
		if err := m.DataEncryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateDrHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(m.DrHomeNode) { // not required
		return nil
	}

	if m.DrHomeNode != nil {
		if err := m.DrHomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(m.HomeNode) { // not required
		return nil
	}

	if m.HomeNode != nil {
		if err := m.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateInactiveDataReporting(formats strfmt.Registry) error {
	if swag.IsZero(m.InactiveDataReporting) { // not required
		return nil
	}

	if m.InactiveDataReporting != nil {
		if err := m.InactiveDataReporting.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("inactive_data_reporting")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateInodeAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.InodeAttributes) { // not required
		return nil
	}

	if m.InodeAttributes != nil {
		if err := m.InodeAttributes.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("inode_attributes")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var aggregateTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["non_snaplock","compliance","enterprise"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateTypeSnaplockTypePropEnum = append(aggregateTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// AggregateSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	AggregateSnaplockTypeNonSnaplock string = "non_snaplock"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// AggregateSnaplockTypeCompliance captures enum value "compliance"
	AggregateSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// AggregateSnaplockTypeEnterprise captures enum value "enterprise"
	AggregateSnaplockTypeEnterprise string = "enterprise"
)

// prop value enum
func (m *Aggregate) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Aggregate) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnaplockTypeEnum("snaplock_type", "body", *m.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var aggregateTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","onlining","offline","offlining","relocating","unmounted","restricted","inconsistent","failed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateTypeStatePropEnum = append(aggregateTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// online
	// END DEBUGGING
	// AggregateStateOnline captures enum value "online"
	AggregateStateOnline string = "online"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// onlining
	// END DEBUGGING
	// AggregateStateOnlining captures enum value "onlining"
	AggregateStateOnlining string = "onlining"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// offline
	// END DEBUGGING
	// AggregateStateOffline captures enum value "offline"
	AggregateStateOffline string = "offline"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// offlining
	// END DEBUGGING
	// AggregateStateOfflining captures enum value "offlining"
	AggregateStateOfflining string = "offlining"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// relocating
	// END DEBUGGING
	// AggregateStateRelocating captures enum value "relocating"
	AggregateStateRelocating string = "relocating"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// unmounted
	// END DEBUGGING
	// AggregateStateUnmounted captures enum value "unmounted"
	AggregateStateUnmounted string = "unmounted"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// restricted
	// END DEBUGGING
	// AggregateStateRestricted captures enum value "restricted"
	AggregateStateRestricted string = "restricted"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// inconsistent
	// END DEBUGGING
	// AggregateStateInconsistent captures enum value "inconsistent"
	AggregateStateInconsistent string = "inconsistent"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// failed
	// END DEBUGGING
	// AggregateStateFailed captures enum value "failed"
	AggregateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// aggregate
	// Aggregate
	// state
	// State
	// unknown
	// END DEBUGGING
	// AggregateStateUnknown captures enum value "unknown"
	AggregateStateUnknown string = "unknown"
)

// prop value enum
func (m *Aggregate) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Aggregate) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate based on the context it is used
func (m *Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloudStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDrHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInactiveDataReporting(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInodeAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSpareLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateBlockStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BlockStorage != nil {
		if err := m.BlockStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateCloudStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudStorage != nil {
		if err := m.CloudStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) contextValidateDataEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.DataEncryption != nil {
		if err := m.DataEncryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_encryption")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateDrHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if m.DrHomeNode != nil {
		if err := m.DrHomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if m.HomeNode != nil {
		if err := m.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateInactiveDataReporting(ctx context.Context, formats strfmt.Registry) error {

	if m.InactiveDataReporting != nil {
		if err := m.InactiveDataReporting.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("inactive_data_reporting")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateInodeAttributes(ctx context.Context, formats strfmt.Registry) error {

	if m.InodeAttributes != nil {
		if err := m.InodeAttributes.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("inode_attributes")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateIsSpareLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_spare_low", "body", m.IsSpareLow); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Aggregate) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Aggregate) contextValidateVolumeCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume-count", "body", m.VolumeCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Aggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Aggregate) UnmarshalBinary(b []byte) error {
	var res Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineBlockStorage Configuration information for the locally attached portion of the aggregate. When a cloud store is also used by this aggregate, this is referred to as the performance tier.
//
// swagger:model aggregate_inline_block_storage
type AggregateInlineBlockStorage struct {

	// hybrid cache
	HybridCache *AggregateInlineBlockStorageInlineHybridCache `json:"hybrid_cache,omitempty"`

	// mirror
	Mirror *AggregateInlineBlockStorageInlineMirror `json:"mirror,omitempty"`

	// Plex reference for each plex in the aggregate.
	// Read Only: true
	Plexes []*PlexReference `json:"plexes,omitempty"`

	// primary
	Primary *AggregateInlineBlockStorageInlinePrimary `json:"primary,omitempty"`

	// Type of aggregate.
	// Read Only: true
	// Enum: ["hdd","hybrid","lun","ssd","vmdisk"]
	StorageType *string `json:"storage_type,omitempty"`

	// If true, aggregate is using shared disks.
	// Read Only: true
	UsesPartitions *bool `json:"uses_partitions,omitempty"`
}

// Validate validates this aggregate inline block storage
func (m *AggregateInlineBlockStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHybridCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMirror(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlexes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineBlockStorage) validateHybridCache(formats strfmt.Registry) error {
	if swag.IsZero(m.HybridCache) { // not required
		return nil
	}

	if m.HybridCache != nil {
		if err := m.HybridCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "hybrid_cache")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineBlockStorage) validateMirror(formats strfmt.Registry) error {
	if swag.IsZero(m.Mirror) { // not required
		return nil
	}

	if m.Mirror != nil {
		if err := m.Mirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineBlockStorage) validatePlexes(formats strfmt.Registry) error {
	if swag.IsZero(m.Plexes) { // not required
		return nil
	}

	for i := 0; i < len(m.Plexes); i++ {
		if swag.IsZero(m.Plexes[i]) { // not required
			continue
		}

		if m.Plexes[i] != nil {
			if err := m.Plexes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "plexes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateInlineBlockStorage) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(m.Primary) { // not required
		return nil
	}

	if m.Primary != nil {
		if err := m.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineBlockStorageTypeStorageTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hdd","hybrid","lun","ssd","vmdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageTypeStorageTypePropEnum = append(aggregateInlineBlockStorageTypeStorageTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// hdd
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeHdd captures enum value "hdd"
	AggregateInlineBlockStorageStorageTypeHdd string = "hdd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// hybrid
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeHybrid captures enum value "hybrid"
	AggregateInlineBlockStorageStorageTypeHybrid string = "hybrid"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeLun captures enum value "lun"
	AggregateInlineBlockStorageStorageTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageStorageTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// vmdisk
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeVmdisk captures enum value "vmdisk"
	AggregateInlineBlockStorageStorageTypeVmdisk string = "vmdisk"
)

// prop value enum
func (m *AggregateInlineBlockStorage) validateStorageTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageTypeStorageTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorage) validateStorageType(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageType) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageTypeEnum("block_storage"+"."+"storage_type", "body", *m.StorageType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline block storage based on the context it is used
func (m *AggregateInlineBlockStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHybridCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePlexes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsesPartitions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineBlockStorage) contextValidateHybridCache(ctx context.Context, formats strfmt.Registry) error {

	if m.HybridCache != nil {
		if err := m.HybridCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "hybrid_cache")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineBlockStorage) contextValidateMirror(ctx context.Context, formats strfmt.Registry) error {

	if m.Mirror != nil {
		if err := m.Mirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineBlockStorage) contextValidatePlexes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"plexes", "body", []*PlexReference(m.Plexes)); err != nil {
		return err
	}

	for i := 0; i < len(m.Plexes); i++ {

		if m.Plexes[i] != nil {
			if err := m.Plexes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "plexes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateInlineBlockStorage) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if m.Primary != nil {
		if err := m.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineBlockStorage) contextValidateStorageType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"storage_type", "body", m.StorageType); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorage) contextValidateUsesPartitions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"uses_partitions", "body", m.UsesPartitions); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineBlockStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineBlockStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineBlockStorageInlineHybridCache Contains the configuration for the hybrid cache. The hybrid cache is made up of either whole SSDs or storage pool SSDs.
//
// swagger:model aggregate_inline_block_storage_inline_hybrid_cache
type AggregateInlineBlockStorageInlineHybridCache struct {

	// Number of disks used in the cache tier of the aggregate. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 6
	DiskCount *int64 `json:"disk_count,omitempty"`

	// Type of disk being used by the aggregate's cache tier.
	// Read Only: true
	// Enum: ["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]
	DiskType *string `json:"disk_type,omitempty"`

	// Specifies whether the aggregate uses HDDs with SSDs as a cache.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Option to specify the maximum number of disks that can be included in a RAID group.
	// Example: 24
	RaidSize *int64 `json:"raid_size,omitempty"`

	// RAID type for SSD cache of the aggregate. Only provided when hybrid_cache.enabled is 'true'.
	// Enum: ["raid_dp","raid_tec","raid4"]
	RaidType *string `json:"raid_type,omitempty"`

	// simulated raid groups
	SimulatedRaidGroups []*AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0 `json:"simulated_raid_groups,omitempty"`

	// Total usable space in bytes of SSD cache. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 1612709888
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// List of storage pool properties and allocation_units_count for aggregate.
	StoragePools []*AggregateBlockStorageHybridCacheStoragePoolsItems0 `json:"storage_pools,omitempty"`

	// Space used in bytes of SSD cache. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 26501122
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this aggregate inline block storage inline hybrid cache
func (m *AggregateInlineBlockStorageInlineHybridCache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSimulatedRaidGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePools(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum = append(aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// fc
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeFc captures enum value "fc"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeFc string = "fc"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeLun captures enum value "lun"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// nl_sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeNlSas captures enum value "nl_sas"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeNlSas string = "nl_sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// nvme_ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeNvmeSsd captures enum value "nvme_ssd"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeNvmeSsd string = "nvme_ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSas captures enum value "sas"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// sata
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSata captures enum value "sata"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSata string = "sata"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// scsi
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeScsi captures enum value "scsi"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeScsi string = "scsi"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd_cap
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdCap captures enum value "ssd_cap"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd_zns
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdZns captures enum value "ssd_zns"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// vm_disk
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeVMDisk captures enum value "vm_disk"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeVMDisk string = "vm_disk"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlineHybridCache) validateDiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) validateDiskType(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskType) { // not required
		return nil
	}

	// value enum
	if err := m.validateDiskTypeEnum("block_storage"+"."+"hybrid_cache"+"."+"disk_type", "body", *m.DiskType); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum = append(aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidDp captures enum value "raid_dp"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidTec captures enum value "raid_tec"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaid4 captures enum value "raid4"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaid4 string = "raid4"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlineHybridCache) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(m.RaidType) { // not required
		return nil
	}

	// value enum
	if err := m.validateRaidTypeEnum("block_storage"+"."+"hybrid_cache"+"."+"raid_type", "body", *m.RaidType); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) validateSimulatedRaidGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.SimulatedRaidGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.SimulatedRaidGroups); i++ {
		if swag.IsZero(m.SimulatedRaidGroups[i]) { // not required
			continue
		}

		if m.SimulatedRaidGroups[i] != nil {
			if err := m.SimulatedRaidGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "hybrid_cache" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) validateStoragePools(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePools) { // not required
		return nil
	}

	for i := 0; i < len(m.StoragePools); i++ {
		if swag.IsZero(m.StoragePools[i]) { // not required
			continue
		}

		if m.StoragePools[i] != nil {
			if err := m.StoragePools[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "hybrid_cache" + "." + "storage_pools" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline hybrid cache based on the context it is used
func (m *AggregateInlineBlockStorageInlineHybridCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDiskType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSimulatedRaidGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStoragePools(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateDiskType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"hybrid_cache"+"."+"disk_type", "body", m.DiskType); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"hybrid_cache"+"."+"enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateSimulatedRaidGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SimulatedRaidGroups); i++ {

		if m.SimulatedRaidGroups[i] != nil {
			if err := m.SimulatedRaidGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "hybrid_cache" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"hybrid_cache"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateStoragePools(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StoragePools); i++ {

		if m.StoragePools[i] != nil {
			if err := m.StoragePools[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "hybrid_cache" + "." + "storage_pools" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateInlineBlockStorageInlineHybridCache) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"hybrid_cache"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlineHybridCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlineHybridCache) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlineHybridCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0 aggregate block storage hybrid cache simulated raid groups items0
//
// swagger:model AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0
type AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0 struct {

	// Number of added data disks in RAID group.
	AddedDataDiskCount *int64 `json:"added_data_disk_count,omitempty"`

	// Number of added parity disks in RAID group.
	AddedParityDiskCount *int64 `json:"added_parity_disk_count,omitempty"`

	// Number of existing data disks in the RAID group.
	ExistingDataDiskCount *int64 `json:"existing_data_disk_count,omitempty"`

	// Number of existing parity disks in the RAID group.
	ExistingParityDiskCount *int64 `json:"existing_parity_disk_count,omitempty"`

	// Indicates whether the disk is partitioned (true) or whole (false).
	IsPartition *bool `json:"is_partition,omitempty"`

	// Name of the raid group.
	Name *string `json:"name,omitempty"`

	// Usable size of each disk, in bytes.
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this aggregate block storage hybrid cache simulated raid groups items0
func (m *AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this aggregate block storage hybrid cache simulated raid groups items0 based on context it is used
func (m *AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateBlockStorageHybridCacheSimulatedRaidGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateBlockStorageHybridCacheStoragePoolsItems0 aggregate block storage hybrid cache storage pools items0
//
// swagger:model AggregateBlockStorageHybridCacheStoragePoolsItems0
type AggregateBlockStorageHybridCacheStoragePoolsItems0 struct {

	// Allocation count of storage pool.
	AllocationUnitsCount *int32 `json:"allocation_units_count,omitempty"`

	// storage pool
	StoragePool *StoragePoolReference `json:"storage_pool,omitempty"`
}

// Validate validates this aggregate block storage hybrid cache storage pools items0
func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStoragePool(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) validateStoragePool(formats strfmt.Registry) error {
	if swag.IsZero(m.StoragePool) { // not required
		return nil
	}

	if m.StoragePool != nil {
		if err := m.StoragePool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate block storage hybrid cache storage pools items0 based on the context it is used
func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) contextValidateStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if m.StoragePool != nil {
		if err := m.StoragePool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateBlockStorageHybridCacheStoragePoolsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateBlockStorageHybridCacheStoragePoolsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineBlockStorageInlineMirror aggregate inline block storage inline mirror
//
// swagger:model aggregate_inline_block_storage_inline_mirror
type AggregateInlineBlockStorageInlineMirror struct {

	// Aggregate is SyncMirror protected
	// Example: false
	Enabled *bool `json:"enabled,omitempty"`

	// state
	// Read Only: true
	// Enum: ["unmirrored","normal","degraded","resynchronizing","failed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this aggregate inline block storage inline mirror
func (m *AggregateInlineBlockStorageInlineMirror) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unmirrored","normal","degraded","resynchronizing","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum = append(aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// unmirrored
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateUnmirrored captures enum value "unmirrored"
	AggregateInlineBlockStorageInlineMirrorStateUnmirrored string = "unmirrored"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// normal
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateNormal captures enum value "normal"
	AggregateInlineBlockStorageInlineMirrorStateNormal string = "normal"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// degraded
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateDegraded captures enum value "degraded"
	AggregateInlineBlockStorageInlineMirrorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// resynchronizing
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateResynchronizing captures enum value "resynchronizing"
	AggregateInlineBlockStorageInlineMirrorStateResynchronizing string = "resynchronizing"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// failed
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateFailed captures enum value "failed"
	AggregateInlineBlockStorageInlineMirrorStateFailed string = "failed"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlineMirror) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlineMirror) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("block_storage"+"."+"mirror"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline mirror based on the context it is used
func (m *AggregateInlineBlockStorageInlineMirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlineMirror) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"mirror"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlineMirror) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlineMirror) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlineMirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineBlockStorageInlinePrimary Configuration information for the primary storage portion of the aggregate. This excludes the hybrid cache details.
//
// swagger:model aggregate_inline_block_storage_inline_primary
type AggregateInlineBlockStorageInlinePrimary struct {

	// The checksum style used by the aggregate.
	// Enum: ["block","advanced_zoned","mixed"]
	ChecksumStyle *string `json:"checksum_style,omitempty"`

	// The class of disks being used by the aggregate.
	// Example: performance
	// Enum: ["capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]
	DiskClass *string `json:"disk_class,omitempty"`

	// Number of disks used in the aggregate. This includes parity disks, but excludes disks in the hybrid cache.
	// Example: 8
	DiskCount *int64 `json:"disk_count,omitempty"`

	// The type of disk being used by the aggregate.
	// Read Only: true
	// Enum: ["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]
	DiskType *string `json:"disk_type,omitempty"`

	// Option to specify the maximum number of disks that can be included in a RAID group.
	// Example: 16
	RaidSize *int64 `json:"raid_size,omitempty"`

	// RAID type of the aggregate.
	// Enum: ["raid_dp","raid_tec","raid0","raid4","mixed_raid_type"]
	RaidType *string `json:"raid_type,omitempty"`

	// simulated raid groups
	SimulatedRaidGroups []*AggregateBlockStoragePrimarySimulatedRaidGroupsItems0 `json:"simulated_raid_groups,omitempty"`
}

// Validate validates this aggregate inline block storage inline primary
func (m *AggregateInlineBlockStorageInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksumStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskClass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSimulatedRaidGroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["block","advanced_zoned","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// block
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleBlock captures enum value "block"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleBlock string = "block"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// advanced_zoned
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleAdvancedZoned captures enum value "advanced_zoned"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleAdvancedZoned string = "advanced_zoned"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// mixed
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleMixed captures enum value "mixed"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleMixed string = "mixed"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlinePrimary) validateChecksumStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) validateChecksumStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.ChecksumStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateChecksumStyleEnum("block_storage"+"."+"primary"+"."+"checksum_style", "body", *m.ChecksumStyle); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// capacity
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassCapacity captures enum value "capacity"
	AggregateInlineBlockStorageInlinePrimaryDiskClassCapacity string = "capacity"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// performance
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassPerformance captures enum value "performance"
	AggregateInlineBlockStorageInlinePrimaryDiskClassPerformance string = "performance"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// archive
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassArchive captures enum value "archive"
	AggregateInlineBlockStorageInlinePrimaryDiskClassArchive string = "archive"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// solid_state
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassSolidState captures enum value "solid_state"
	AggregateInlineBlockStorageInlinePrimaryDiskClassSolidState string = "solid_state"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// array
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassArray captures enum value "array"
	AggregateInlineBlockStorageInlinePrimaryDiskClassArray string = "array"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// virtual
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassVirtual captures enum value "virtual"
	AggregateInlineBlockStorageInlinePrimaryDiskClassVirtual string = "virtual"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// data_center
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassDataCenter captures enum value "data_center"
	AggregateInlineBlockStorageInlinePrimaryDiskClassDataCenter string = "data_center"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// capacity_flash
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassCapacityFlash captures enum value "capacity_flash"
	AggregateInlineBlockStorageInlinePrimaryDiskClassCapacityFlash string = "capacity_flash"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlinePrimary) validateDiskClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) validateDiskClass(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskClass) { // not required
		return nil
	}

	// value enum
	if err := m.validateDiskClassEnum("block_storage"+"."+"primary"+"."+"disk_class", "body", *m.DiskClass); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// fc
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeFc captures enum value "fc"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeFc string = "fc"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeLun captures enum value "lun"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// nl_sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeNlSas captures enum value "nl_sas"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeNlSas string = "nl_sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// nvme_ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeNvmeSsd captures enum value "nvme_ssd"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeNvmeSsd string = "nvme_ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSas captures enum value "sas"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// sata
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSata captures enum value "sata"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSata string = "sata"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// scsi
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeScsi captures enum value "scsi"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeScsi string = "scsi"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd_cap
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdCap captures enum value "ssd_cap"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd_zns
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdZns captures enum value "ssd_zns"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// vm_disk
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeVMDisk captures enum value "vm_disk"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeVMDisk string = "vm_disk"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlinePrimary) validateDiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) validateDiskType(formats strfmt.Registry) error {
	if swag.IsZero(m.DiskType) { // not required
		return nil
	}

	// value enum
	if err := m.validateDiskTypeEnum("block_storage"+"."+"primary"+"."+"disk_type", "body", *m.DiskType); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid0","raid4","mixed_raid_type"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidDp captures enum value "raid_dp"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidTec captures enum value "raid_tec"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid0
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid0 captures enum value "raid0"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid0 string = "raid0"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid4 captures enum value "raid4"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid4 string = "raid4"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// mixed_raid_type
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeMixedRaidType captures enum value "mixed_raid_type"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeMixedRaidType string = "mixed_raid_type"
)

// prop value enum
func (m *AggregateInlineBlockStorageInlinePrimary) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(m.RaidType) { // not required
		return nil
	}

	// value enum
	if err := m.validateRaidTypeEnum("block_storage"+"."+"primary"+"."+"raid_type", "body", *m.RaidType); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) validateSimulatedRaidGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.SimulatedRaidGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.SimulatedRaidGroups); i++ {
		if swag.IsZero(m.SimulatedRaidGroups[i]) { // not required
			continue
		}

		if m.SimulatedRaidGroups[i] != nil {
			if err := m.SimulatedRaidGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "primary" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline primary based on the context it is used
func (m *AggregateInlineBlockStorageInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDiskType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSimulatedRaidGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) contextValidateDiskType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"primary"+"."+"disk_type", "body", m.DiskType); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineBlockStorageInlinePrimary) contextValidateSimulatedRaidGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SimulatedRaidGroups); i++ {

		if m.SimulatedRaidGroups[i] != nil {
			if err := m.SimulatedRaidGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "primary" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlinePrimary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineBlockStorageInlinePrimary) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0 aggregate block storage primary simulated raid groups items0
//
// swagger:model AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
type AggregateBlockStoragePrimarySimulatedRaidGroupsItems0 struct {

	// Number of added data disks in RAID group.
	AddedDataDiskCount *int64 `json:"added_data_disk_count,omitempty"`

	// Number of added parity disks in RAID group.
	AddedParityDiskCount *int64 `json:"added_parity_disk_count,omitempty"`

	// Number of data disks in RAID group.
	DataDiskCount *int64 `json:"data_disk_count,omitempty"`

	// Number of existing data disks in the RAID group.
	ExistingDataDiskCount *int64 `json:"existing_data_disk_count,omitempty"`

	// Number of existing parity disks in the RAID group.
	ExistingParityDiskCount *int64 `json:"existing_parity_disk_count,omitempty"`

	// Indicates whether the disk is partitioned (true) or whole (false).
	IsPartition *bool `json:"is_partition,omitempty"`

	// Name of the raid group.
	Name *string `json:"name,omitempty"`

	// Number of parity disks in RAID group.
	ParityDiskCount *int64 `json:"parity_disk_count,omitempty"`

	// RAID type of the aggregate.
	// Enum: ["raid_dp","raid_tec","raid0","raid4"]
	RaidType *string `json:"raid_type,omitempty"`

	// Usable size of each disk, in bytes.
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this aggregate block storage primary simulated raid groups items0
func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid0","raid4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum = append(aggregateBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidDp captures enum value "raid_dp"
	AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidTec captures enum value "raid_tec"
	AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid0
	// END DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid0 captures enum value "raid0"
	AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid0 string = "raid0"

	// BEGIN DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid4 captures enum value "raid4"
	AggregateBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid4 string = "raid4"
)

// prop value enum
func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(m.RaidType) { // not required
		return nil
	}

	// value enum
	if err := m.validateRaidTypeEnum("raid_type", "body", *m.RaidType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this aggregate block storage primary simulated raid groups items0 based on context it is used
func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateBlockStoragePrimarySimulatedRaidGroupsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateBlockStoragePrimarySimulatedRaidGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineCloudStorage Configuration information for the cloud storage portion of the aggregate. This is referred to as the capacity tier.
//
// swagger:model aggregate_inline_cloud_storage
type AggregateInlineCloudStorage struct {

	// Specifies whether the aggregate is eligible for a cloud store to be attached.
	// Read Only: true
	AttachEligible *bool `json:"attach_eligible,omitempty"`

	// Specifies the minimum percentage of performance tier free space that must exist in order for migration of data from the capacity tier to performance tier to be allowed. Only valid for PATCH operations.
	MigrateThreshold *int64 `json:"migrate_threshold,omitempty"`

	// Configuration information for each cloud storage portion of the aggregate.
	// Read Only: true
	Stores []*CloudStorageTier `json:"stores,omitempty"`

	// The percentage of space in the performance tier that must be used before data is tiered out to the cloud store. Only valid for PATCH operations.
	TieringFullnessThreshold *int64 `json:"tiering_fullness_threshold,omitempty"`
}

// Validate validates this aggregate inline cloud storage
func (m *AggregateInlineCloudStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStores(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineCloudStorage) validateStores(formats strfmt.Registry) error {
	if swag.IsZero(m.Stores) { // not required
		return nil
	}

	for i := 0; i < len(m.Stores); i++ {
		if swag.IsZero(m.Stores[i]) { // not required
			continue
		}

		if m.Stores[i] != nil {
			if err := m.Stores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cloud_storage" + "." + "stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline cloud storage based on the context it is used
func (m *AggregateInlineCloudStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAttachEligible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineCloudStorage) contextValidateAttachEligible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud_storage"+"."+"attach_eligible", "body", m.AttachEligible); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineCloudStorage) contextValidateStores(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cloud_storage"+"."+"stores", "body", []*CloudStorageTier(m.Stores)); err != nil {
		return err
	}

	for i := 0; i < len(m.Stores); i++ {

		if m.Stores[i] != nil {
			if err := m.Stores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cloud_storage" + "." + "stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineCloudStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineCloudStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineCloudStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineDataEncryption aggregate inline data encryption
//
// swagger:model aggregate_inline_data_encryption
type AggregateInlineDataEncryption struct {

	// Specifies whether the aggregate uses self-encrypting drives with data protection enabled.
	// Read Only: true
	DriveProtectionEnabled *bool `json:"drive_protection_enabled,omitempty"`

	// Specifies whether NetApp aggregate encryption is enabled. All data in the aggregate is encrypted.
	SoftwareEncryptionEnabled *bool `json:"software_encryption_enabled,omitempty"`
}

// Validate validates this aggregate inline data encryption
func (m *AggregateInlineDataEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline data encryption based on the context it is used
func (m *AggregateInlineDataEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDriveProtectionEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineDataEncryption) contextValidateDriveProtectionEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_encryption"+"."+"drive_protection_enabled", "body", m.DriveProtectionEnabled); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineDataEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineDataEncryption) UnmarshalBinary(b []byte) error {
	var res AggregateInlineDataEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineDrHomeNode Node where the aggregate resides after disaster recovery. The value for this field might differ from the 'node' field during switchover.
//
// swagger:model aggregate_inline_dr_home_node
type AggregateInlineDrHomeNode struct {

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline dr home node
func (m *AggregateInlineDrHomeNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline dr home node based on the context it is used
func (m *AggregateInlineDrHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineDrHomeNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineDrHomeNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineDrHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineHomeNode Node where the aggregate resides after giveback. The value for this field might differ from the value of the 'node' field during takeover.
//
// swagger:model aggregate_inline_home_node
type AggregateInlineHomeNode struct {

	// links
	Links *AggregateInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline home node
func (m *AggregateInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline home node based on the context it is used
func (m *AggregateInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineHomeNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineHomeNodeInlineLinks aggregate inline home node inline links
//
// swagger:model aggregate_inline_home_node_inline__links
type AggregateInlineHomeNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline home node inline links
func (m *AggregateInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline home node inline links based on the context it is used
func (m *AggregateInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineInactiveDataReporting aggregate inline inactive data reporting
//
// swagger:model aggregate_inline_inactive_data_reporting
type AggregateInlineInactiveDataReporting struct {

	// Specifies whether or not inactive data reporting is enabled on the aggregate.
	Enabled *bool `json:"enabled,omitempty"`

	// Timestamp at which inactive data reporting was enabled on the aggregate.
	// Example: 2019-12-12 12:00:00-04:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this aggregate inline inactive data reporting
func (m *AggregateInlineInactiveDataReporting) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineInactiveDataReporting) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("inactive_data_reporting"+"."+"start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline inactive data reporting based on the context it is used
func (m *AggregateInlineInactiveDataReporting) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineInactiveDataReporting) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "inactive_data_reporting"+"."+"start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineInactiveDataReporting) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineInactiveDataReporting) UnmarshalBinary(b []byte) error {
	var res AggregateInlineInactiveDataReporting
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineInodeAttributes aggregate inline inode attributes
//
// swagger:model aggregate_inline_inode_attributes
type AggregateInlineInodeAttributes struct {

	// Number of files that can currently be stored on disk for system metadata files. This number will dynamically increase as more system files are created.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 31136
	FilePrivateCapacity *int64 `json:"file_private_capacity,omitempty"`

	// Number of files that can currently be stored on disk for user-visible files.  This number will dynamically increase as more user-visible files are created.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 31136
	FilePublicCapacity *int64 `json:"file_public_capacity,omitempty"`

	// Number of system metadata files used. If the referenced file system is restricted or offline, a value of 0 is returned.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 502
	FilesPrivateUsed *int64 `json:"files_private_used,omitempty"`

	// Maximum number of user-visible files that this referenced file system can currently hold. If the referenced file system is restricted or offline, a value of 0 is returned.
	// Example: 31136
	FilesTotal *int64 `json:"files_total,omitempty"`

	// Number of user-visible files used in the referenced file system. If the referenced file system is restricted or offline, a value of 0 is returned.
	// Example: 97
	FilesUsed *int64 `json:"files_used,omitempty"`

	// The count of the maximum number of user-visible files currently allowable on the referenced file system.
	// Example: 31136
	MaxFilesAvailable *int64 `json:"max_files_available,omitempty"`

	// The largest value to which the maxfiles-available parameter can be increased by reconfiguration, on the referenced file system.
	// Example: 2844525
	MaxFilesPossible *int64 `json:"max_files_possible,omitempty"`

	// The number of user-visible files currently in use on the referenced file system.
	// Example: 97
	MaxFilesUsed *int64 `json:"max_files_used,omitempty"`

	// The percentage of disk space currently in use based on user-visible file count on the referenced file system.
	// Example: 5
	// Maximum: 100
	// Minimum: 0
	UsedPercent *int64 `json:"used_percent,omitempty"`

	// The inofile-version of the aggregate. If the referenced file system is restricted or offline, a value of 0 is returned.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 4
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this aggregate inline inode attributes
func (m *AggregateInlineInodeAttributes) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUsedPercent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineInodeAttributes) validateUsedPercent(formats strfmt.Registry) error {
	if swag.IsZero(m.UsedPercent) { // not required
		return nil
	}

	if err := validate.MinimumInt("inode_attributes"+"."+"used_percent", "body", *m.UsedPercent, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("inode_attributes"+"."+"used_percent", "body", *m.UsedPercent, 100, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline inode attributes based on the context it is used
func (m *AggregateInlineInodeAttributes) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineInodeAttributes) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineInodeAttributes) UnmarshalBinary(b []byte) error {
	var res AggregateInlineInodeAttributes
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineLinks aggregate inline links
//
// swagger:model aggregate_inline__links
type AggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline links
func (m *AggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline links based on the context it is used
func (m *AggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineMetric The most recent sample of I/O metrics for the aggregate.
//
// swagger:model aggregate_inline_metric
type AggregateInlineMetric struct {

	// links
	Links *AggregateInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *AggregateInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *AggregateInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *AggregateInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this aggregate inline metric
func (m *AggregateInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineMetricTypeDurationPropEnum = append(aggregateInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// AggregateInlineMetricDurationPT15S captures enum value "PT15S"
	AggregateInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT4M captures enum value "PT4M"
	AggregateInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT30M captures enum value "PT30M"
	AggregateInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// AggregateInlineMetricDurationPT2H captures enum value "PT2H"
	AggregateInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// AggregateInlineMetricDurationP1D captures enum value "P1D"
	AggregateInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT5M captures enum value "PT5M"
	AggregateInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *AggregateInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineMetricTypeStatusPropEnum = append(aggregateInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// AggregateInlineMetricStatusOk captures enum value "ok"
	AggregateInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// AggregateInlineMetricStatusError captures enum value "error"
	AggregateInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	AggregateInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	AggregateInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	AggregateInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// AggregateInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	AggregateInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// AggregateInlineMetricStatusNotFound captures enum value "not_found"
	AggregateInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// AggregateInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	AggregateInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// AggregateInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	AggregateInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// AggregateInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	AggregateInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	AggregateInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *AggregateInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline metric based on the context it is used
func (m *AggregateInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineMetric) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model aggregate_inline_metric_inline_iops
type AggregateInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline iops
func (m *AggregateInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline iops based on the context it is used
func (m *AggregateInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model aggregate_inline_metric_inline_latency
type AggregateInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline latency
func (m *AggregateInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline latency based on the context it is used
func (m *AggregateInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineMetricInlineLinks aggregate inline metric inline links
//
// swagger:model aggregate_inline_metric_inline__links
type AggregateInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline metric inline links
func (m *AggregateInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline metric inline links based on the context it is used
func (m *AggregateInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model aggregate_inline_metric_inline_throughput
type AggregateInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline throughput
func (m *AggregateInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline throughput based on the context it is used
func (m *AggregateInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineNode Node where the aggregate currently resides.
//
// swagger:model aggregate_inline_node
type AggregateInlineNode struct {

	// links
	Links *AggregateInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline node
func (m *AggregateInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline node based on the context it is used
func (m *AggregateInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineNodeInlineLinks aggregate inline node inline links
//
// swagger:model aggregate_inline_node_inline__links
type AggregateInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline node inline links
func (m *AggregateInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline node inline links based on the context it is used
func (m *AggregateInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSnapshot aggregate inline snapshot
//
// swagger:model aggregate_inline_snapshot
type AggregateInlineSnapshot struct {

	// Total files allowed in snapshots
	// Example: 10
	// Read Only: true
	FilesTotal *int64 `json:"files_total,omitempty"`

	// Total files created in snapshots
	// Example: 3
	// Read Only: true
	FilesUsed *int64 `json:"files_used,omitempty"`

	// Maximum files available for snapshots
	// Example: 5
	// Read Only: true
	MaxFilesAvailable *int64 `json:"max_files_available,omitempty"`

	// Files in use by snapshots
	// Example: 50
	// Read Only: true
	MaxFilesUsed *int64 `json:"max_files_used,omitempty"`
}

// Validate validates this aggregate inline snapshot
func (m *AggregateInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline snapshot based on the context it is used
func (m *AggregateInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFilesTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxFilesAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxFilesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSnapshot) contextValidateFilesTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"files_total", "body", m.FilesTotal); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSnapshot) contextValidateFilesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"files_used", "body", m.FilesUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSnapshot) contextValidateMaxFilesAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"max_files_available", "body", m.MaxFilesAvailable); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSnapshot) contextValidateMaxFilesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"max_files_used", "body", m.MaxFilesUsed); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpace aggregate inline space
//
// swagger:model aggregate_inline_space
type AggregateInlineSpace struct {

	// block storage
	BlockStorage *AggregateInlineSpaceInlineBlockStorage `json:"block_storage,omitempty"`

	// cloud storage
	CloudStorage *AggregateInlineSpaceInlineCloudStorage `json:"cloud_storage,omitempty"`

	// efficiency
	Efficiency *AggregateInlineSpaceInlineEfficiency `json:"efficiency,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// efficiency without snapshots flexclones
	EfficiencyWithoutSnapshotsFlexclones *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones `json:"efficiency_without_snapshots_flexclones,omitempty"`

	// A summation of volume footprints (including volume guarantees), in bytes. This includes all of the volume footprints in the block_storage tier and the cloud_storage tier.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 608896
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// snapshot
	Snapshot *AggregateInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// A summation of volume size, in bytes. This includes all of the volumes inside the aggregate.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either total_provisioned_space or **.
	//
	// Example: 20971520
	// Read Only: true
	TotalProvisionedSpace *int64 `json:"total_provisioned_space,omitempty"`
}

// Validate validates this aggregate inline space
func (m *AggregateInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshotsFlexclones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpace) validateBlockStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockStorage) { // not required
		return nil
	}

	if m.BlockStorage != nil {
		if err := m.BlockStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) validateCloudStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudStorage) { // not required
		return nil
	}

	if m.CloudStorage != nil {
		if err := m.CloudStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(m.Efficiency) { // not required
		return nil
	}

	if m.Efficiency != nil {
		if err := m.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) validateEfficiencyWithoutSnapshotsFlexclones(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshotsFlexclones) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline space based on the context it is used
func (m *AggregateInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlockStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloudStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalProvisionedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpace) contextValidateBlockStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BlockStorage != nil {
		if err := m.BlockStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateCloudStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudStorage != nil {
		if err := m.CloudStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if m.Efficiency != nil {
		if err := m.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"footprint", "body", m.Footprint); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineSpace) contextValidateTotalProvisionedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"total_provisioned_space", "body", m.TotalProvisionedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpace) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineBlockStorage aggregate inline space inline block storage
//
// swagger:model aggregate_inline_space_inline_block_storage
type AggregateInlineSpaceInlineBlockStorage struct {

	// Space used by different metafiles and internal operations inside the aggregate, in bytes.
	// Example: 2655
	// Read Only: true
	AggregateMetadata *int64 `json:"aggregate_metadata,omitempty"`

	// Aggregate metadata as a percentage.
	// Example: 8
	// Read Only: true
	AggregateMetadataPercent *int64 `json:"aggregate_metadata_percent,omitempty"`

	// Space available in bytes.
	// Example: 10156560384
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Amount of compacted data in bytes.
	// Example: 1990000
	// Read Only: true
	DataCompactedCount *int64 `json:"data_compacted_count,omitempty"`

	// Space saved in bytes by compacting the data.
	// Example: 1996000
	// Read Only: true
	DataCompactionSpaceSaved *int64 `json:"data_compaction_space_saved,omitempty"`

	// Percentage saved by compacting the data.
	// Example: 27
	// Read Only: true
	DataCompactionSpaceSavedPercent *int64 `json:"data_compaction_space_saved_percent,omitempty"`

	// The aggregate used percentage at which 'monitor.volume.full' EMS is generated.
	// Read Only: true
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// The size that is physically used in the block storage and has a cold temperature, in bytes. This property is only supported if the aggregate is either attached to a cloud store or can be attached to a cloud store.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either block_storage.inactive_user_data or **.
	//
	// Example: 304448
	// Read Only: true
	InactiveUserData *int64 `json:"inactive_user_data,omitempty"`

	// The percentage of inactive user data in the block storage. This property is only supported if the aggregate is either attached to a cloud store or can be attached to a cloud store.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either block_storage.inactive_user_data_percent or **.
	//
	// Read Only: true
	InactiveUserDataPercent *int64 `json:"inactive_user_data_percent,omitempty"`

	// Total physical used size of an aggregate in bytes.
	// Example: 2461696
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// Physical used percentage.
	// Example: 50
	// Read Only: true
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// Total usable space in bytes, not including WAFL reserve and aggregate snapshot reserve.
	// Example: 10156769280
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Space used or reserved in bytes. Includes volume guarantees and aggregate metadata.
	// Example: 2088960
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Total used including the snapshot reserve, in bytes.
	// Example: 674685
	// Read Only: true
	UsedIncludingSnapshotReserve *int64 `json:"used_including_snapshot_reserve,omitempty"`

	// Total used including the Snapshot reserve as a percentage.
	// Example: 35
	// Read Only: true
	UsedIncludingSnapshotReservePercent *int64 `json:"used_including_snapshot_reserve_percent,omitempty"`

	// Aggregate used percentage.
	// Example: 50
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`

	// Amount of shared bytes counted by storage efficiency.
	// Example: 1990000
	// Read Only: true
	VolumeDeduplicationSharedCount *int64 `json:"volume_deduplication_shared_count,omitempty"`

	// Amount of space saved in bytes by storage efficiency.
	// Example: 1996000
	// Read Only: true
	VolumeDeduplicationSpaceSaved *int64 `json:"volume_deduplication_space_saved,omitempty"`

	// Percentage of space saved by storage efficiency.
	// Example: 27
	// Read Only: true
	VolumeDeduplicationSpaceSavedPercent *int64 `json:"volume_deduplication_space_saved_percent,omitempty"`

	// A summation of volume footprints inside the aggregate, as a percentage. A volume's footprint is the amount of space being used for the volume in the aggregate.
	// Example: 14
	// Read Only: true
	VolumeFootprintsPercent *int64 `json:"volume_footprints_percent,omitempty"`
}

// Validate validates this aggregate inline space inline block storage
func (m *AggregateInlineSpaceInlineBlockStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline block storage based on the context it is used
func (m *AggregateInlineSpaceInlineBlockStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateMetadataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCompactedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCompactionSpaceSaved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCompactionSpaceSavedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFullThresholdPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInactiveUserDataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedIncludingSnapshotReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedIncludingSnapshotReservePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeDeduplicationSharedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeDeduplicationSpaceSaved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeDeduplicationSpaceSavedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeFootprintsPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateAggregateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"aggregate_metadata", "body", m.AggregateMetadata); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateAggregateMetadataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"aggregate_metadata_percent", "body", m.AggregateMetadataPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"data_compacted_count", "body", m.DataCompactedCount); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactionSpaceSaved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"data_compaction_space_saved", "body", m.DataCompactionSpaceSaved); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactionSpaceSavedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"data_compaction_space_saved_percent", "body", m.DataCompactionSpaceSavedPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateFullThresholdPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"full_threshold_percent", "body", m.FullThresholdPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"inactive_user_data", "body", m.InactiveUserData); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateInactiveUserDataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"inactive_user_data_percent", "body", m.InactiveUserDataPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidatePhysicalUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"physical_used_percent", "body", m.PhysicalUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedIncludingSnapshotReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"used_including_snapshot_reserve", "body", m.UsedIncludingSnapshotReserve); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedIncludingSnapshotReservePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"used_including_snapshot_reserve_percent", "body", m.UsedIncludingSnapshotReservePercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"used_percent", "body", m.UsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSharedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"volume_deduplication_shared_count", "body", m.VolumeDeduplicationSharedCount); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSpaceSaved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"volume_deduplication_space_saved", "body", m.VolumeDeduplicationSpaceSaved); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSpaceSavedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"volume_deduplication_space_saved_percent", "body", m.VolumeDeduplicationSpaceSavedPercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeFootprintsPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"block_storage"+"."+"volume_footprints_percent", "body", m.VolumeFootprintsPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineBlockStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineBlockStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineBlockStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineCloudStorage aggregate inline space inline cloud storage
//
// swagger:model aggregate_inline_space_inline_cloud_storage
type AggregateInlineSpaceInlineCloudStorage struct {

	// Used space in bytes in the cloud store. Only applicable for aggregates with a cloud store tier.
	// Example: 402743264
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this aggregate inline space inline cloud storage
func (m *AggregateInlineSpaceInlineCloudStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline cloud storage based on the context it is used
func (m *AggregateInlineSpaceInlineCloudStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineCloudStorage) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"cloud_storage"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineCloudStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineCloudStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineCloudStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineEfficiency Storage efficiency.
//
// swagger:model aggregate_inline_space_inline_efficiency
type AggregateInlineSpaceInlineEfficiency struct {

	// Indicates whether or not aggregate has auto adaptive compression savings.
	// Read Only: true
	AutoAdaptiveCompressionSavings *bool `json:"auto_adaptive_compression_savings,omitempty"`

	// Indicates whether or not cross volume background deduplication is enabled.
	// Read Only: true
	CrossVolumeBackgroundDedupe *bool `json:"cross_volume_background_dedupe,omitempty"`

	// Indicates whether or not aggregate has cross volume deduplication savings.
	// Read Only: true
	CrossVolumeDedupeSavings *bool `json:"cross_volume_dedupe_savings,omitempty"`

	// Indicates whether or not cross volume inline deduplication is enabled.
	// Read Only: true
	CrossVolumeInlineDedupe *bool `json:"cross_volume_inline_dedupe,omitempty"`

	// Indicates whether Workload Informed TSSE is enabled on the system.
	EnableWorkloadInformedTsse *bool `json:"enable_workload_informed_tsse,omitempty"`

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// Minimum amount of used data in aggregate required to trigger cold compression on TSSE volumes.
	WiseTsseMinUsedCapacityPct *int64 `json:"wise_tsse_min_used_capacity_pct,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency
func (m *AggregateInlineSpaceInlineEfficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency based on the context it is used
func (m *AggregateInlineSpaceInlineEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutoAdaptiveCompressionSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeBackgroundDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeDedupeSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCrossVolumeInlineDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateAutoAdaptiveCompressionSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"auto_adaptive_compression_savings", "body", m.AutoAdaptiveCompressionSavings); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeBackgroundDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"cross_volume_background_dedupe", "body", m.CrossVolumeBackgroundDedupe); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeDedupeSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"cross_volume_dedupe_savings", "body", m.CrossVolumeDedupeSavings); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeInlineDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"cross_volume_inline_dedupe", "body", m.CrossVolumeInlineDedupe); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiency) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineEfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots.
//
// swagger:model aggregate_inline_space_inline_efficiency_without_snapshots
type AggregateInlineSpaceInlineEfficiencyWithoutSnapshots struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency without snapshots
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency without snapshots based on the context it is used
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones Storage efficiency that does not include the savings provided by snapshots and Flexclone volumes.
//
// swagger:model aggregate_inline_space_inline_efficiency_without_snapshots_flexclones
type AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency without snapshots flexclones
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency without snapshots flexclones based on the context it is used
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots_flexclones"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots_flexclones"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_without_snapshots_flexclones"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineSpaceInlineSnapshot aggregate inline space inline snapshot
//
// swagger:model aggregate_inline_space_inline_snapshot
type AggregateInlineSpaceInlineSnapshot struct {

	// Available space for snapshots in bytes
	// Example: 2000
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Percentage of space reserved for snapshots
	// Example: 20
	// Read Only: true
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Total space for snapshots in bytes
	// Example: 5000
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Space used by snapshots in bytes
	// Example: 3000
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Percentage of disk space used by snapshots
	// Example: 45
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this aggregate inline space inline snapshot
func (m *AggregateInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline snapshot based on the context it is used
func (m *AggregateInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReservePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineSpaceInlineSnapshot) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineSnapshot) contextValidateReservePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"reserve_percent", "body", m.ReservePercent); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineSnapshot) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineSpaceInlineSnapshot) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"snapshot"+"."+"used_percent", "body", m.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineStatistics The real time I/O statistics for the aggregate.
//
// swagger:model aggregate_inline_statistics
type AggregateInlineStatistics struct {

	// iops raw
	IopsRaw *AggregateInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *AggregateInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *AggregateInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this aggregate inline statistics
func (m *AggregateInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineStatisticsTypeStatusPropEnum = append(aggregateInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// AggregateInlineStatisticsStatusOk captures enum value "ok"
	AggregateInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// AggregateInlineStatisticsStatusError captures enum value "error"
	AggregateInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	AggregateInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	AggregateInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	AggregateInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// AggregateInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	AggregateInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// AggregateInlineStatisticsStatusNotFound captures enum value "not_found"
	AggregateInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	AggregateInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// AggregateInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	AggregateInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	AggregateInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	AggregateInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *AggregateInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AggregateInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline statistics based on the context it is used
func (m *AggregateInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *AggregateInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineStatistics) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model aggregate_inline_statistics_inline_iops_raw
type AggregateInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline iops raw
func (m *AggregateInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline iops raw based on the context it is used
func (m *AggregateInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model aggregate_inline_statistics_inline_latency_raw
type AggregateInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline latency raw
func (m *AggregateInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline latency raw based on the context it is used
func (m *AggregateInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model aggregate_inline_statistics_inline_throughput_raw
type AggregateInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline throughput raw
func (m *AggregateInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline throughput raw based on the context it is used
func (m *AggregateInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
