// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AggregateResponse aggregate response
//
// swagger:model aggregate_response
type AggregateResponse struct {

	// links
	Links *AggregateResponseInlineLinks `json:"_links,omitempty"`

	// Information on the aggregate's remaining hot spare disks.
	AggregateResponseInlineRecommendationSpares []*AggregateSpare `json:"recommendation_spares,omitempty"`

	// aggregate response inline records
	AggregateResponseInlineRecords []*Aggregate `json:"records,omitempty"`

	// aggregate response inline spares
	AggregateResponseInlineSpares []*AggregateSpare `json:"spares,omitempty"`

	// List of warnings and remediation advice for the aggregate recommendation.
	AggregateResponseInlineWarnings []*AggregateWarning `json:"warnings,omitempty"`

	// error
	Error *Error `json:"error,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this aggregate response
func (m *AggregateResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateResponseInlineRecommendationSpares(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateResponseInlineSpares(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateResponseInlineWarnings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateResponse) validateAggregateResponseInlineRecommendationSpares(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateResponseInlineRecommendationSpares) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateResponseInlineRecommendationSpares); i++ {
		if swag.IsZero(m.AggregateResponseInlineRecommendationSpares[i]) { // not required
			continue
		}

		if m.AggregateResponseInlineRecommendationSpares[i] != nil {
			if err := m.AggregateResponseInlineRecommendationSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("recommendation_spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) validateAggregateResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateResponseInlineRecords); i++ {
		if swag.IsZero(m.AggregateResponseInlineRecords[i]) { // not required
			continue
		}

		if m.AggregateResponseInlineRecords[i] != nil {
			if err := m.AggregateResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) validateAggregateResponseInlineSpares(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateResponseInlineSpares) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateResponseInlineSpares); i++ {
		if swag.IsZero(m.AggregateResponseInlineSpares[i]) { // not required
			continue
		}

		if m.AggregateResponseInlineSpares[i] != nil {
			if err := m.AggregateResponseInlineSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) validateAggregateResponseInlineWarnings(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateResponseInlineWarnings) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateResponseInlineWarnings); i++ {
		if swag.IsZero(m.AggregateResponseInlineWarnings[i]) { // not required
			continue
		}

		if m.AggregateResponseInlineWarnings[i] != nil {
			if err := m.AggregateResponseInlineWarnings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate response based on the context it is used
func (m *AggregateResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateResponseInlineRecommendationSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateResponseInlineSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateResponseInlineWarnings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateResponse) contextValidateAggregateResponseInlineRecommendationSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateResponseInlineRecommendationSpares); i++ {

		if m.AggregateResponseInlineRecommendationSpares[i] != nil {
			if err := m.AggregateResponseInlineRecommendationSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("recommendation_spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) contextValidateAggregateResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateResponseInlineRecords); i++ {

		if m.AggregateResponseInlineRecords[i] != nil {
			if err := m.AggregateResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) contextValidateAggregateResponseInlineSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateResponseInlineSpares); i++ {

		if m.AggregateResponseInlineSpares[i] != nil {
			if err := m.AggregateResponseInlineSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) contextValidateAggregateResponseInlineWarnings(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateResponseInlineWarnings); i++ {

		if m.AggregateResponseInlineWarnings[i] != nil {
			if err := m.AggregateResponseInlineWarnings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateResponse) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateResponse) UnmarshalBinary(b []byte) error {
	var res AggregateResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AggregateResponseInlineLinks aggregate response inline links
//
// swagger:model aggregate_response_inline__links
type AggregateResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aggregate response inline links
func (m *AggregateResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate response inline links based on the context it is used
func (m *AggregateResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *AggregateResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
