// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AggregateSimulate aggregate simulate
//
// swagger:model aggregate_simulate
type AggregateSimulate struct {

	// aggregate simulate inline records
	AggregateSimulateInlineRecords []*Aggregate `json:"records,omitempty"`

	// List of validation warnings and remediation advice for the aggregate simulate behavior.
	AggregateSimulateInlineWarnings []*AggregateWarning `json:"warnings,omitempty"`

	// job
	Job *JobLink `json:"job,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this aggregate simulate
func (m *AggregateSimulate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregateSimulateInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAggregateSimulateInlineWarnings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateSimulate) validateAggregateSimulateInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateSimulateInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateSimulateInlineRecords); i++ {
		if swag.IsZero(m.AggregateSimulateInlineRecords[i]) { // not required
			continue
		}

		if m.AggregateSimulateInlineRecords[i] != nil {
			if err := m.AggregateSimulateInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateSimulate) validateAggregateSimulateInlineWarnings(formats strfmt.Registry) error {
	if swag.IsZero(m.AggregateSimulateInlineWarnings) { // not required
		return nil
	}

	for i := 0; i < len(m.AggregateSimulateInlineWarnings); i++ {
		if swag.IsZero(m.AggregateSimulateInlineWarnings[i]) { // not required
			continue
		}

		if m.AggregateSimulateInlineWarnings[i] != nil {
			if err := m.AggregateSimulateInlineWarnings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateSimulate) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate simulate based on the context it is used
func (m *AggregateSimulate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregateSimulateInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAggregateSimulateInlineWarnings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AggregateSimulate) contextValidateAggregateSimulateInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateSimulateInlineRecords); i++ {

		if m.AggregateSimulateInlineRecords[i] != nil {
			if err := m.AggregateSimulateInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateSimulate) contextValidateAggregateSimulateInlineWarnings(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AggregateSimulateInlineWarnings); i++ {

		if m.AggregateSimulateInlineWarnings[i] != nil {
			if err := m.AggregateSimulateInlineWarnings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AggregateSimulate) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AggregateSimulate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AggregateSimulate) UnmarshalBinary(b []byte) error {
	var res AggregateSimulate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
