// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AnalyticsCollectionInfo File system analytics information that is invariant amongst all elements in a collection.
//
// swagger:model analytics_collection_info
type AnalyticsCollectionInfo struct {

	// by accessed time
	ByAccessedTime *AnalyticsCollectionInfoInlineByAccessedTime `json:"by_accessed_time,omitempty"`

	// by modified time
	ByModifiedTime *AnalyticsCollectionInfoInlineByModifiedTime `json:"by_modified_time,omitempty"`
}

// Validate validates this analytics collection info
func (m *AnalyticsCollectionInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateByAccessedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateByModifiedTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfo) validateByAccessedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByAccessedTime) { // not required
		return nil
	}

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *AnalyticsCollectionInfo) validateByModifiedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ByModifiedTime) { // not required
		return nil
	}

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_modified_time")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this analytics collection info based on the context it is used
func (m *AnalyticsCollectionInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateByAccessedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateByModifiedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfo) contextValidateByAccessedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByAccessedTime != nil {
		if err := m.ByAccessedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_accessed_time")
			}
			return err
		}
	}

	return nil
}

func (m *AnalyticsCollectionInfo) contextValidateByModifiedTime(ctx context.Context, formats strfmt.Registry) error {

	if m.ByModifiedTime != nil {
		if err := m.ByModifiedTime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_modified_time")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsCollectionInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsCollectionInfo) UnmarshalBinary(b []byte) error {
	var res AnalyticsCollectionInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AnalyticsCollectionInfoInlineByAccessedTime File system analytics information, broken down by date of last access.
//
// swagger:model analytics_collection_info_inline_by_accessed_time
type AnalyticsCollectionInfoInlineByAccessedTime struct {

	// bytes used
	BytesUsed *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this analytics collection info inline by accessed time
func (m *AnalyticsCollectionInfoInlineByAccessedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByAccessedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this analytics collection info inline by accessed time based on the context it is used
func (m *AnalyticsCollectionInfoInlineByAccessedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByAccessedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_accessed_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByAccessedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByAccessedTime) UnmarshalBinary(b []byte) error {
	var res AnalyticsCollectionInfoInlineByAccessedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last access.
//
// swagger:model analytics_collection_info_inline_by_accessed_time_inline_bytes_used
type AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed struct {

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`
}

// Validate validates this analytics collection info inline by accessed time inline bytes used
func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// ContextValidate validate this analytics collection info inline by accessed time inline bytes used based on the context it is used
func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("by_accessed_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res AnalyticsCollectionInfoInlineByAccessedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AnalyticsCollectionInfoInlineByModifiedTime File system analytics information, broken down by date of last modification.
//
// swagger:model analytics_collection_info_inline_by_modified_time
type AnalyticsCollectionInfoInlineByModifiedTime struct {

	// bytes used
	BytesUsed *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed `json:"bytes_used,omitempty"`
}

// Validate validates this analytics collection info inline by modified time
func (m *AnalyticsCollectionInfoInlineByModifiedTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBytesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByModifiedTime) validateBytesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.BytesUsed) { // not required
		return nil
	}

	if m.BytesUsed != nil {
		if err := m.BytesUsed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this analytics collection info inline by modified time based on the context it is used
func (m *AnalyticsCollectionInfoInlineByModifiedTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBytesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByModifiedTime) contextValidateBytesUsed(ctx context.Context, formats strfmt.Registry) error {

	if m.BytesUsed != nil {
		if err := m.BytesUsed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("by_modified_time" + "." + "bytes_used")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByModifiedTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByModifiedTime) UnmarshalBinary(b []byte) error {
	var res AnalyticsCollectionInfoInlineByModifiedTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed Number of bytes used on-disk, broken down by date of last modification.
//
// swagger:model analytics_collection_info_inline_by_modified_time_inline_bytes_used
type AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed struct {

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`
}

// Validate validates this analytics collection info inline by modified time inline bytes used
func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// ContextValidate validate this analytics collection info inline by modified time inline bytes used based on the context it is used
func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("by_modified_time" + "." + "bytes_used" + "." + "labels")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed) UnmarshalBinary(b []byte) error {
	var res AnalyticsCollectionInfoInlineByModifiedTimeInlineBytesUsed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
