// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AnalyticsHistogramByTime Histogram maintained by file system analytics that associates data with specific periods of time. <br/>
// The properties of this object are three parallel lists as described here. For any index *i*, the *i*th element of each list corresponds to the same logical bucket within the histogram.
//
// swagger:model analytics_histogram_by_time
type AnalyticsHistogramByTime struct {

	// A score summarizing how old the data is. A higher value means the data is older.
	// Example: 15.23
	AgedDataMetric *float64 `json:"aged_data_metric,omitempty"`

	// Percentages for this histogram
	// Example: [0.1,11.24,0.18,15.75,0.75,83.5,0]
	AnalyticsHistogramByTimeInlinePercentages []*float64 `json:"percentages,omitempty"`

	// Values for this histogram
	// Example: [15925248,1735569408,27672576,2430595072,116105216,12889948160,0]
	AnalyticsHistogramByTimeInlineValues []*int64 `json:"values,omitempty"`

	// labels
	Labels AnalyticsHistogramByTimeLabelsArrayInline `json:"labels,omitempty"`

	// The newest time label with a non-zero histogram value.
	NewestLabel *AnalyticsHistogramTimeLabel `json:"newest_label,omitempty"`

	// The oldest time label with a non-zero histogram value.
	OldestLabel *AnalyticsHistogramTimeLabel `json:"oldest_label,omitempty"`
}

// Validate validates this analytics histogram by time
func (m *AnalyticsHistogramByTime) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewestLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOldestLabel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsHistogramByTime) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	if err := m.Labels.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("labels")
		}
		return err
	}

	return nil
}

func (m *AnalyticsHistogramByTime) validateNewestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.NewestLabel) { // not required
		return nil
	}

	if m.NewestLabel != nil {
		if err := m.NewestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *AnalyticsHistogramByTime) validateOldestLabel(formats strfmt.Registry) error {
	if swag.IsZero(m.OldestLabel) { // not required
		return nil
	}

	if m.OldestLabel != nil {
		if err := m.OldestLabel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oldest_label")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this analytics histogram by time based on the context it is used
func (m *AnalyticsHistogramByTime) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNewestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOldestLabel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AnalyticsHistogramByTime) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Labels.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("labels")
		}
		return err
	}

	return nil
}

func (m *AnalyticsHistogramByTime) contextValidateNewestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.NewestLabel != nil {
		if err := m.NewestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("newest_label")
			}
			return err
		}
	}

	return nil
}

func (m *AnalyticsHistogramByTime) contextValidateOldestLabel(ctx context.Context, formats strfmt.Registry) error {

	if m.OldestLabel != nil {
		if err := m.OldestLabel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oldest_label")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AnalyticsHistogramByTime) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AnalyticsHistogramByTime) UnmarshalBinary(b []byte) error {
	var res AnalyticsHistogramByTime
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
