// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AntiRansomwareAutoEnable anti ransomware auto enable
//
// swagger:model anti_ransomware_auto_enable
type AntiRansomwareAutoEnable struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Auto Anti-Ransomware Protection (ARP) setting for new volumes.
	NewVolumeAutoEnable *bool `json:"new_volume_auto_enable,omitempty"`

	// Indicates if the warm-up period is applicable.
	// Read Only: true
	WarmUpPeriodApplicable *bool `json:"warm_up_period_applicable,omitempty"`

	// Indicates if warm-up period has completed.
	// Read Only: true
	WarmUpPeriodCompleted *bool `json:"warm_up_period_completed,omitempty"`

	// Time remaining for warm-up period completion.
	// Read Only: true
	WarmUpPeriodRemainingDuration *string `json:"warm_up_period_remaining_duration,omitempty"`

	// Duration of warm-up period.
	WarmUpPeriodTotalDuration *string `json:"warm_up_period_total_duration,omitempty"`
}

// Validate validates this anti ransomware auto enable
func (m *AntiRansomwareAutoEnable) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareAutoEnable) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware auto enable based on the context it is used
func (m *AntiRansomwareAutoEnable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWarmUpPeriodApplicable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWarmUpPeriodCompleted(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWarmUpPeriodRemainingDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareAutoEnable) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareAutoEnable) contextValidateWarmUpPeriodApplicable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "warm_up_period_applicable", "body", m.WarmUpPeriodApplicable); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareAutoEnable) contextValidateWarmUpPeriodCompleted(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "warm_up_period_completed", "body", m.WarmUpPeriodCompleted); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareAutoEnable) contextValidateWarmUpPeriodRemainingDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "warm_up_period_remaining_duration", "body", m.WarmUpPeriodRemainingDuration); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareAutoEnable) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareAutoEnable) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareAutoEnable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
