// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AntiRansomwareStorageUnit The anti-ransomware properties of a storage unit.
//
// swagger:model anti_ransomware_storage_unit
type AntiRansomwareStorageUnit struct {

	// anti ransomware storage unit inline attack reports
	// Read Only: true
	AntiRansomwareStorageUnitInlineAttackReports []*AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem `json:"attack_reports,omitempty"`

	// The probability of a ransomware attack.<br/>
	// Possible values:
	// * `none` No suspected ransomware activity.
	// * `moderate` Suspected ransomware activity.
	//
	// Read Only: true
	// Enum: ["none","moderate"]
	AttackProbability *string `json:"attack_probability,omitempty"`

	// The anti-ransomware state for the storage unit.<br/>
	// Possible values:
	// * `disabled` Anti-ransomware monitoring is disabled for the storage unit. Valid in PATCH and GET.
	// * `disable_in_progress` Anti-ransomware monitoring is being disabled and a clean-up operation is in progress. Valid in GET.
	// * `enabled` Anti-ransomware monitoring is active for the storage unit. Valid in PATCH and GET.
	// * `paused` Anti-ransomware monitoring is paused for the storage unit from its earlier enabled state. Valid in PATCH and GET.
	//
	// Enum: ["disabled","disable_in_progress","enabled","paused"]
	State *string `json:"state,omitempty"`
}

// Validate validates this anti ransomware storage unit
func (m *AntiRansomwareStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAntiRansomwareStorageUnitInlineAttackReports(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttackProbability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareStorageUnit) validateAntiRansomwareStorageUnitInlineAttackReports(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomwareStorageUnitInlineAttackReports) { // not required
		return nil
	}

	for i := 0; i < len(m.AntiRansomwareStorageUnitInlineAttackReports); i++ {
		if swag.IsZero(m.AntiRansomwareStorageUnitInlineAttackReports[i]) { // not required
			continue
		}

		if m.AntiRansomwareStorageUnitInlineAttackReports[i] != nil {
			if err := m.AntiRansomwareStorageUnitInlineAttackReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var antiRansomwareStorageUnitTypeAttackProbabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","moderate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		antiRansomwareStorageUnitTypeAttackProbabilityPropEnum = append(antiRansomwareStorageUnitTypeAttackProbabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// attack_probability
	// AttackProbability
	// none
	// END DEBUGGING
	// AntiRansomwareStorageUnitAttackProbabilityNone captures enum value "none"
	AntiRansomwareStorageUnitAttackProbabilityNone string = "none"

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// attack_probability
	// AttackProbability
	// moderate
	// END DEBUGGING
	// AntiRansomwareStorageUnitAttackProbabilityModerate captures enum value "moderate"
	AntiRansomwareStorageUnitAttackProbabilityModerate string = "moderate"
)

// prop value enum
func (m *AntiRansomwareStorageUnit) validateAttackProbabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, antiRansomwareStorageUnitTypeAttackProbabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AntiRansomwareStorageUnit) validateAttackProbability(formats strfmt.Registry) error {
	if swag.IsZero(m.AttackProbability) { // not required
		return nil
	}

	// value enum
	if err := m.validateAttackProbabilityEnum("attack_probability", "body", *m.AttackProbability); err != nil {
		return err
	}

	return nil
}

var antiRansomwareStorageUnitTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","disable_in_progress","enabled","paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		antiRansomwareStorageUnitTypeStatePropEnum = append(antiRansomwareStorageUnitTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// state
	// State
	// disabled
	// END DEBUGGING
	// AntiRansomwareStorageUnitStateDisabled captures enum value "disabled"
	AntiRansomwareStorageUnitStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// state
	// State
	// disable_in_progress
	// END DEBUGGING
	// AntiRansomwareStorageUnitStateDisableInProgress captures enum value "disable_in_progress"
	AntiRansomwareStorageUnitStateDisableInProgress string = "disable_in_progress"

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// state
	// State
	// enabled
	// END DEBUGGING
	// AntiRansomwareStorageUnitStateEnabled captures enum value "enabled"
	AntiRansomwareStorageUnitStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// anti_ransomware_storage_unit
	// AntiRansomwareStorageUnit
	// state
	// State
	// paused
	// END DEBUGGING
	// AntiRansomwareStorageUnitStatePaused captures enum value "paused"
	AntiRansomwareStorageUnitStatePaused string = "paused"
)

// prop value enum
func (m *AntiRansomwareStorageUnit) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, antiRansomwareStorageUnitTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AntiRansomwareStorageUnit) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this anti ransomware storage unit based on the context it is used
func (m *AntiRansomwareStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAntiRansomwareStorageUnitInlineAttackReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttackProbability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareStorageUnit) contextValidateAntiRansomwareStorageUnitInlineAttackReports(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "attack_reports", "body", []*AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem(m.AntiRansomwareStorageUnitInlineAttackReports)); err != nil {
		return err
	}

	for i := 0; i < len(m.AntiRansomwareStorageUnitInlineAttackReports); i++ {

		if m.AntiRansomwareStorageUnitInlineAttackReports[i] != nil {
			if err := m.AntiRansomwareStorageUnitInlineAttackReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AntiRansomwareStorageUnit) contextValidateAttackProbability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "attack_probability", "body", m.AttackProbability); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareStorageUnit) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem anti ransomware storage unit inline attack reports inline array item
//
// swagger:model anti_ransomware_storage_unit_inline_attack_reports_inline_array_item
type AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem struct {

	// Timestamp at which ransomware attack is observed.
	//
	// Example: 2021-06-01 20:36:41+05:30
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this anti ransomware storage unit inline attack reports inline array item
func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("time", "body", "date-time", m.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this anti ransomware storage unit inline attack reports inline array item based on the context it is used
func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time", "body", m.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareStorageUnitInlineAttackReportsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
