// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AntiRansomwareVolumeAttackDetectionParameters anti ransomware volume attack detection parameters
//
// swagger:model anti_ransomware_volume_attack_detection_parameters
type AntiRansomwareVolumeAttackDetectionParameters struct {

	// Specifies whether attack detection is based on the file create operations rate. This parameter is valid only for NAS volumes.
	BasedOnFileCreateOpRate *bool `json:"based_on_file_create_op_rate,omitempty"`

	// Specifies whether attack detection is based on the file delete operations rate. This parameter is valid only for NAS volumes.
	BasedOnFileDeleteOpRate *bool `json:"based_on_file_delete_op_rate,omitempty"`

	// Specifies whether attack detection is based on the file rename operations rate. This parameter is valid only for NAS volumes.
	BasedOnFileRenameOpRate *bool `json:"based_on_file_rename_op_rate,omitempty"`

	// Specifies whether a high entropy data rate should be considered for attack detection.
	BasedOnHighEntropyDataRate *bool `json:"based_on_high_entropy_data_rate,omitempty"`

	// Specifies whether file extensions never seen before should be considered for attack detection.
	BasedOnNeverSeenBeforeFileExtension *bool `json:"based_on_never_seen_before_file_extension,omitempty"`

	// Specifies the block device auto learned encryption threshold.
	BlockDeviceAutoLearnedEncryptionThreshold *int64 `json:"block_device_auto_learned_encryption_threshold,omitempty"`

	// Specifies the percentage of surge in the file create rate up to which it is considered normal behavior.
	// Example: 100
	FileCreateOpRateSurgeNotifyPercent *int64 `json:"file_create_op_rate_surge_notify_percent,omitempty"`

	// Specifies the percentage of surge in the file delete rate up to which it is considered normal behavior.
	FileDeleteOpRateSurgeNotifyPercent *int64 `json:"file_delete_op_rate_surge_notify_percent,omitempty"`

	// Specifies the percent of surge in the file rename rate up to which it is considered normal behavior.
	FileRenameOpRateSurgeNotifyPercent *int64 `json:"file_rename_op_rate_surge_notify_percent,omitempty"`

	// Specifies the percentage of surge in high entropy data up to which it is considered as normal behavior. For example, if the usual high entropy data rate in the volume is 5% and if this parameter is set to 100%, it will be considered as an unusual surge if the high entropy data rate of the volume exceeds 10% at any time. Similarly, if this parameter is set to 400%, it will be considered as an unusual surge if the high entropy data rate of the volume exceeds 25%, and so on.
	HighEntropyDataSurgeNotifyPercent *int64 `json:"high_entropy_data_surge_notify_percent,omitempty"`

	// Specifies the number of files found with a never seen before file extension up to which it is considered normal behavior.
	NeverSeenBeforeFileExtensionCountNotifyThreshold *int64 `json:"never_seen_before_file_extension_count_notify_threshold,omitempty"`

	// Specifies the duration within which the specified number of files found with never seen before file extensions is considered normal behavior.
	NeverSeenBeforeFileExtensionDurationInHours *int64 `json:"never_seen_before_file_extension_duration_in_hours,omitempty"`

	// Specifies whether popular file extensions should be relaxed from being treated as a suspect for the attack. Some popular file extensions are .txt, .pdf, and so on.
	RelaxingPopularFileExtensions *bool `json:"relaxing_popular_file_extensions,omitempty"`
}

// Validate validates this anti ransomware volume attack detection parameters
func (m *AntiRansomwareVolumeAttackDetectionParameters) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this anti ransomware volume attack detection parameters based on context it is used
func (m *AntiRansomwareVolumeAttackDetectionParameters) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeAttackDetectionParameters) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeAttackDetectionParameters) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeAttackDetectionParameters
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
