// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AntiRansomwareVolumeEntropyStats Volume data-entropy statistics derived from block analysis.
//
// swagger:model anti_ransomware_volume_entropy_stats
type AntiRansomwareVolumeEntropyStats struct {

	// links
	Links *AntiRansomwareVolumeEntropyStatsInlineLinks `json:"_links,omitempty"`

	// The amount of data written.
	// Read Only: true
	DataWrittenInBytes *int64 `json:"data_written_in_bytes,omitempty"`

	// The duration of the interval associated with this statistic. The duration is represented in ISO-8601 standard format.
	// Example: PT15M
	// Read Only: true
	Duration *string `json:"duration,omitempty"`

	// The percentage of data that is encrypted.
	// Read Only: true
	EncryptionPercentage *int64 `json:"encryption_percentage,omitempty"`

	// Volume metrics are retrieved based on this statistic type.
	// Enum: ["sub_hourly","hourly","daily","high_enc_pct"]
	EntropyStatsType *string `json:"entropy_stats_type,omitempty"`

	// Start time in date-time format.
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// volume
	Volume *AntiRansomwareVolumeEntropyStatsInlineVolume `json:"volume,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats
func (m *AntiRansomwareVolumeEntropyStats) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntropyStatsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var antiRansomwareVolumeEntropyStatsTypeEntropyStatsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sub_hourly","hourly","daily","high_enc_pct"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		antiRansomwareVolumeEntropyStatsTypeEntropyStatsTypePropEnum = append(antiRansomwareVolumeEntropyStatsTypeEntropyStatsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats
	// AntiRansomwareVolumeEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// sub_hourly
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsEntropyStatsTypeSubHourly captures enum value "sub_hourly"
	AntiRansomwareVolumeEntropyStatsEntropyStatsTypeSubHourly string = "sub_hourly"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats
	// AntiRansomwareVolumeEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// hourly
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsEntropyStatsTypeHourly captures enum value "hourly"
	AntiRansomwareVolumeEntropyStatsEntropyStatsTypeHourly string = "hourly"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats
	// AntiRansomwareVolumeEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// daily
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsEntropyStatsTypeDaily captures enum value "daily"
	AntiRansomwareVolumeEntropyStatsEntropyStatsTypeDaily string = "daily"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats
	// AntiRansomwareVolumeEntropyStats
	// entropy_stats_type
	// EntropyStatsType
	// high_enc_pct
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsEntropyStatsTypeHighEncPct captures enum value "high_enc_pct"
	AntiRansomwareVolumeEntropyStatsEntropyStatsTypeHighEncPct string = "high_enc_pct"
)

// prop value enum
func (m *AntiRansomwareVolumeEntropyStats) validateEntropyStatsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, antiRansomwareVolumeEntropyStatsTypeEntropyStatsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) validateEntropyStatsType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntropyStatsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntropyStatsTypeEnum("entropy_stats_type", "body", *m.EntropyStatsType); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats based on the context it is used
func (m *AntiRansomwareVolumeEntropyStats) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataWrittenInBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryptionPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) contextValidateDataWrittenInBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_written_in_bytes", "body", m.DataWrittenInBytes); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) contextValidateEncryptionPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption_percentage", "body", m.EncryptionPercentage); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStats) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStats) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStats) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStats
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsInlineLinks anti ransomware volume entropy stats inline links
//
// swagger:model anti_ransomware_volume_entropy_stats_inline__links
type AntiRansomwareVolumeEntropyStatsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats inline links
func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats inline links based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineLinks) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsInlineVolume anti ransomware volume entropy stats inline volume
//
// swagger:model anti_ransomware_volume_entropy_stats_inline_volume
type AntiRansomwareVolumeEntropyStatsInlineVolume struct {

	// links
	Links *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats inline volume
func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats inline volume based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineVolume) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks anti ransomware volume entropy stats inline volume inline links
//
// swagger:model anti_ransomware_volume_entropy_stats_inline_volume_inline__links
type AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats inline volume inline links
func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats inline volume inline links based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
