// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AntiRansomwareVolumeEntropyStatsResponse Listing of volume entropy stats.
//
// swagger:model anti_ransomware_volume_entropy_stats_response
type AntiRansomwareVolumeEntropyStatsResponse struct {

	// links
	Links *AntiRansomwareVolumeEntropyStatsResponseInlineLinks `json:"_links,omitempty"`

	// anti ransomware volume entropy stats response inline records
	AntiRansomwareVolumeEntropyStatsResponseInlineRecords []*AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response
func (m *AntiRansomwareVolumeEntropyStatsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAntiRansomwareVolumeEntropyStatsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponse) validateAntiRansomwareVolumeEntropyStatsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords); i++ {
		if swag.IsZero(m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords[i] != nil {
			if err := m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomwareVolumeEntropyStatsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponse) contextValidateAntiRansomwareVolumeEntropyStatsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords); i++ {

		if m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords[i] != nil {
			if err := m.AntiRansomwareVolumeEntropyStatsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponse) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsResponseInlineLinks anti ransomware volume entropy stats response inline links
//
// swagger:model anti_ransomware_volume_entropy_stats_response_inline__links
type AntiRansomwareVolumeEntropyStatsResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response inline links
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response inline links based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem Volume data-entropy statistics derived from block analysis.
//
// swagger:model anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item
type AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The amount of data written.
	// Read Only: true
	DataWrittenInBytes *int64 `json:"data_written_in_bytes,omitempty"`

	// The duration of the interval associated with this statistic. The duration is represented in ISO-8601 standard format.
	// Example: PT15M
	// Read Only: true
	Duration *string `json:"duration,omitempty"`

	// The percentage of data that is encrypted.
	// Read Only: true
	EncryptionPercentage *int64 `json:"encryption_percentage,omitempty"`

	// Volume metrics are retrieved based on this statistic type.
	// Enum: ["sub_hourly","hourly","daily","high_enc_pct"]
	EntropyStatsType *string `json:"entropy_stats_type,omitempty"`

	// Start time in date-time format.
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// volume
	Volume *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume `json:"volume,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response inline records inline array item
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntropyStatsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var antiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sub_hourly","hourly","daily","high_enc_pct"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		antiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum = append(antiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// sub_hourly
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeSubHourly captures enum value "sub_hourly"
	AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeSubHourly string = "sub_hourly"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// hourly
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHourly captures enum value "hourly"
	AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHourly string = "hourly"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// daily
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeDaily captures enum value "daily"
	AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeDaily string = "daily"

	// BEGIN DEBUGGING
	// anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem
	// entropy_stats_type
	// EntropyStatsType
	// high_enc_pct
	// END DEBUGGING
	// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHighEncPct captures enum value "high_enc_pct"
	AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemEntropyStatsTypeHighEncPct string = "high_enc_pct"
)

// prop value enum
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) validateEntropyStatsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, antiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemTypeEntropyStatsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) validateEntropyStatsType(formats strfmt.Registry) error {
	if swag.IsZero(m.EntropyStatsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateEntropyStatsTypeEnum("entropy_stats_type", "body", *m.EntropyStatsType); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response inline records inline array item based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataWrittenInBytes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryptionPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateDataWrittenInBytes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_written_in_bytes", "body", m.DataWrittenInBytes); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateEncryptionPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption_percentage", "body", m.EncryptionPercentage); err != nil {
		return err
	}

	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks anti ransomware volume entropy stats response inline records inline array item inline links
//
// swagger:model anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item_inline__links
type AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response inline records inline array item inline links
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response inline records inline array item inline links based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume anti ransomware volume entropy stats response inline records inline array item inline volume
//
// swagger:model anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item_inline_volume
type AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume struct {

	// links
	Links *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response inline records inline array item inline volume
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response inline records inline array item inline volume based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks anti ransomware volume entropy stats response inline records inline array item inline volume inline links
//
// swagger:model anti_ransomware_volume_entropy_stats_response_inline_records_inline_array_item_inline_volume_inline__links
type AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this anti ransomware volume entropy stats response inline records inline array item inline volume inline links
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this anti ransomware volume entropy stats response inline records inline array item inline volume inline links based on the context it is used
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AntiRansomwareVolumeEntropyStatsResponseInlineRecordsInlineArrayItemInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
