// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AppCifsAccess The list of CIFS access controls. You must provide either 'user_or_group' or 'access' to enable CIFS access.
//
// swagger:model app_cifs_access
type AppCifsAccess struct {

	// The CIFS access granted to the user or group.
	// Enum: ["change","full_control","no_access","read"]
	Access *string `json:"access,omitempty"`

	// The name of the CIFS user or group that will be granted access.
	UserOrGroup *string `json:"user_or_group,omitempty"`
}

// Validate validates this app cifs access
func (m *AppCifsAccess) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var appCifsAccessTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["change","full_control","no_access","read"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		appCifsAccessTypeAccessPropEnum = append(appCifsAccessTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// app_cifs_access
	// AppCifsAccess
	// access
	// Access
	// change
	// END DEBUGGING
	// AppCifsAccessAccessChange captures enum value "change"
	AppCifsAccessAccessChange string = "change"

	// BEGIN DEBUGGING
	// app_cifs_access
	// AppCifsAccess
	// access
	// Access
	// full_control
	// END DEBUGGING
	// AppCifsAccessAccessFullControl captures enum value "full_control"
	AppCifsAccessAccessFullControl string = "full_control"

	// BEGIN DEBUGGING
	// app_cifs_access
	// AppCifsAccess
	// access
	// Access
	// no_access
	// END DEBUGGING
	// AppCifsAccessAccessNoAccess captures enum value "no_access"
	AppCifsAccessAccessNoAccess string = "no_access"

	// BEGIN DEBUGGING
	// app_cifs_access
	// AppCifsAccess
	// access
	// Access
	// read
	// END DEBUGGING
	// AppCifsAccessAccessRead captures enum value "read"
	AppCifsAccessAccessRead string = "read"
)

// prop value enum
func (m *AppCifsAccess) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, appCifsAccessTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AppCifsAccess) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessEnum("access", "body", *m.Access); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this app cifs access based on context it is used
func (m *AppCifsAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AppCifsAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AppCifsAccess) UnmarshalBinary(b []byte) error {
	var res AppCifsAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
