// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AppNfsAccess The list of NFS access controls. You must provide either 'host' or 'access' to enable NFS access.
//
// swagger:model app_nfs_access
type AppNfsAccess struct {

	// The NFS access granted.
	// Enum: ["none","ro","rw"]
	Access *string `json:"access,omitempty"`

	// The name of the NFS entity granted access.
	Host *string `json:"host,omitempty"`
}

// Validate validates this app nfs access
func (m *AppNfsAccess) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var appNfsAccessTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","ro","rw"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		appNfsAccessTypeAccessPropEnum = append(appNfsAccessTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// app_nfs_access
	// AppNfsAccess
	// access
	// Access
	// none
	// END DEBUGGING
	// AppNfsAccessAccessNone captures enum value "none"
	AppNfsAccessAccessNone string = "none"

	// BEGIN DEBUGGING
	// app_nfs_access
	// AppNfsAccess
	// access
	// Access
	// ro
	// END DEBUGGING
	// AppNfsAccessAccessRo captures enum value "ro"
	AppNfsAccessAccessRo string = "ro"

	// BEGIN DEBUGGING
	// app_nfs_access
	// AppNfsAccess
	// access
	// Access
	// rw
	// END DEBUGGING
	// AppNfsAccessAccessRw captures enum value "rw"
	AppNfsAccessAccessRw string = "rw"
)

// prop value enum
func (m *AppNfsAccess) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, appNfsAccessTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AppNfsAccess) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.Access) { // not required
		return nil
	}

	// value enum
	if err := m.validateAccessEnum("access", "body", *m.Access); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this app nfs access based on context it is used
func (m *AppNfsAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AppNfsAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AppNfsAccess) UnmarshalBinary(b []byte) error {
	var res AppNfsAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
