// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Application Applications
//
// swagger:model application
type Application struct {

	// links
	Links *ApplicationInlineLinks `json:"_links,omitempty"`

	// The time when the application was created.
	// Read Only: true
	CreationTimestamp *string `json:"creation_timestamp,omitempty"`

	// Should application storage elements be deleted? An application is considered to use storage elements from a shared storage pool. Possible values are 'true' and 'false'. If the value is 'true', the application will be deleted in its entirety. If the value is 'false', the storage elements will be disassociated from the application and preserved. The application will then be deleted.
	DeleteData *bool `json:"delete_data,omitempty"`

	// The generation number of the application. This indicates which features are supported on the application. For example, generation 1 applications do not support Snapshot copies. Support for Snapshot copies was added at generation 2. Any future generation numbers and their feature set will be documented.
	// Read Only: true
	Generation *int64 `json:"generation,omitempty"`

	// mongo db on san
	MongoDbOnSan *MongoDbOnSan `json:"mongo_db_on_san,omitempty"`

	// Application Name. This field is user supplied when the application is created.
	// Required: true
	Name *string `json:"name"`

	// nas
	Nas *Nas `json:"nas,omitempty"`

	// nvme
	Nvme *ZappNvme `json:"nvme,omitempty"`

	// oracle on nfs
	OracleOnNfs *OracleOnNfs `json:"oracle_on_nfs,omitempty"`

	// oracle on san
	OracleOnSan *OracleOnSan `json:"oracle_on_san,omitempty"`

	// oracle rac on nfs
	OracleRacOnNfs *OracleRacOnNfs `json:"oracle_rac_on_nfs,omitempty"`

	// oracle rac on san
	OracleRacOnSan *OracleRacOnSan `json:"oracle_rac_on_san,omitempty"`

	// Protection granularity determines the scope of Snapshot copy operations for the application. Possible values are "application" and "component". If the value is "application", Snapshot copy operations are performed on the entire application. If the value is "component", Snapshot copy operations are performed separately on the application components.
	// Read Only: true
	// Enum: ["application","component"]
	ProtectionGranularity *string `json:"protection_granularity,omitempty"`

	// rpo
	Rpo *ApplicationInlineRpo `json:"rpo,omitempty"`

	// s3 bucket
	S3Bucket *ZappS3Bucket `json:"s3_bucket,omitempty"`

	// san
	San *San `json:"san,omitempty"`

	// Identifies if this is a smart container or not.
	SmartContainer *bool `json:"smart_container,omitempty"`

	// sql on san
	SQLOnSan *SQLOnSan `json:"sql_on_san,omitempty"`

	// sql on smb
	SQLOnSmb *SQLOnSmb `json:"sql_on_smb,omitempty"`

	// The state of the application. For full functionality, applications must be in the online state. Other states indicate that the application is in a transient state and not all operations are supported.
	// Read Only: true
	// Enum: ["creating","deleting","modifying","online","restoring"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *ApplicationInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *ApplicationInlineSvm `json:"svm,omitempty"`

	// template
	Template *ApplicationInlineTemplate `json:"template,omitempty"`

	// Application UUID. This field is generated when the application is created.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// vdi on nas
	VdiOnNas *VdiOnNas `json:"vdi_on_nas,omitempty"`

	// vdi on san
	VdiOnSan *VdiOnSan `json:"vdi_on_san,omitempty"`

	// vsi on nas
	VsiOnNas *VsiOnNas `json:"vsi_on_nas,omitempty"`

	// vsi on san
	VsiOnSan *VsiOnSan `json:"vsi_on_san,omitempty"`
}

// Validate validates this application
func (m *Application) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMongoDbOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvme(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleRacOnNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleRacOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionGranularity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3Bucket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSQLOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSQLOnSmb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVsiOnNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVsiOnSan(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Application) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateMongoDbOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.MongoDbOnSan) { // not required
		return nil
	}

	if m.MongoDbOnSan != nil {
		if err := m.MongoDbOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mongo_db_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Application) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateNvme(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvme) { // not required
		return nil
	}

	if m.Nvme != nil {
		if err := m.Nvme.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateOracleOnNfs(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnNfs) { // not required
		return nil
	}

	if m.OracleOnNfs != nil {
		if err := m.OracleOnNfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateOracleOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnSan) { // not required
		return nil
	}

	if m.OracleOnSan != nil {
		if err := m.OracleOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateOracleRacOnNfs(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleRacOnNfs) { // not required
		return nil
	}

	if m.OracleRacOnNfs != nil {
		if err := m.OracleRacOnNfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_rac_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateOracleRacOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleRacOnSan) { // not required
		return nil
	}

	if m.OracleRacOnSan != nil {
		if err := m.OracleRacOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_rac_on_san")
			}
			return err
		}
	}

	return nil
}

var applicationTypeProtectionGranularityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["application","component"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationTypeProtectionGranularityPropEnum = append(applicationTypeProtectionGranularityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application
	// Application
	// protection_granularity
	// ProtectionGranularity
	// application
	// END DEBUGGING
	// ApplicationProtectionGranularityApplication captures enum value "application"
	ApplicationProtectionGranularityApplication string = "application"

	// BEGIN DEBUGGING
	// application
	// Application
	// protection_granularity
	// ProtectionGranularity
	// component
	// END DEBUGGING
	// ApplicationProtectionGranularityComponent captures enum value "component"
	ApplicationProtectionGranularityComponent string = "component"
)

// prop value enum
func (m *Application) validateProtectionGranularityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationTypeProtectionGranularityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Application) validateProtectionGranularity(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionGranularity) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtectionGranularityEnum("protection_granularity", "body", *m.ProtectionGranularity); err != nil {
		return err
	}

	return nil
}

func (m *Application) validateRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.Rpo) { // not required
		return nil
	}

	if m.Rpo != nil {
		if err := m.Rpo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateS3Bucket(formats strfmt.Registry) error {
	if swag.IsZero(m.S3Bucket) { // not required
		return nil
	}

	if m.S3Bucket != nil {
		if err := m.S3Bucket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateSan(formats strfmt.Registry) error {
	if swag.IsZero(m.San) { // not required
		return nil
	}

	if m.San != nil {
		if err := m.San.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateSQLOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.SQLOnSan) { // not required
		return nil
	}

	if m.SQLOnSan != nil {
		if err := m.SQLOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sql_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateSQLOnSmb(formats strfmt.Registry) error {
	if swag.IsZero(m.SQLOnSmb) { // not required
		return nil
	}

	if m.SQLOnSmb != nil {
		if err := m.SQLOnSmb.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sql_on_smb")
			}
			return err
		}
	}

	return nil
}

var applicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["creating","deleting","modifying","online","restoring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationTypeStatePropEnum = append(applicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application
	// Application
	// state
	// State
	// creating
	// END DEBUGGING
	// ApplicationStateCreating captures enum value "creating"
	ApplicationStateCreating string = "creating"

	// BEGIN DEBUGGING
	// application
	// Application
	// state
	// State
	// deleting
	// END DEBUGGING
	// ApplicationStateDeleting captures enum value "deleting"
	ApplicationStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// application
	// Application
	// state
	// State
	// modifying
	// END DEBUGGING
	// ApplicationStateModifying captures enum value "modifying"
	ApplicationStateModifying string = "modifying"

	// BEGIN DEBUGGING
	// application
	// Application
	// state
	// State
	// online
	// END DEBUGGING
	// ApplicationStateOnline captures enum value "online"
	ApplicationStateOnline string = "online"

	// BEGIN DEBUGGING
	// application
	// Application
	// state
	// State
	// restoring
	// END DEBUGGING
	// ApplicationStateRestoring captures enum value "restoring"
	ApplicationStateRestoring string = "restoring"
)

// prop value enum
func (m *Application) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Application) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Application) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.Template) { // not required
		return nil
	}

	if m.Template != nil {
		if err := m.Template.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateVdiOnNas(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnNas) { // not required
		return nil
	}

	if m.VdiOnNas != nil {
		if err := m.VdiOnNas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vdi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateVdiOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiOnSan) { // not required
		return nil
	}

	if m.VdiOnSan != nil {
		if err := m.VdiOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vdi_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateVsiOnNas(formats strfmt.Registry) error {
	if swag.IsZero(m.VsiOnNas) { // not required
		return nil
	}

	if m.VsiOnNas != nil {
		if err := m.VsiOnNas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vsi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) validateVsiOnSan(formats strfmt.Registry) error {
	if swag.IsZero(m.VsiOnSan) { // not required
		return nil
	}

	if m.VsiOnSan != nil {
		if err := m.VsiOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vsi_on_san")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application based on the context it is used
func (m *Application) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreationTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMongoDbOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvme(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleOnNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleRacOnNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleRacOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionGranularity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRpo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3Bucket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSQLOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSQLOnSmb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVdiOnNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVdiOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVsiOnNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVsiOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Application) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateCreationTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "creation_timestamp", "body", m.CreationTimestamp); err != nil {
		return err
	}

	return nil
}

func (m *Application) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *Application) contextValidateMongoDbOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.MongoDbOnSan != nil {
		if err := m.MongoDbOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mongo_db_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateNvme(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvme != nil {
		if err := m.Nvme.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvme")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateOracleOnNfs(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleOnNfs != nil {
		if err := m.OracleOnNfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateOracleOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleOnSan != nil {
		if err := m.OracleOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateOracleRacOnNfs(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleRacOnNfs != nil {
		if err := m.OracleRacOnNfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_rac_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateOracleRacOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleRacOnSan != nil {
		if err := m.OracleRacOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_rac_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateProtectionGranularity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protection_granularity", "body", m.ProtectionGranularity); err != nil {
		return err
	}

	return nil
}

func (m *Application) contextValidateRpo(ctx context.Context, formats strfmt.Registry) error {

	if m.Rpo != nil {
		if err := m.Rpo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateS3Bucket(ctx context.Context, formats strfmt.Registry) error {

	if m.S3Bucket != nil {
		if err := m.S3Bucket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateSan(ctx context.Context, formats strfmt.Registry) error {

	if m.San != nil {
		if err := m.San.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateSQLOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.SQLOnSan != nil {
		if err := m.SQLOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sql_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateSQLOnSmb(ctx context.Context, formats strfmt.Registry) error {

	if m.SQLOnSmb != nil {
		if err := m.SQLOnSmb.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sql_on_smb")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Application) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.Template != nil {
		if err := m.Template.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Application) contextValidateVdiOnNas(ctx context.Context, formats strfmt.Registry) error {

	if m.VdiOnNas != nil {
		if err := m.VdiOnNas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vdi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateVdiOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.VdiOnSan != nil {
		if err := m.VdiOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vdi_on_san")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateVsiOnNas(ctx context.Context, formats strfmt.Registry) error {

	if m.VsiOnNas != nil {
		if err := m.VsiOnNas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vsi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (m *Application) contextValidateVsiOnSan(ctx context.Context, formats strfmt.Registry) error {

	if m.VsiOnSan != nil {
		if err := m.VsiOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vsi_on_san")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Application) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Application) UnmarshalBinary(b []byte) error {
	var res Application
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineLinks application inline links
//
// swagger:model application_inline__links
type ApplicationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`

	// snapshots
	Snapshots *Href `json:"snapshots,omitempty"`
}

// Validate validates this application inline links
func (m *ApplicationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineLinks) validateSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshots) { // not required
		return nil
	}

	if m.Snapshots != nil {
		if err := m.Snapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "snapshots")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline links based on the context it is used
func (m *ApplicationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineLinks) contextValidateSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshots != nil {
		if err := m.Snapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "snapshots")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineRpo application inline rpo
//
// swagger:model application_inline_rpo
type ApplicationInlineRpo struct {

	// components
	// Read Only: true
	Components []*ApplicationRpoComponentsItems0 `json:"components,omitempty"`

	// Is RPO supported for this application? Generation 1 applications did not support Snapshot copies or MetroCluster.
	// Read Only: true
	IsSupported *bool `json:"is_supported,omitempty"`

	// local
	Local *ApplicationInlineRpoInlineLocal `json:"local,omitempty"`

	// remote
	Remote *ApplicationInlineRpoInlineRemote `json:"remote,omitempty"`
}

// Validate validates this application inline rpo
func (m *ApplicationInlineRpo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineRpo) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(m.Components) { // not required
		return nil
	}

	for i := 0; i < len(m.Components); i++ {
		if swag.IsZero(m.Components[i]) { // not required
			continue
		}

		if m.Components[i] != nil {
			if err := m.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rpo" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationInlineRpo) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineRpo) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline rpo based on the context it is used
func (m *ApplicationInlineRpo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineRpo) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"components", "body", []*ApplicationRpoComponentsItems0(m.Components)); err != nil {
		return err
	}

	for i := 0; i < len(m.Components); i++ {

		if m.Components[i] != nil {
			if err := m.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rpo" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationInlineRpo) contextValidateIsSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"is_supported", "body", m.IsSupported); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineRpo) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineRpo) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineRpo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineRpo) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationRpoComponentsItems0 application rpo components items0
//
// swagger:model ApplicationRpoComponentsItems0
type ApplicationRpoComponentsItems0 struct {

	// Component Name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// rpo
	Rpo *ApplicationRpoComponentsItems0Rpo `json:"rpo,omitempty"`

	// Component UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application rpo components items0
func (m *ApplicationRpoComponentsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0) validateRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.Rpo) { // not required
		return nil
	}

	if m.Rpo != nil {
		if err := m.Rpo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application rpo components items0 based on the context it is used
func (m *ApplicationRpoComponentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRpo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0) contextValidateRpo(ctx context.Context, formats strfmt.Registry) error {

	if m.Rpo != nil {
		if err := m.Rpo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0) UnmarshalBinary(b []byte) error {
	var res ApplicationRpoComponentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationRpoComponentsItems0Rpo application rpo components items0 rpo
//
// swagger:model ApplicationRpoComponentsItems0Rpo
type ApplicationRpoComponentsItems0Rpo struct {

	// local
	Local *ApplicationRpoComponentsItems0RpoLocal `json:"local,omitempty"`

	// remote
	Remote *ApplicationRpoComponentsItems0RpoRemote `json:"remote,omitempty"`
}

// Validate validates this application rpo components items0 rpo
func (m *ApplicationRpoComponentsItems0Rpo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0Rpo) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0Rpo) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application rpo components items0 rpo based on the context it is used
func (m *ApplicationRpoComponentsItems0Rpo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0Rpo) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0Rpo) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0Rpo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0Rpo) UnmarshalBinary(b []byte) error {
	var res ApplicationRpoComponentsItems0Rpo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationRpoComponentsItems0RpoLocal application rpo components items0 rpo local
//
// swagger:model ApplicationRpoComponentsItems0RpoLocal
type ApplicationRpoComponentsItems0RpoLocal struct {

	// A detailed description of the local RPO. This will include details about the Snapshot copy schedule.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The local RPO of the component. This indicates how often component Snapshot copies are automatically created.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application rpo components items0 rpo local
func (m *ApplicationRpoComponentsItems0RpoLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationRpoComponentsItems0RpoLocalTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationRpoComponentsItems0RpoLocalTypeNamePropEnum = append(applicationRpoComponentsItems0RpoLocalTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocal
	// ApplicationRpoComponentsItems0RpoLocal
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocalNameNr6Hourly captures enum value "6_hourly"
	ApplicationRpoComponentsItems0RpoLocalNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocal
	// ApplicationRpoComponentsItems0RpoLocal
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocalNameNr15Minutely captures enum value "15_minutely"
	ApplicationRpoComponentsItems0RpoLocalNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocal
	// ApplicationRpoComponentsItems0RpoLocal
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocalNameHourly captures enum value "hourly"
	ApplicationRpoComponentsItems0RpoLocalNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocal
	// ApplicationRpoComponentsItems0RpoLocal
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoLocalNameNone captures enum value "none"
	ApplicationRpoComponentsItems0RpoLocalNameNone string = "none"
)

// prop value enum
func (m *ApplicationRpoComponentsItems0RpoLocal) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationRpoComponentsItems0RpoLocalTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0RpoLocal) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("rpo"+"."+"local"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application rpo components items0 rpo local based on the context it is used
func (m *ApplicationRpoComponentsItems0RpoLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0RpoLocal) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0RpoLocal) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0RpoLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0RpoLocal) UnmarshalBinary(b []byte) error {
	var res ApplicationRpoComponentsItems0RpoLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationRpoComponentsItems0RpoRemote application rpo components items0 rpo remote
//
// swagger:model ApplicationRpoComponentsItems0RpoRemote
type ApplicationRpoComponentsItems0RpoRemote struct {

	// A detailed description of the remote RPO.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The remote RPO of the component. A remote RPO of zero indicates that the component is synchronously replicated to another cluster.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none","zero"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application rpo components items0 rpo remote
func (m *ApplicationRpoComponentsItems0RpoRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationRpoComponentsItems0RpoRemoteTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationRpoComponentsItems0RpoRemoteTypeNamePropEnum = append(applicationRpoComponentsItems0RpoRemoteTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemote
	// ApplicationRpoComponentsItems0RpoRemote
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemoteNameNr6Hourly captures enum value "6_hourly"
	ApplicationRpoComponentsItems0RpoRemoteNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemote
	// ApplicationRpoComponentsItems0RpoRemote
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemoteNameNr15Minutely captures enum value "15_minutely"
	ApplicationRpoComponentsItems0RpoRemoteNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemote
	// ApplicationRpoComponentsItems0RpoRemote
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemoteNameHourly captures enum value "hourly"
	ApplicationRpoComponentsItems0RpoRemoteNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemote
	// ApplicationRpoComponentsItems0RpoRemote
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemoteNameNone captures enum value "none"
	ApplicationRpoComponentsItems0RpoRemoteNameNone string = "none"

	// BEGIN DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemote
	// ApplicationRpoComponentsItems0RpoRemote
	// name
	// Name
	// zero
	// END DEBUGGING
	// ApplicationRpoComponentsItems0RpoRemoteNameZero captures enum value "zero"
	ApplicationRpoComponentsItems0RpoRemoteNameZero string = "zero"
)

// prop value enum
func (m *ApplicationRpoComponentsItems0RpoRemote) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationRpoComponentsItems0RpoRemoteTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0RpoRemote) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("rpo"+"."+"remote"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application rpo components items0 rpo remote based on the context it is used
func (m *ApplicationRpoComponentsItems0RpoRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationRpoComponentsItems0RpoRemote) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationRpoComponentsItems0RpoRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0RpoRemote) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationRpoComponentsItems0RpoRemote) UnmarshalBinary(b []byte) error {
	var res ApplicationRpoComponentsItems0RpoRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineRpoInlineLocal application inline rpo inline local
//
// swagger:model application_inline_rpo_inline_local
type ApplicationInlineRpoInlineLocal struct {

	// A detailed description of the local RPO. This will include details about the Snapshot copy schedule.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The local RPO of the application. This indicates how often application Snapshot copies are automatically created.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application inline rpo inline local
func (m *ApplicationInlineRpoInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationInlineRpoInlineLocalTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineRpoInlineLocalTypeNamePropEnum = append(applicationInlineRpoInlineLocalTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNr6Hourly captures enum value "6_hourly"
	ApplicationInlineRpoInlineLocalNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNr15Minutely captures enum value "15_minutely"
	ApplicationInlineRpoInlineLocalNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameHourly captures enum value "hourly"
	ApplicationInlineRpoInlineLocalNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNone captures enum value "none"
	ApplicationInlineRpoInlineLocalNameNone string = "none"
)

// prop value enum
func (m *ApplicationInlineRpoInlineLocal) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineRpoInlineLocalTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationInlineRpoInlineLocal) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("rpo"+"."+"local"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline rpo inline local based on the context it is used
func (m *ApplicationInlineRpoInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineRpoInlineLocal) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineRpoInlineLocal) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineRpoInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineRpoInlineLocal) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpoInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineRpoInlineRemote application inline rpo inline remote
//
// swagger:model application_inline_rpo_inline_remote
type ApplicationInlineRpoInlineRemote struct {

	// A detailed description of the remote RPO.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The remote RPO of the application. A remote RPO of zero indicates that the application is synchronously replicated to another cluster.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none","zero"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application inline rpo inline remote
func (m *ApplicationInlineRpoInlineRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationInlineRpoInlineRemoteTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineRpoInlineRemoteTypeNamePropEnum = append(applicationInlineRpoInlineRemoteTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNr6Hourly captures enum value "6_hourly"
	ApplicationInlineRpoInlineRemoteNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNr15Minutely captures enum value "15_minutely"
	ApplicationInlineRpoInlineRemoteNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameHourly captures enum value "hourly"
	ApplicationInlineRpoInlineRemoteNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNone captures enum value "none"
	ApplicationInlineRpoInlineRemoteNameNone string = "none"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// zero
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameZero captures enum value "zero"
	ApplicationInlineRpoInlineRemoteNameZero string = "zero"
)

// prop value enum
func (m *ApplicationInlineRpoInlineRemote) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineRpoInlineRemoteTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationInlineRpoInlineRemote) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("rpo"+"."+"remote"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline rpo inline remote based on the context it is used
func (m *ApplicationInlineRpoInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineRpoInlineRemote) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineRpoInlineRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineRpoInlineRemote) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineRpoInlineRemote) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpoInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineStatistics application inline statistics
//
// swagger:model application_inline_statistics
type ApplicationInlineStatistics struct {

	// components
	// Read Only: true
	Components []*ApplicationStatisticsComponentsItems0 `json:"components,omitempty"`

	// iops
	Iops *ApplicationInlineStatisticsInlineIops `json:"iops,omitempty"`

	// latency
	Latency *ApplicationInlineStatisticsInlineLatency `json:"latency,omitempty"`

	// An application is considered to use a shared storage pool if storage elements for multiple components reside on the same aggregate.
	// Read Only: true
	SharedStoragePool *bool `json:"shared_storage_pool,omitempty"`

	// snapshot
	Snapshot *ApplicationInlineStatisticsInlineSnapshot `json:"snapshot,omitempty"`

	// space
	Space *ApplicationInlineStatisticsInlineSpace `json:"space,omitempty"`

	// If not all storage elements of the application are currently available, the returned statistics might only include data from those elements that were available.
	// Read Only: true
	StatisticsIncomplete *bool `json:"statistics_incomplete,omitempty"`
}

// Validate validates this application inline statistics
func (m *ApplicationInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatistics) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(m.Components) { // not required
		return nil
	}

	for i := 0; i < len(m.Components); i++ {
		if swag.IsZero(m.Components[i]) { // not required
			continue
		}

		if m.Components[i] != nil {
			if err := m.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statistics" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationInlineStatistics) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline statistics based on the context it is used
func (m *ApplicationInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSharedStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatisticsIncomplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatistics) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"components", "body", []*ApplicationStatisticsComponentsItems0(m.Components)); err != nil {
		return err
	}

	for i := 0; i < len(m.Components); i++ {

		if m.Components[i] != nil {
			if err := m.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statistics" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateSharedStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"shared_storage_pool", "body", m.SharedStoragePool); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineStatistics) contextValidateStatisticsIncomplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"statistics_incomplete", "body", m.StatisticsIncomplete); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0 application statistics components items0
//
// swagger:model ApplicationStatisticsComponentsItems0
type ApplicationStatisticsComponentsItems0 struct {

	// iops
	Iops *ApplicationStatisticsComponentsItems0Iops `json:"iops,omitempty"`

	// latency
	Latency *ApplicationStatisticsComponentsItems0Latency `json:"latency,omitempty"`

	// Component Name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// An application component is considered to use a shared storage pool if storage elements for for other components reside on the same aggregate as storage elements for this component.
	// Read Only: true
	SharedStoragePool *bool `json:"shared_storage_pool,omitempty"`

	// snapshot
	Snapshot *ApplicationStatisticsComponentsItems0Snapshot `json:"snapshot,omitempty"`

	// space
	Space *ApplicationStatisticsComponentsItems0Space `json:"space,omitempty"`

	// If not all storage elements of the application component are currently available, the returned statistics might only include data from those elements that were available.
	// Read Only: true
	StatisticsIncomplete *bool `json:"statistics_incomplete,omitempty"`

	// storage service
	StorageService *ApplicationStatisticsComponentsItems0StorageService `json:"storage_service,omitempty"`

	// Component UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application statistics components items0
func (m *ApplicationStatisticsComponentsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application statistics components items0 based on the context it is used
func (m *ApplicationStatisticsComponentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSharedStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatisticsIncomplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateSharedStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "shared_storage_pool", "body", m.SharedStoragePool); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateStatisticsIncomplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics_incomplete", "body", m.StatisticsIncomplete); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0Iops application statistics components items0 iops
//
// swagger:model ApplicationStatisticsComponentsItems0Iops
type ApplicationStatisticsComponentsItems0Iops struct {

	// The number of IOPS per terabyte of logical space currently being used by the application component.
	// Read Only: true
	PerTb *int64 `json:"per_tb,omitempty"`

	// The total number of IOPS being used by the application component.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this application statistics components items0 iops
func (m *ApplicationStatisticsComponentsItems0Iops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application statistics components items0 iops based on the context it is used
func (m *ApplicationStatisticsComponentsItems0Iops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePerTb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0Iops) contextValidatePerTb(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "iops"+"."+"per_tb", "body", m.PerTb); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Iops) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "iops"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Iops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Iops) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0Iops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0Latency application statistics components items0 latency
//
// swagger:model ApplicationStatisticsComponentsItems0Latency
type ApplicationStatisticsComponentsItems0Latency struct {

	// The cumulative average response time in microseconds for this component.
	// Read Only: true
	Average *int64 `json:"average,omitempty"`

	// The cumulative response time in microseconds for this component.
	// Read Only: true
	Raw *int64 `json:"raw,omitempty"`
}

// Validate validates this application statistics components items0 latency
func (m *ApplicationStatisticsComponentsItems0Latency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application statistics components items0 latency based on the context it is used
func (m *ApplicationStatisticsComponentsItems0Latency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAverage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0Latency) contextValidateAverage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "latency"+"."+"average", "body", m.Average); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Latency) contextValidateRaw(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "latency"+"."+"raw", "body", m.Raw); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Latency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Latency) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0Latency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0Snapshot application statistics components items0 snapshot
//
// swagger:model ApplicationStatisticsComponentsItems0Snapshot
type ApplicationStatisticsComponentsItems0Snapshot struct {

	// The amount of space reserved by the system for Snapshot copies.
	// Read Only: true
	Reserve *int64 `json:"reserve,omitempty"`

	// The amount of spacing currently in use by the system to store Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this application statistics components items0 snapshot
func (m *ApplicationStatisticsComponentsItems0Snapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application statistics components items0 snapshot based on the context it is used
func (m *ApplicationStatisticsComponentsItems0Snapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0Snapshot) contextValidateReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"reserve", "body", m.Reserve); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Snapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Snapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Snapshot) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0Snapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0Space application statistics components items0 space
//
// swagger:model ApplicationStatisticsComponentsItems0Space
type ApplicationStatisticsComponentsItems0Space struct {

	// The available amount of space left in the application component. Note that this field has limited meaning for SAN applications. Space may be considered used from ONTAP's perspective while the host filesystem still considers it available.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The amount of space that would currently be used if no space saving features were enabled. For example, if compression were the only space saving feature enabled, this field would represent the uncompressed amount of space used.
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// The originally requested amount of space that was provisioned for the application component.
	// Read Only: true
	Provisioned *int64 `json:"provisioned,omitempty"`

	// The amount of space reserved for system features such as Snapshot copies that has not yet been used.
	// Read Only: true
	ReservedUnused *int64 `json:"reserved_unused,omitempty"`

	// The amount of space saved by all enabled space saving features.
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// The amount of space that is currently being used by the application component. Note that this includes any space reserved by the system for features such as Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The amount of space that is currently being used, excluding any space that is reserved by the system for features such as Snapshot copies.
	// Read Only: true
	UsedExcludingReserves *int64 `json:"used_excluding_reserves,omitempty"`

	// The percentage of the originally provisioned space that is currently being used by the application component.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this application statistics components items0 space
func (m *ApplicationStatisticsComponentsItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application statistics components items0 space based on the context it is used
func (m *ApplicationStatisticsComponentsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReservedUnused(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedExcludingReserves(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"provisioned", "body", m.Provisioned); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateReservedUnused(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"reserved_unused", "body", m.ReservedUnused); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateUsedExcludingReserves(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_excluding_reserves", "body", m.UsedExcludingReserves); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0Space) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_percent", "body", m.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Space) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0Space) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationStatisticsComponentsItems0StorageService application statistics components items0 storage service
//
// swagger:model ApplicationStatisticsComponentsItems0StorageService
type ApplicationStatisticsComponentsItems0StorageService struct {

	// The storage service name. AFF systems support the extreme storage service. All other systems only support value.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The storage service UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application statistics components items0 storage service
func (m *ApplicationStatisticsComponentsItems0StorageService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application statistics components items0 storage service based on the context it is used
func (m *ApplicationStatisticsComponentsItems0StorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationStatisticsComponentsItems0StorageService) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationStatisticsComponentsItems0StorageService) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0StorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationStatisticsComponentsItems0StorageService) UnmarshalBinary(b []byte) error {
	var res ApplicationStatisticsComponentsItems0StorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineStatisticsInlineIops application inline statistics inline iops
//
// swagger:model application_inline_statistics_inline_iops
type ApplicationInlineStatisticsInlineIops struct {

	// The number of IOPS per terabyte of logical space currently being used by the application.
	// Read Only: true
	PerTb *int64 `json:"per_tb,omitempty"`

	// The total number of IOPS being used by the application.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this application inline statistics inline iops
func (m *ApplicationInlineStatisticsInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline iops based on the context it is used
func (m *ApplicationInlineStatisticsInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePerTb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatisticsInlineIops) contextValidatePerTb(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"iops"+"."+"per_tb", "body", m.PerTb); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineIops) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"iops"+"."+"total", "body", m.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineIops) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineStatisticsInlineLatency application inline statistics inline latency
//
// swagger:model application_inline_statistics_inline_latency
type ApplicationInlineStatisticsInlineLatency struct {

	// The cumulative average response time in microseconds for this application.
	// Read Only: true
	Average *int64 `json:"average,omitempty"`

	// The cumulative response time in microseconds for this application.
	// Read Only: true
	Raw *int64 `json:"raw,omitempty"`
}

// Validate validates this application inline statistics inline latency
func (m *ApplicationInlineStatisticsInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline latency based on the context it is used
func (m *ApplicationInlineStatisticsInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAverage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatisticsInlineLatency) contextValidateAverage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"latency"+"."+"average", "body", m.Average); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineLatency) contextValidateRaw(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"latency"+"."+"raw", "body", m.Raw); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineLatency) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineStatisticsInlineSnapshot application inline statistics inline snapshot
//
// swagger:model application_inline_statistics_inline_snapshot
type ApplicationInlineStatisticsInlineSnapshot struct {

	// The amount of space reserved by the system for Snapshot copies.
	// Read Only: true
	Reserve *int64 `json:"reserve,omitempty"`

	// The amount of spacing currently in use by the system to store Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this application inline statistics inline snapshot
func (m *ApplicationInlineStatisticsInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline snapshot based on the context it is used
func (m *ApplicationInlineStatisticsInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatisticsInlineSnapshot) contextValidateReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"snapshot"+"."+"reserve", "body", m.Reserve); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"snapshot"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineStatisticsInlineSpace application inline statistics inline space
//
// swagger:model application_inline_statistics_inline_space
type ApplicationInlineStatisticsInlineSpace struct {

	// The available amount of space left in the application. Note that this field has limited meaning for SAN applications. Space may be considered used from ONTAP's perspective while the host filesystem still considers it available.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The amount of space that would currently be used if no space saving features were enabled. For example, if compression were the only space saving feature enabled, this field would represent the uncompressed amount of space used.
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// The originally requested amount of space that was provisioned for the application.
	// Read Only: true
	Provisioned *int64 `json:"provisioned,omitempty"`

	// The amount of space reserved for system features such as Snapshot copies that has not yet been used.
	// Read Only: true
	ReservedUnused *int64 `json:"reserved_unused,omitempty"`

	// The amount of space saved by all enabled space saving features.
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// The amount of space that is currently being used by the application. Note that this includes any space reserved by the system for features such as Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The amount of space that is currently being used, excluding any space that is reserved by the system for features such as Snapshot copies.
	// Read Only: true
	UsedExcludingReserves *int64 `json:"used_excluding_reserves,omitempty"`

	// The percentage of the originally provisioned space that is currently being used by the application.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this application inline statistics inline space
func (m *ApplicationInlineStatisticsInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline space based on the context it is used
func (m *ApplicationInlineStatisticsInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReservedUnused(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedExcludingReserves(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"provisioned", "body", m.Provisioned); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateReservedUnused(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"reserved_unused", "body", m.ReservedUnused); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateUsedExcludingReserves(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"used_excluding_reserves", "body", m.UsedExcludingReserves); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineStatisticsInlineSpace) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"space"+"."+"used_percent", "body", m.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineStatisticsInlineSpace) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineSvm application inline svm
//
// swagger:model application_inline_svm
type ApplicationInlineSvm struct {

	// SVM Name. Either the SVM name or UUID must be provided to create an application.
	Name *string `json:"name,omitempty"`

	// SVM UUID. Either the SVM name or UUID must be provided to create an application.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application inline svm
func (m *ApplicationInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this application inline svm based on context it is used
func (m *ApplicationInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineSvm) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationInlineTemplate application inline template
//
// swagger:model application_inline_template
type ApplicationInlineTemplate struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the template that was used to provision this application.
	Name *string `json:"name,omitempty"`

	// The protocol access of the template that was used to provision this application.
	// Read Only: true
	// Enum: ["nas","nvme","s3","san"]
	Protocol *string `json:"protocol,omitempty"`

	// The version of the template that was used to provision this application. The template version changes only if the layout of the application changes over time. For example, redo logs in Oracle RAC templates were updated and provisioned differently in DATA ONTAP 9.3.0 compared to prior releases, so the version number was increased. If layouts change in the future, the changes will be documented along with the corresponding version numbers.
	// Read Only: true
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this application inline template
func (m *ApplicationInlineTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var applicationInlineTemplateTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nas","nvme","s3","san"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineTemplateTypeProtocolPropEnum = append(applicationInlineTemplateTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// nas
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolNas captures enum value "nas"
	ApplicationInlineTemplateProtocolNas string = "nas"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// nvme
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolNvme captures enum value "nvme"
	ApplicationInlineTemplateProtocolNvme string = "nvme"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// s3
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolS3 captures enum value "s3"
	ApplicationInlineTemplateProtocolS3 string = "s3"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// san
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolSan captures enum value "san"
	ApplicationInlineTemplateProtocolSan string = "san"
)

// prop value enum
func (m *ApplicationInlineTemplate) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineTemplateTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationInlineTemplate) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("template"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline template based on the context it is used
func (m *ApplicationInlineTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationInlineTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationInlineTemplate) contextValidateProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "template"+"."+"protocol", "body", m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationInlineTemplate) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "template"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationInlineTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationInlineTemplate) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
