// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationCifsProperties application cifs properties
//
// swagger:model application_cifs_properties
type ApplicationCifsProperties struct {

	// application cifs properties inline ips
	ApplicationCifsPropertiesInlineIps []*string `json:"ips,omitempty"`

	// application cifs properties inline permissions
	// Read Only: true
	ApplicationCifsPropertiesInlinePermissions []*ApplicationCifsPropertiesInlinePermissionsInlineArrayItem `json:"permissions,omitempty"`

	// backing storage
	BackingStorage *ApplicationCifsPropertiesInlineBackingStorage `json:"backing_storage,omitempty"`

	// Junction path
	// Read Only: true
	Path *string `json:"path,omitempty"`

	// server
	Server *ApplicationCifsPropertiesInlineServer `json:"server,omitempty"`

	// share
	Share *ApplicationCifsPropertiesInlineShare `json:"share,omitempty"`
}

// Validate validates this application cifs properties
func (m *ApplicationCifsProperties) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationCifsPropertiesInlinePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackingStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsProperties) validateApplicationCifsPropertiesInlinePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationCifsPropertiesInlinePermissions) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationCifsPropertiesInlinePermissions); i++ {
		if swag.IsZero(m.ApplicationCifsPropertiesInlinePermissions[i]) { // not required
			continue
		}

		if m.ApplicationCifsPropertiesInlinePermissions[i] != nil {
			if err := m.ApplicationCifsPropertiesInlinePermissions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationCifsProperties) validateBackingStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingStorage) { // not required
		return nil
	}

	if m.BackingStorage != nil {
		if err := m.BackingStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationCifsProperties) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	if m.Server != nil {
		if err := m.Server.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationCifsProperties) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if m.Share != nil {
		if err := m.Share.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application cifs properties based on the context it is used
func (m *ApplicationCifsProperties) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplicationCifsPropertiesInlineIps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationCifsPropertiesInlinePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackingStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShare(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsProperties) contextValidateApplicationCifsPropertiesInlineIps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationCifsPropertiesInlineIps); i++ {

		if err := validate.ReadOnly(ctx, "ips"+"."+strconv.Itoa(i), "body", m.ApplicationCifsPropertiesInlineIps[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *ApplicationCifsProperties) contextValidateApplicationCifsPropertiesInlinePermissions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "permissions", "body", []*ApplicationCifsPropertiesInlinePermissionsInlineArrayItem(m.ApplicationCifsPropertiesInlinePermissions)); err != nil {
		return err
	}

	for i := 0; i < len(m.ApplicationCifsPropertiesInlinePermissions); i++ {

		if m.ApplicationCifsPropertiesInlinePermissions[i] != nil {
			if err := m.ApplicationCifsPropertiesInlinePermissions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationCifsProperties) contextValidateBackingStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BackingStorage != nil {
		if err := m.BackingStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationCifsProperties) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationCifsProperties) contextValidateServer(ctx context.Context, formats strfmt.Registry) error {

	if m.Server != nil {
		if err := m.Server.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationCifsProperties) contextValidateShare(ctx context.Context, formats strfmt.Registry) error {

	if m.Share != nil {
		if err := m.Share.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationCifsProperties) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationCifsProperties) UnmarshalBinary(b []byte) error {
	var res ApplicationCifsProperties
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationCifsPropertiesInlineBackingStorage application cifs properties inline backing storage
//
// swagger:model application_cifs_properties_inline_backing_storage
type ApplicationCifsPropertiesInlineBackingStorage struct {

	// Backing storage type
	// Read Only: true
	// Enum: ["volume"]
	Type *string `json:"type,omitempty"`

	// Backing storage UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application cifs properties inline backing storage
func (m *ApplicationCifsPropertiesInlineBackingStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationCifsPropertiesInlineBackingStorageTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationCifsPropertiesInlineBackingStorageTypeTypePropEnum = append(applicationCifsPropertiesInlineBackingStorageTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_cifs_properties_inline_backing_storage
	// ApplicationCifsPropertiesInlineBackingStorage
	// type
	// Type
	// volume
	// END DEBUGGING
	// ApplicationCifsPropertiesInlineBackingStorageTypeVolume captures enum value "volume"
	ApplicationCifsPropertiesInlineBackingStorageTypeVolume string = "volume"
)

// prop value enum
func (m *ApplicationCifsPropertiesInlineBackingStorage) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationCifsPropertiesInlineBackingStorageTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationCifsPropertiesInlineBackingStorage) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("backing_storage"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application cifs properties inline backing storage based on the context it is used
func (m *ApplicationCifsPropertiesInlineBackingStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsPropertiesInlineBackingStorage) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationCifsPropertiesInlineBackingStorage) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineBackingStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineBackingStorage) UnmarshalBinary(b []byte) error {
	var res ApplicationCifsPropertiesInlineBackingStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationCifsPropertiesInlinePermissionsInlineArrayItem application cifs properties inline permissions inline array item
//
// swagger:model application_cifs_properties_inline_permissions_inline_array_item
type ApplicationCifsPropertiesInlinePermissionsInlineArrayItem struct {

	// Access granted to the user or group
	// Read Only: true
	Access *string `json:"access,omitempty"`

	// User or group
	// Read Only: true
	UserOrGroup *string `json:"user_or_group,omitempty"`
}

// Validate validates this application cifs properties inline permissions inline array item
func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application cifs properties inline permissions inline array item based on the context it is used
func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserOrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access", "body", m.Access); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) contextValidateUserOrGroup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_or_group", "body", m.UserOrGroup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlinePermissionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ApplicationCifsPropertiesInlinePermissionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationCifsPropertiesInlineServer application cifs properties inline server
//
// swagger:model application_cifs_properties_inline_server
type ApplicationCifsPropertiesInlineServer struct {

	// Server name
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this application cifs properties inline server
func (m *ApplicationCifsPropertiesInlineServer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application cifs properties inline server based on the context it is used
func (m *ApplicationCifsPropertiesInlineServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsPropertiesInlineServer) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "server"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineServer) UnmarshalBinary(b []byte) error {
	var res ApplicationCifsPropertiesInlineServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationCifsPropertiesInlineShare application cifs properties inline share
//
// swagger:model application_cifs_properties_inline_share
type ApplicationCifsPropertiesInlineShare struct {

	// Share name
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this application cifs properties inline share
func (m *ApplicationCifsPropertiesInlineShare) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application cifs properties inline share based on the context it is used
func (m *ApplicationCifsPropertiesInlineShare) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationCifsPropertiesInlineShare) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "share"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineShare) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationCifsPropertiesInlineShare) UnmarshalBinary(b []byte) error {
	var res ApplicationCifsPropertiesInlineShare
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
