// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationComponent Application component
//
// swagger:model application_component
type ApplicationComponent struct {

	// links
	Links *ApplicationComponentInlineLinks `json:"_links,omitempty"`

	// application
	Application *ApplicationComponentInlineApplication `json:"application,omitempty"`

	// application component inline cifs access
	ApplicationComponentInlineCifsAccess []*ApplicationCifsProperties `json:"cifs_access,omitempty"`

	// application component inline nfs access
	ApplicationComponentInlineNfsAccess []*ApplicationNfsProperties `json:"nfs_access,omitempty"`

	// application component inline nvme access
	ApplicationComponentInlineNvmeAccess []*ApplicationNvmeAccess `json:"nvme_access,omitempty"`

	// application component inline protection groups
	ApplicationComponentInlineProtectionGroups []*ApplicationProtectionGroups `json:"protection_groups,omitempty"`

	// application component inline san access
	ApplicationComponentInlineSanAccess []*ApplicationSanAccess `json:"san_access,omitempty"`

	// backing storage
	BackingStorage *ApplicationBackingStorage `json:"backing_storage,omitempty"`

	// Defines the type of file system that will be installed on this application component.
	// Read Only: true
	// Enum: ["m1fs","xfs","generic"]
	FileSystem *string `json:"file_system,omitempty"`

	// Host management URL
	// Read Only: true
	HostManagementURL *string `json:"host_management_url,omitempty"`

	// L2 Host FQDN
	// Read Only: true
	HostName *string `json:"host_name,omitempty"`

	// Application component name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// storage service
	StorageService *ApplicationComponentInlineStorageService `json:"storage_service,omitempty"`

	// svm
	Svm *ApplicationComponentInlineSvm `json:"svm,omitempty"`

	// The application component UUID. Valid in URL.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application component
func (m *ApplicationComponent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationComponentInlineCifsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationComponentInlineNfsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationComponentInlineNvmeAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationComponentInlineProtectionGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationComponentInlineSanAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackingStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileSystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) validateApplicationComponentInlineCifsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationComponentInlineCifsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationComponentInlineCifsAccess); i++ {
		if swag.IsZero(m.ApplicationComponentInlineCifsAccess[i]) { // not required
			continue
		}

		if m.ApplicationComponentInlineCifsAccess[i] != nil {
			if err := m.ApplicationComponentInlineCifsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cifs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) validateApplicationComponentInlineNfsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationComponentInlineNfsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationComponentInlineNfsAccess); i++ {
		if swag.IsZero(m.ApplicationComponentInlineNfsAccess[i]) { // not required
			continue
		}

		if m.ApplicationComponentInlineNfsAccess[i] != nil {
			if err := m.ApplicationComponentInlineNfsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) validateApplicationComponentInlineNvmeAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationComponentInlineNvmeAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationComponentInlineNvmeAccess); i++ {
		if swag.IsZero(m.ApplicationComponentInlineNvmeAccess[i]) { // not required
			continue
		}

		if m.ApplicationComponentInlineNvmeAccess[i] != nil {
			if err := m.ApplicationComponentInlineNvmeAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nvme_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) validateApplicationComponentInlineProtectionGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationComponentInlineProtectionGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationComponentInlineProtectionGroups); i++ {
		if swag.IsZero(m.ApplicationComponentInlineProtectionGroups[i]) { // not required
			continue
		}

		if m.ApplicationComponentInlineProtectionGroups[i] != nil {
			if err := m.ApplicationComponentInlineProtectionGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("protection_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) validateApplicationComponentInlineSanAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationComponentInlineSanAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationComponentInlineSanAccess); i++ {
		if swag.IsZero(m.ApplicationComponentInlineSanAccess[i]) { // not required
			continue
		}

		if m.ApplicationComponentInlineSanAccess[i] != nil {
			if err := m.ApplicationComponentInlineSanAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("san_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) validateBackingStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingStorage) { // not required
		return nil
	}

	if m.BackingStorage != nil {
		if err := m.BackingStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

var applicationComponentTypeFileSystemPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["m1fs","xfs","generic"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationComponentTypeFileSystemPropEnum = append(applicationComponentTypeFileSystemPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_component
	// ApplicationComponent
	// file_system
	// FileSystem
	// m1fs
	// END DEBUGGING
	// ApplicationComponentFileSystemM1fs captures enum value "m1fs"
	ApplicationComponentFileSystemM1fs string = "m1fs"

	// BEGIN DEBUGGING
	// application_component
	// ApplicationComponent
	// file_system
	// FileSystem
	// xfs
	// END DEBUGGING
	// ApplicationComponentFileSystemXfs captures enum value "xfs"
	ApplicationComponentFileSystemXfs string = "xfs"

	// BEGIN DEBUGGING
	// application_component
	// ApplicationComponent
	// file_system
	// FileSystem
	// generic
	// END DEBUGGING
	// ApplicationComponentFileSystemGeneric captures enum value "generic"
	ApplicationComponentFileSystemGeneric string = "generic"
)

// prop value enum
func (m *ApplicationComponent) validateFileSystemEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationComponentTypeFileSystemPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationComponent) validateFileSystem(formats strfmt.Registry) error {
	if swag.IsZero(m.FileSystem) { // not required
		return nil
	}

	// value enum
	if err := m.validateFileSystemEnum("file_system", "body", *m.FileSystem); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponent) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application component based on the context it is used
func (m *ApplicationComponent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationComponentInlineCifsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationComponentInlineNfsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationComponentInlineNvmeAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationComponentInlineProtectionGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationComponentInlineSanAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackingStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFileSystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostManagementURL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplicationComponentInlineCifsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationComponentInlineCifsAccess); i++ {

		if m.ApplicationComponentInlineCifsAccess[i] != nil {
			if err := m.ApplicationComponentInlineCifsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cifs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplicationComponentInlineNfsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationComponentInlineNfsAccess); i++ {

		if m.ApplicationComponentInlineNfsAccess[i] != nil {
			if err := m.ApplicationComponentInlineNfsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplicationComponentInlineNvmeAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationComponentInlineNvmeAccess); i++ {

		if m.ApplicationComponentInlineNvmeAccess[i] != nil {
			if err := m.ApplicationComponentInlineNvmeAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nvme_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplicationComponentInlineProtectionGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationComponentInlineProtectionGroups); i++ {

		if m.ApplicationComponentInlineProtectionGroups[i] != nil {
			if err := m.ApplicationComponentInlineProtectionGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("protection_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) contextValidateApplicationComponentInlineSanAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationComponentInlineSanAccess); i++ {

		if m.ApplicationComponentInlineSanAccess[i] != nil {
			if err := m.ApplicationComponentInlineSanAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("san_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationComponent) contextValidateBackingStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BackingStorage != nil {
		if err := m.BackingStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) contextValidateFileSystem(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file_system", "body", m.FileSystem); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponent) contextValidateHostManagementURL(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_management_url", "body", m.HostManagementURL); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponent) contextValidateHostName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_name", "body", m.HostName); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponent) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponent) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponent) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponent) UnmarshalBinary(b []byte) error {
	var res ApplicationComponent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationComponentInlineApplication application component inline application
//
// swagger:model application_component_inline_application
type ApplicationComponentInlineApplication struct {

	// links
	Links *ApplicationComponentInlineApplicationInlineLinks `json:"_links,omitempty"`

	// Application name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The application UUID. Valid in URL.
	// Required: true
	// Read Only: true
	UUID *string `json:"uuid"`
}

// Validate validates this application component inline application
func (m *ApplicationComponentInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineApplication) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponentInlineApplication) validateUUID(formats strfmt.Registry) error {

	if err := validate.Required("application"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application component inline application based on the context it is used
func (m *ApplicationComponentInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineApplication) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationComponentInlineApplication) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponentInlineApplication) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponentInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponentInlineApplication) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationComponentInlineApplicationInlineLinks application component inline application inline links
//
// swagger:model application_component_inline_application_inline__links
type ApplicationComponentInlineApplicationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application component inline application inline links
func (m *ApplicationComponentInlineApplicationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineApplicationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application component inline application inline links based on the context it is used
func (m *ApplicationComponentInlineApplicationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineApplicationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponentInlineApplicationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponentInlineApplicationInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentInlineApplicationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationComponentInlineLinks application component inline links
//
// swagger:model application_component_inline__links
type ApplicationComponentInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application component inline links
func (m *ApplicationComponentInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application component inline links based on the context it is used
func (m *ApplicationComponentInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponentInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponentInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationComponentInlineStorageService application component inline storage service
//
// swagger:model application_component_inline_storage_service
type ApplicationComponentInlineStorageService struct {

	// Storage service name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Storage service UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application component inline storage service
func (m *ApplicationComponentInlineStorageService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application component inline storage service based on the context it is used
func (m *ApplicationComponentInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineStorageService) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponentInlineStorageService) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponentInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponentInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationComponentInlineSvm application component inline svm
//
// swagger:model application_component_inline_svm
type ApplicationComponentInlineSvm struct {

	// SVM name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// SVM UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application component inline svm
func (m *ApplicationComponentInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application component inline svm based on the context it is used
func (m *ApplicationComponentInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationComponentInlineSvm) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationComponentInlineSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationComponentInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationComponentInlineSvm) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
