// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationLunMappingObject application lun mapping object
//
// swagger:model application_lun_mapping_object
type ApplicationLunMappingObject struct {

	// All possible Fibre Channel Protocol (FCP) access endpoints for the LUN.
	// Read Only: true
	ApplicationLunMappingObjectInlineFcp []*ApplicationSanAccessFcpEndpoint `json:"fcp,omitempty"`

	// All possible iSCSI access endpoints for the LUN.
	// Read Only: true
	ApplicationLunMappingObjectInlineIscsi []*ApplicationSanAccessIscsiEndpoint `json:"iscsi,omitempty"`

	// igroup
	Igroup *ApplicationLunMappingObjectInlineIgroup `json:"igroup,omitempty"`

	// LUN ID
	// Read Only: true
	// Maximum: 4095
	// Minimum: 0
	LunID *int64 `json:"lun_id,omitempty"`
}

// Validate validates this application lun mapping object
func (m *ApplicationLunMappingObject) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationLunMappingObjectInlineFcp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationLunMappingObjectInlineIscsi(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationLunMappingObject) validateApplicationLunMappingObjectInlineFcp(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationLunMappingObjectInlineFcp) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationLunMappingObjectInlineFcp); i++ {
		if swag.IsZero(m.ApplicationLunMappingObjectInlineFcp[i]) { // not required
			continue
		}

		if m.ApplicationLunMappingObjectInlineFcp[i] != nil {
			if err := m.ApplicationLunMappingObjectInlineFcp[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fcp" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationLunMappingObject) validateApplicationLunMappingObjectInlineIscsi(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationLunMappingObjectInlineIscsi) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationLunMappingObjectInlineIscsi); i++ {
		if swag.IsZero(m.ApplicationLunMappingObjectInlineIscsi[i]) { // not required
			continue
		}

		if m.ApplicationLunMappingObjectInlineIscsi[i] != nil {
			if err := m.ApplicationLunMappingObjectInlineIscsi[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("iscsi" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationLunMappingObject) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationLunMappingObject) validateLunID(formats strfmt.Registry) error {
	if swag.IsZero(m.LunID) { // not required
		return nil
	}

	if err := validate.MinimumInt("lun_id", "body", *m.LunID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("lun_id", "body", *m.LunID, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application lun mapping object based on the context it is used
func (m *ApplicationLunMappingObject) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplicationLunMappingObjectInlineFcp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationLunMappingObjectInlineIscsi(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationLunMappingObject) contextValidateApplicationLunMappingObjectInlineFcp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fcp", "body", []*ApplicationSanAccessFcpEndpoint(m.ApplicationLunMappingObjectInlineFcp)); err != nil {
		return err
	}

	for i := 0; i < len(m.ApplicationLunMappingObjectInlineFcp); i++ {

		if m.ApplicationLunMappingObjectInlineFcp[i] != nil {
			if err := m.ApplicationLunMappingObjectInlineFcp[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("fcp" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationLunMappingObject) contextValidateApplicationLunMappingObjectInlineIscsi(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "iscsi", "body", []*ApplicationSanAccessIscsiEndpoint(m.ApplicationLunMappingObjectInlineIscsi)); err != nil {
		return err
	}

	for i := 0; i < len(m.ApplicationLunMappingObjectInlineIscsi); i++ {

		if m.ApplicationLunMappingObjectInlineIscsi[i] != nil {
			if err := m.ApplicationLunMappingObjectInlineIscsi[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("iscsi" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationLunMappingObject) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationLunMappingObject) contextValidateLunID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun_id", "body", m.LunID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationLunMappingObject) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationLunMappingObject) UnmarshalBinary(b []byte) error {
	var res ApplicationLunMappingObject
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationLunMappingObjectInlineIgroup application lun mapping object inline igroup
//
// swagger:model application_lun_mapping_object_inline_igroup
type ApplicationLunMappingObjectInlineIgroup struct {

	// initiators
	Initiators []*string `json:"initiators,omitempty"`

	// Igroup name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Igroup UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application lun mapping object inline igroup
func (m *ApplicationLunMappingObjectInlineIgroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application lun mapping object inline igroup based on the context it is used
func (m *ApplicationLunMappingObjectInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationLunMappingObjectInlineIgroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Initiators); i++ {

		if err := validate.ReadOnly(ctx, "igroup"+"."+"initiators"+"."+strconv.Itoa(i), "body", m.Initiators[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *ApplicationLunMappingObjectInlineIgroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationLunMappingObjectInlineIgroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationLunMappingObjectInlineIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationLunMappingObjectInlineIgroup) UnmarshalBinary(b []byte) error {
	var res ApplicationLunMappingObjectInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
