// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationNfsProperties application nfs properties
//
// swagger:model application_nfs_properties
type ApplicationNfsProperties struct {

	// application nfs properties inline ips
	ApplicationNfsPropertiesInlineIps []*string `json:"ips,omitempty"`

	// application nfs properties inline permissions
	// Read Only: true
	ApplicationNfsPropertiesInlinePermissions []*ApplicationNfsPropertiesInlinePermissionsInlineArrayItem `json:"permissions,omitempty"`

	// backing storage
	BackingStorage *ApplicationNfsPropertiesInlineBackingStorage `json:"backing_storage,omitempty"`

	// export policy
	ExportPolicy *ApplicationNfsPropertiesInlineExportPolicy `json:"export_policy,omitempty"`

	// Junction path
	// Read Only: true
	Path *string `json:"path,omitempty"`
}

// Validate validates this application nfs properties
func (m *ApplicationNfsProperties) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationNfsPropertiesInlinePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackingStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNfsProperties) validateApplicationNfsPropertiesInlinePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationNfsPropertiesInlinePermissions) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationNfsPropertiesInlinePermissions); i++ {
		if swag.IsZero(m.ApplicationNfsPropertiesInlinePermissions[i]) { // not required
			continue
		}

		if m.ApplicationNfsPropertiesInlinePermissions[i] != nil {
			if err := m.ApplicationNfsPropertiesInlinePermissions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationNfsProperties) validateBackingStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingStorage) { // not required
		return nil
	}

	if m.BackingStorage != nil {
		if err := m.BackingStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNfsProperties) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nfs properties based on the context it is used
func (m *ApplicationNfsProperties) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplicationNfsPropertiesInlineIps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationNfsPropertiesInlinePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackingStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNfsProperties) contextValidateApplicationNfsPropertiesInlineIps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ApplicationNfsPropertiesInlineIps); i++ {

		if err := validate.ReadOnly(ctx, "ips"+"."+strconv.Itoa(i), "body", m.ApplicationNfsPropertiesInlineIps[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *ApplicationNfsProperties) contextValidateApplicationNfsPropertiesInlinePermissions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "permissions", "body", []*ApplicationNfsPropertiesInlinePermissionsInlineArrayItem(m.ApplicationNfsPropertiesInlinePermissions)); err != nil {
		return err
	}

	for i := 0; i < len(m.ApplicationNfsPropertiesInlinePermissions); i++ {

		if m.ApplicationNfsPropertiesInlinePermissions[i] != nil {
			if err := m.ApplicationNfsPropertiesInlinePermissions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationNfsProperties) contextValidateBackingStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BackingStorage != nil {
		if err := m.BackingStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNfsProperties) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNfsProperties) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNfsProperties) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNfsProperties) UnmarshalBinary(b []byte) error {
	var res ApplicationNfsProperties
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNfsPropertiesInlineBackingStorage application nfs properties inline backing storage
//
// swagger:model application_nfs_properties_inline_backing_storage
type ApplicationNfsPropertiesInlineBackingStorage struct {

	// Backing storage type
	// Read Only: true
	// Enum: ["volume"]
	Type *string `json:"type,omitempty"`

	// Backing storage UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application nfs properties inline backing storage
func (m *ApplicationNfsPropertiesInlineBackingStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationNfsPropertiesInlineBackingStorageTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationNfsPropertiesInlineBackingStorageTypeTypePropEnum = append(applicationNfsPropertiesInlineBackingStorageTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_nfs_properties_inline_backing_storage
	// ApplicationNfsPropertiesInlineBackingStorage
	// type
	// Type
	// volume
	// END DEBUGGING
	// ApplicationNfsPropertiesInlineBackingStorageTypeVolume captures enum value "volume"
	ApplicationNfsPropertiesInlineBackingStorageTypeVolume string = "volume"
)

// prop value enum
func (m *ApplicationNfsPropertiesInlineBackingStorage) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationNfsPropertiesInlineBackingStorageTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationNfsPropertiesInlineBackingStorage) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("backing_storage"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application nfs properties inline backing storage based on the context it is used
func (m *ApplicationNfsPropertiesInlineBackingStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNfsPropertiesInlineBackingStorage) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNfsPropertiesInlineBackingStorage) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlineBackingStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlineBackingStorage) UnmarshalBinary(b []byte) error {
	var res ApplicationNfsPropertiesInlineBackingStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNfsPropertiesInlineExportPolicy application nfs properties inline export policy
//
// swagger:model application_nfs_properties_inline_export_policy
type ApplicationNfsPropertiesInlineExportPolicy struct {

	// Export policy name
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this application nfs properties inline export policy
func (m *ApplicationNfsPropertiesInlineExportPolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application nfs properties inline export policy based on the context it is used
func (m *ApplicationNfsPropertiesInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNfsPropertiesInlineExportPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "export_policy"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res ApplicationNfsPropertiesInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNfsPropertiesInlinePermissionsInlineArrayItem application nfs properties inline permissions inline array item
//
// swagger:model application_nfs_properties_inline_permissions_inline_array_item
type ApplicationNfsPropertiesInlinePermissionsInlineArrayItem struct {

	// Access granted to the host
	// Read Only: true
	Access *string `json:"access,omitempty"`

	// Host granted access
	// Read Only: true
	Host *string `json:"host,omitempty"`
}

// Validate validates this application nfs properties inline permissions inline array item
func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application nfs properties inline permissions inline array item based on the context it is used
func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access", "body", m.Access); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host", "body", m.Host); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNfsPropertiesInlinePermissionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ApplicationNfsPropertiesInlinePermissionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
