// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationNvmeAccess Application NVME access
//
// swagger:model application_nvme_access
type ApplicationNvmeAccess struct {

	// backing storage
	BackingStorage *ApplicationNvmeAccessInlineBackingStorage `json:"backing_storage,omitempty"`

	// Clone
	// Read Only: true
	IsClone *bool `json:"is_clone,omitempty"`

	// subsystem map
	SubsystemMap *ApplicationNvmeAccessInlineSubsystemMap `json:"subsystem_map,omitempty"`
}

// Validate validates this application nvme access
func (m *ApplicationNvmeAccess) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBackingStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccess) validateBackingStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingStorage) { // not required
		return nil
	}

	if m.BackingStorage != nil {
		if err := m.BackingStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNvmeAccess) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access based on the context it is used
func (m *ApplicationNvmeAccess) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBackingStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccess) contextValidateBackingStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BackingStorage != nil {
		if err := m.BackingStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("backing_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNvmeAccess) contextValidateIsClone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_clone", "body", m.IsClone); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNvmeAccess) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccess) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccess) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccess
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessInlineBackingStorage application nvme access inline backing storage
//
// swagger:model application_nvme_access_inline_backing_storage
type ApplicationNvmeAccessInlineBackingStorage struct {

	// Backing storage type
	// Read Only: true
	// Enum: ["namespace"]
	Type *string `json:"type,omitempty"`

	// Backing storage UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application nvme access inline backing storage
func (m *ApplicationNvmeAccessInlineBackingStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationNvmeAccessInlineBackingStorageTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["namespace"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationNvmeAccessInlineBackingStorageTypeTypePropEnum = append(applicationNvmeAccessInlineBackingStorageTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_nvme_access_inline_backing_storage
	// ApplicationNvmeAccessInlineBackingStorage
	// type
	// Type
	// namespace
	// END DEBUGGING
	// ApplicationNvmeAccessInlineBackingStorageTypeNamespace captures enum value "namespace"
	ApplicationNvmeAccessInlineBackingStorageTypeNamespace string = "namespace"
)

// prop value enum
func (m *ApplicationNvmeAccessInlineBackingStorage) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationNvmeAccessInlineBackingStorageTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineBackingStorage) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("backing_storage"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application nvme access inline backing storage based on the context it is used
func (m *ApplicationNvmeAccessInlineBackingStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineBackingStorage) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineBackingStorage) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "backing_storage"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineBackingStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineBackingStorage) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessInlineBackingStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessInlineSubsystemMap Subsystem map object
//
// swagger:model application_nvme_access_inline_subsystem_map
type ApplicationNvmeAccessInlineSubsystemMap struct {

	// Subsystem ANA group ID
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// Subsystem namespace ID
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// subsystem
	Subsystem *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this application nvme access inline subsystem map
func (m *ApplicationNvmeAccessInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access inline subsystem map based on the context it is used
func (m *ApplicationNvmeAccessInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem application nvme access inline subsystem map inline subsystem
//
// swagger:model application_nvme_access_inline_subsystem_map_inline_subsystem
type ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem struct {

	// links
	Links *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// hosts
	// Read Only: true
	Hosts []*ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0 `json:"hosts,omitempty"`

	// Subsystem name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Subsystem UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application nvme access inline subsystem map inline subsystem
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) validateHosts(formats strfmt.Registry) error {
	if swag.IsZero(m.Hosts) { // not required
		return nil
	}

	for i := 0; i < len(m.Hosts); i++ {
		if swag.IsZero(m.Hosts[i]) { // not required
			continue
		}

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this application nvme access inline subsystem map inline subsystem based on the context it is used
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) contextValidateHosts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"subsystem"+"."+"hosts", "body", []*ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0(m.Hosts)); err != nil {
		return err
	}

	for i := 0; i < len(m.Hosts); i++ {

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"subsystem"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"subsystem"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessInlineSubsystemMapInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0 application nvme access subsystem map subsystem hosts items0
//
// swagger:model ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0
type ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0 struct {

	// links
	Links *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links `json:"_links,omitempty"`

	// Host
	// Read Only: true
	Nqn *string `json:"nqn,omitempty"`
}

// Validate validates this application nvme access subsystem map subsystem hosts items0
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access subsystem map subsystem hosts items0 based on the context it is used
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNqn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) contextValidateNqn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nqn", "body", m.Nqn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links application nvme access subsystem map subsystem hosts items0 links
//
// swagger:model ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links
type ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links struct {

	// self
	Self *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf `json:"self,omitempty"`
}

// Validate validates this application nvme access subsystem map subsystem hosts items0 links
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access subsystem map subsystem hosts items0 links based on the context it is used
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf application nvme access subsystem map subsystem hosts items0 links self
//
// swagger:model ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf
type ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application nvme access subsystem map subsystem hosts items0 links self
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access subsystem map subsystem hosts items0 links self based on the context it is used
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessSubsystemMapSubsystemHostsItems0LinksSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks application nvme access inline subsystem map inline subsystem inline links
//
// swagger:model application_nvme_access_inline_subsystem_map_inline_subsystem_inline__links
type ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application nvme access inline subsystem map inline subsystem inline links
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application nvme access inline subsystem map inline subsystem inline links based on the context it is used
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationNvmeAccessInlineSubsystemMapInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
