// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationSanAccessIscsiEndpoint An iSCSI access endpoint for the LUN.
//
// swagger:model application_san_access_iscsi_endpoint
type ApplicationSanAccessIscsiEndpoint struct {

	// links
	Links *ApplicationSanAccessIscsiEndpointInlineLinks `json:"_links,omitempty"`

	// interface
	Interface *ApplicationSanAccessIscsiEndpointInlineInterface `json:"interface,omitempty"`

	// The TCP port number of the iSCSI access endpoint.
	// Example: 3260
	// Read Only: true
	// Maximum: 65536
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this application san access iscsi endpoint
func (m *ApplicationSanAccessIscsiEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65536, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application san access iscsi endpoint based on the context it is used
func (m *ApplicationSanAccessIscsiEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpoint) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "port", "body", m.Port); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpoint) UnmarshalBinary(b []byte) error {
	var res ApplicationSanAccessIscsiEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSanAccessIscsiEndpointInlineInterface A network interface. Either UUID or name may be supplied on input.
//
// swagger:model application_san_access_iscsi_endpoint_inline_interface
type ApplicationSanAccessIscsiEndpointInlineInterface struct {

	// links
	Links *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// ip
	IP *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application san access iscsi endpoint inline interface
func (m *ApplicationSanAccessIscsiEndpointInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application san access iscsi endpoint inline interface based on the context it is used
func (m *ApplicationSanAccessIscsiEndpointInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterface) UnmarshalBinary(b []byte) error {
	var res ApplicationSanAccessIscsiEndpointInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP IP information
//
// swagger:model application_san_access_iscsi_endpoint_inline_interface_inline_ip
type ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this application san access iscsi endpoint inline interface inline ip
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application san access iscsi endpoint inline interface inline ip based on the context it is used
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res ApplicationSanAccessIscsiEndpointInlineInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks application san access iscsi endpoint inline interface inline links
//
// swagger:model application_san_access_iscsi_endpoint_inline_interface_inline__links
type ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application san access iscsi endpoint inline interface inline links
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application san access iscsi endpoint inline interface inline links based on the context it is used
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationSanAccessIscsiEndpointInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSanAccessIscsiEndpointInlineLinks application san access iscsi endpoint inline links
//
// swagger:model application_san_access_iscsi_endpoint_inline__links
type ApplicationSanAccessIscsiEndpointInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application san access iscsi endpoint inline links
func (m *ApplicationSanAccessIscsiEndpointInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application san access iscsi endpoint inline links based on the context it is used
func (m *ApplicationSanAccessIscsiEndpointInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSanAccessIscsiEndpointInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSanAccessIscsiEndpointInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationSanAccessIscsiEndpointInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
