// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ApplicationSnapshot application snapshot
//
// swagger:model application_snapshot
type ApplicationSnapshot struct {

	// links
	Links *ApplicationSnapshotInlineLinks `json:"_links,omitempty"`

	// application
	Application *ApplicationSnapshotInlineApplication `json:"application,omitempty"`

	// application snapshot inline components
	// Read Only: true
	ApplicationSnapshotInlineComponents []*ApplicationSnapshotInlineComponentsInlineArrayItem `json:"components,omitempty"`

	// Comment. Valid in POST.
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Consistency type. This is for categorization purposes only. A snapshot should not be set to 'application consistent' unless the host application is quiesced for the snapshot. Valid in POST.
	// Enum: ["crash","application"]
	ConsistencyType *string `json:"consistency_type,omitempty"`

	// Creation time
	// Read Only: true
	CreateTime *string `json:"create_time,omitempty"`

	// A partial snapshot means that not all volumes in an application component were included in the snapshot.
	// Read Only: true
	IsPartial *bool `json:"is_partial,omitempty"`

	// The snapshot name. Valid in POST.
	Name *string `json:"name,omitempty"`

	// svm
	Svm *ApplicationSnapshotInlineSvm `json:"svm,omitempty"`

	// The snapshot UUID. Valid in URL.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application snapshot
func (m *ApplicationSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationSnapshotInlineComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshot) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshot) validateApplicationSnapshotInlineComponents(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationSnapshotInlineComponents) { // not required
		return nil
	}

	for i := 0; i < len(m.ApplicationSnapshotInlineComponents); i++ {
		if swag.IsZero(m.ApplicationSnapshotInlineComponents[i]) { // not required
			continue
		}

		if m.ApplicationSnapshotInlineComponents[i] != nil {
			if err := m.ApplicationSnapshotInlineComponents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationSnapshot) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 255); err != nil {
		return err
	}

	return nil
}

var applicationSnapshotTypeConsistencyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["crash","application"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationSnapshotTypeConsistencyTypePropEnum = append(applicationSnapshotTypeConsistencyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_snapshot
	// ApplicationSnapshot
	// consistency_type
	// ConsistencyType
	// crash
	// END DEBUGGING
	// ApplicationSnapshotConsistencyTypeCrash captures enum value "crash"
	ApplicationSnapshotConsistencyTypeCrash string = "crash"

	// BEGIN DEBUGGING
	// application_snapshot
	// ApplicationSnapshot
	// consistency_type
	// ConsistencyType
	// application
	// END DEBUGGING
	// ApplicationSnapshotConsistencyTypeApplication captures enum value "application"
	ApplicationSnapshotConsistencyTypeApplication string = "application"
)

// prop value enum
func (m *ApplicationSnapshot) validateConsistencyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationSnapshotTypeConsistencyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ApplicationSnapshot) validateConsistencyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateConsistencyTypeEnum("consistency_type", "body", *m.ConsistencyType); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshot) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot based on the context it is used
func (m *ApplicationSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplicationSnapshotInlineComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsPartial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateApplicationSnapshotInlineComponents(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "components", "body", []*ApplicationSnapshotInlineComponentsInlineArrayItem(m.ApplicationSnapshotInlineComponents)); err != nil {
		return err
	}

	for i := 0; i < len(m.ApplicationSnapshotInlineComponents); i++ {

		if m.ApplicationSnapshotInlineComponents[i] != nil {
			if err := m.ApplicationSnapshotInlineComponents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateIsPartial(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_partial", "body", m.IsPartial); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshot) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshot) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineApplication application snapshot inline application
//
// swagger:model application_snapshot_inline_application
type ApplicationSnapshotInlineApplication struct {

	// links
	Links *ApplicationSnapshotInlineApplicationInlineLinks `json:"_links,omitempty"`

	// Application name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The application UUID. Valid in URL.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application snapshot inline application
func (m *ApplicationSnapshotInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineApplication) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot inline application based on the context it is used
func (m *ApplicationSnapshotInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineApplication) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshotInlineApplication) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshotInlineApplication) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "application"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineApplication) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineApplicationInlineLinks application snapshot inline application inline links
//
// swagger:model application_snapshot_inline_application_inline__links
type ApplicationSnapshotInlineApplicationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application snapshot inline application inline links
func (m *ApplicationSnapshotInlineApplicationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineApplicationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot inline application inline links based on the context it is used
func (m *ApplicationSnapshotInlineApplicationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineApplicationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineApplicationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineApplicationInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineApplicationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineComponentsInlineArrayItem application snapshot inline components inline array item
//
// swagger:model application_snapshot_inline_components_inline_array_item
type ApplicationSnapshotInlineComponentsInlineArrayItem struct {

	// links
	Links *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Component name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Component UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application snapshot inline components inline array item
func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot inline components inline array item based on the context it is used
func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineComponentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineComponentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks application snapshot inline components inline array item inline links
//
// swagger:model application_snapshot_inline_components_inline_array_item_inline__links
type ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application snapshot inline components inline array item inline links
func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot inline components inline array item inline links based on the context it is used
func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineComponentsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineLinks application snapshot inline links
//
// swagger:model application_snapshot_inline__links
type ApplicationSnapshotInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this application snapshot inline links
func (m *ApplicationSnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application snapshot inline links based on the context it is used
func (m *ApplicationSnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ApplicationSnapshotInlineSvm application snapshot inline svm
//
// swagger:model application_snapshot_inline_svm
type ApplicationSnapshotInlineSvm struct {

	// SVM name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// SVM UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application snapshot inline svm
func (m *ApplicationSnapshotInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application snapshot inline svm based on the context it is used
func (m *ApplicationSnapshotInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ApplicationSnapshotInlineSvm) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ApplicationSnapshotInlineSvm) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ApplicationSnapshotInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ApplicationSnapshotInlineSvm) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
