// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AuditSchedule Rotates the audit logs based on a schedule by using the time-based rotation parameters in any combination. The rotation schedule is calculated by using all the time-related values.
//
// swagger:model audit_schedule
type AuditSchedule struct {

	// Specifies the day of the month schedule to rotate audit log. Leave empty for all.
	AuditScheduleInlineDays []*int64 `json:"days,omitempty"`

	// Specifies the hourly schedule to rotate audit log. Leave empty for all.
	AuditScheduleInlineHours []*int64 `json:"hours,omitempty"`

	// Specifies the minutes schedule to rotate the audit log.
	AuditScheduleInlineMinutes []*int64 `json:"minutes,omitempty"`

	// Specifies the months schedule to rotate audit log. Leave empty for all.
	AuditScheduleInlineMonths []*int64 `json:"months,omitempty"`

	// Specifies the weekdays schedule to rotate audit log. Leave empty for all.
	AuditScheduleInlineWeekdays []*int64 `json:"weekdays,omitempty"`
}

// Validate validates this audit schedule
func (m *AuditSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuditScheduleInlineDays(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuditScheduleInlineHours(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuditScheduleInlineMinutes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuditScheduleInlineMonths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuditScheduleInlineWeekdays(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AuditSchedule) validateAuditScheduleInlineDays(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditScheduleInlineDays) { // not required
		return nil
	}

	for i := 0; i < len(m.AuditScheduleInlineDays); i++ {
		if swag.IsZero(m.AuditScheduleInlineDays[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("days"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineDays[i], 1, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("days"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineDays[i], 31, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *AuditSchedule) validateAuditScheduleInlineHours(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditScheduleInlineHours) { // not required
		return nil
	}

	for i := 0; i < len(m.AuditScheduleInlineHours); i++ {
		if swag.IsZero(m.AuditScheduleInlineHours[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("hours"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineHours[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("hours"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineHours[i], 23, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *AuditSchedule) validateAuditScheduleInlineMinutes(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditScheduleInlineMinutes) { // not required
		return nil
	}

	for i := 0; i < len(m.AuditScheduleInlineMinutes); i++ {
		if swag.IsZero(m.AuditScheduleInlineMinutes[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("minutes"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineMinutes[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("minutes"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineMinutes[i], 59, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *AuditSchedule) validateAuditScheduleInlineMonths(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditScheduleInlineMonths) { // not required
		return nil
	}

	for i := 0; i < len(m.AuditScheduleInlineMonths); i++ {
		if swag.IsZero(m.AuditScheduleInlineMonths[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("months"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineMonths[i], 1, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("months"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineMonths[i], 12, false); err != nil {
			return err
		}

	}

	return nil
}

func (m *AuditSchedule) validateAuditScheduleInlineWeekdays(formats strfmt.Registry) error {
	if swag.IsZero(m.AuditScheduleInlineWeekdays) { // not required
		return nil
	}

	for i := 0; i < len(m.AuditScheduleInlineWeekdays); i++ {
		if swag.IsZero(m.AuditScheduleInlineWeekdays[i]) { // not required
			continue
		}

		if err := validate.MinimumInt("weekdays"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineWeekdays[i], 0, false); err != nil {
			return err
		}

		if err := validate.MaximumInt("weekdays"+"."+strconv.Itoa(i), "body", *m.AuditScheduleInlineWeekdays[i], 6, false); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this audit schedule based on context it is used
func (m *AuditSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AuditSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AuditSchedule) UnmarshalBinary(b []byte) error {
	var res AuditSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
