// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AutoUpdateStatus auto update status
//
// swagger:model auto_update_status
type AutoUpdateStatus struct {

	// links
	Links *AutoUpdateStatusInlineLinks `json:"_links,omitempty"`

	// Action to be applied to the automatic update.
	// Example: schedule_now
	// Enum: ["cancel_schedule","dismiss","schedule","schedule_now","abort","undismiss"]
	Action *string `json:"action,omitempty"`

	// Category of the update
	// Example: Firmware
	// Read Only: true
	ContentCategory *string `json:"content_category,omitempty"`

	// Image or package type.
	// Example: disk_fw
	// Read Only: true
	ContentType *string `json:"content_type,omitempty"`

	// The date and time at which the update request was received.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	CreationTime *strfmt.DateTime `json:"creation_time,omitempty"`

	// Description of the update.
	// Example: disk_fw version 3.0
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The date and time at which the update request processing ended.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// The date and time at which the update request will expire.
	// Example: 2021-06-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// The date and time at which the state of the update changed last.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	LastStateChangeTime *strfmt.DateTime `json:"last_state_change_time,omitempty"`

	// Unique identifier provided by the back-end.
	// Example: 572361f3-e769-439d-9c04-2ba48a08ff47
	// Read Only: true
	PackageID *string `json:"package_id,omitempty"`

	// Percentage of update completed
	// Example: 85
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// The time remaining for the update processing to complete in an ISO-8601 duration formatted string.
	// Example: PT1H45M13S
	// Read Only: true
	RemainingTime *string `json:"remaining_time,omitempty"`

	// Date and time when an automatic update action is scheduled.
	// This field is required when the action field is set to "schedule".
	//
	// Example: 2020-12-20 21:00:00+00:00
	// Format: date-time
	ScheduleTime *strfmt.DateTime `json:"schedule_time,omitempty"`

	// The date and time at which the update request is currently scheduled for.
	// Example: 2020-12-05 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	ScheduledTime *strfmt.DateTime `json:"scheduled_time,omitempty"`

	// The date and time at which the update request processing started.
	// Example: 2020-12-01 09:12:23+00:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// Current state of the update.
	// Example: pending_confirmation
	// Read Only: true
	// Enum: ["pending_confirmation","downloading","applying","applied","dismissed","scheduled","failed","aborted"]
	State *string `json:"state,omitempty"`

	// status
	Status *AutoUpdateStatusInlineStatus `json:"status,omitempty"`

	// Unique identifier for this update.
	// Example: 440ae2e4-fd8f-4225-9bee-94e2da3f9d8d
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this auto update status
func (m *AutoUpdateStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreationTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastStateChangeTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduleTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduledTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatus) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var autoUpdateStatusTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cancel_schedule","dismiss","schedule","schedule_now","abort","undismiss"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autoUpdateStatusTypeActionPropEnum = append(autoUpdateStatusTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// cancel_schedule
	// END DEBUGGING
	// AutoUpdateStatusActionCancelSchedule captures enum value "cancel_schedule"
	AutoUpdateStatusActionCancelSchedule string = "cancel_schedule"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// dismiss
	// END DEBUGGING
	// AutoUpdateStatusActionDismiss captures enum value "dismiss"
	AutoUpdateStatusActionDismiss string = "dismiss"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// schedule
	// END DEBUGGING
	// AutoUpdateStatusActionSchedule captures enum value "schedule"
	AutoUpdateStatusActionSchedule string = "schedule"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// schedule_now
	// END DEBUGGING
	// AutoUpdateStatusActionScheduleNow captures enum value "schedule_now"
	AutoUpdateStatusActionScheduleNow string = "schedule_now"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// abort
	// END DEBUGGING
	// AutoUpdateStatusActionAbort captures enum value "abort"
	AutoUpdateStatusActionAbort string = "abort"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// action
	// Action
	// undismiss
	// END DEBUGGING
	// AutoUpdateStatusActionUndismiss captures enum value "undismiss"
	AutoUpdateStatusActionUndismiss string = "undismiss"
)

// prop value enum
func (m *AutoUpdateStatus) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autoUpdateStatusTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AutoUpdateStatus) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateCreationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("creation_time", "body", "date-time", m.CreationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("end_time", "body", "date-time", m.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateLastStateChangeTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastStateChangeTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_state_change_time", "body", "date-time", m.LastStateChangeTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateScheduleTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleTime) { // not required
		return nil
	}

	if err := validate.FormatOf("schedule_time", "body", "date-time", m.ScheduleTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateScheduledTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduledTime) { // not required
		return nil
	}

	if err := validate.FormatOf("scheduled_time", "body", "date-time", m.ScheduledTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("start_time", "body", "date-time", m.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var autoUpdateStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pending_confirmation","downloading","applying","applied","dismissed","scheduled","failed","aborted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autoUpdateStatusTypeStatePropEnum = append(autoUpdateStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// pending_confirmation
	// END DEBUGGING
	// AutoUpdateStatusStatePendingConfirmation captures enum value "pending_confirmation"
	AutoUpdateStatusStatePendingConfirmation string = "pending_confirmation"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// downloading
	// END DEBUGGING
	// AutoUpdateStatusStateDownloading captures enum value "downloading"
	AutoUpdateStatusStateDownloading string = "downloading"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// applying
	// END DEBUGGING
	// AutoUpdateStatusStateApplying captures enum value "applying"
	AutoUpdateStatusStateApplying string = "applying"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// applied
	// END DEBUGGING
	// AutoUpdateStatusStateApplied captures enum value "applied"
	AutoUpdateStatusStateApplied string = "applied"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// dismissed
	// END DEBUGGING
	// AutoUpdateStatusStateDismissed captures enum value "dismissed"
	AutoUpdateStatusStateDismissed string = "dismissed"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// scheduled
	// END DEBUGGING
	// AutoUpdateStatusStateScheduled captures enum value "scheduled"
	AutoUpdateStatusStateScheduled string = "scheduled"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// failed
	// END DEBUGGING
	// AutoUpdateStatusStateFailed captures enum value "failed"
	AutoUpdateStatusStateFailed string = "failed"

	// BEGIN DEBUGGING
	// auto_update_status
	// AutoUpdateStatus
	// state
	// State
	// aborted
	// END DEBUGGING
	// AutoUpdateStatusStateAborted captures enum value "aborted"
	AutoUpdateStatusStateAborted string = "aborted"
)

// prop value enum
func (m *AutoUpdateStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autoUpdateStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AutoUpdateStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status based on the context it is used
func (m *AutoUpdateStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContentCategory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContentType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastStateChangeTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePackageID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemainingTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScheduledTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatus) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateContentCategory(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "content_category", "body", m.ContentCategory); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateContentType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "content_type", "body", m.ContentType); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateCreationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "creation_time", "body", m.CreationTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "end_time", "body", m.EndTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateLastStateChangeTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_state_change_time", "body", m.LastStateChangeTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidatePackageID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "package_id", "body", m.PackageID); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "percent_complete", "body", m.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateRemainingTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remaining_time", "body", m.RemainingTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateScheduledTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scheduled_time", "body", m.ScheduledTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "start_time", "body", m.StartTime); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *AutoUpdateStatus) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AutoUpdateStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AutoUpdateStatus) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AutoUpdateStatusInlineLinks auto update status inline links
//
// swagger:model auto_update_status_inline__links
type AutoUpdateStatusInlineLinks struct {

	// self
	Self *AutoUpdateStatusInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this auto update status inline links
func (m *AutoUpdateStatusInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status inline links based on the context it is used
func (m *AutoUpdateStatusInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AutoUpdateStatusInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AutoUpdateStatusInlineLinks) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AutoUpdateStatusInlineLinksInlineSelf auto update status inline links inline self
//
// swagger:model auto_update_status_inline__links_inline_self
type AutoUpdateStatusInlineLinksInlineSelf struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this auto update status inline links inline self
func (m *AutoUpdateStatusInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineLinksInlineSelf) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this auto update status inline links inline self based on the context it is used
func (m *AutoUpdateStatusInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineLinksInlineSelf) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AutoUpdateStatusInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AutoUpdateStatusInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AutoUpdateStatusInlineStatus Status of the update.
// ONTAP Message Codes
// | Code       | Description |
// | ---------- | ----------- |
// | 8650878 | Get-url request to AutoSupport OnDemand Server failed. |
// | 131072105 | Package installation successful. |
// | 131072106 | Package installation failed. |
// | 131072107 | Package installation is in progress. |
// | 131072108 | An internal error occurred. |
// | 131072109 | No errors found. |
// | 131072110 | Failed to extract package. |
// | 131072111 | Failed to create entry in status table. |
// | 131072209 | Failed to download package. |
// | 131072210 | Failed to obtain download links. Will be retried. |
// | 131072211 | Installation cannot start because the following nodes are not up. Will be retried. |
// | 131072212 | Automatic update cannot start. Will be retried. |
// | 131072213 | Installation complete. |
// | 131072214 | Installation in progress. |
// | 131072215 | Scheduled to start. |
// | 131072301 | Unable to create directory. |
// | 131072302 | Update not required. It is already on the target firmware version. |
// | 131072303 | Unable to move installable to installation location. |
// | 131072304 | Successfully updated. All nodes already updated and skipped. |
// | 131072306 | Firmware distribution starting. |
// | 131072307 | Firmware distribution restarting. |
// | 131072308 | Firmware distribution failed. |
// | 131072309 | Firmware installation successful on node. |
// | 131072310 | Firmware installable is corrupt on node. |
// | 131072311 | Could not apply firmware update on nodes. |
// | 131072312 | Firmware update operation failed. |
// | 131072313 | Install failed to initiate on node. |
// | 131072314 | Install initiated on node. |
// | 131072315 | Install failed on node. |
// | 131072316 | Update in progress on node. |
// | 131072317 | Unexpected state occurred during firmware installation on node. |
// | 131072318 | Successfully updated SP/BMC firmware. |
// | 131072319 | Backup SP image is running. Firmware installation failed prematurely on node. |
// | 131072320 | SP rebooted with an unexpected firmware version on node. |
// | 131072321 | Waiting for shelf firmware to update. |
// | 131072322 | Update complete. |
// | 131072323 | Shelf update timed out. |
// | 131072324 | Successfully updated shelves on nodes. |
// | 131072325 | Waiting for disk firmware to update. |
// | 131072326 | Disk update completed. |
// | 131072327 | Disk update timed out. |
// | 131072328 | Successfully updated disks on nodes. |
// | 131072329 | Waiting for DQP firmware to update. |
// | 131072330 | Successfully updated DQP on nodes. |
// | 131072331 | DQP update timed out. |
// | 131072332 | Failed to copy firmware. |
//
// swagger:model auto_update_status_inline_status
type AutoUpdateStatusInlineStatus struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this auto update status inline status
func (m *AutoUpdateStatusInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineStatus) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("status" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this auto update status inline status based on the context it is used
func (m *AutoUpdateStatusInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AutoUpdateStatusInlineStatus) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("status" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AutoUpdateStatusInlineStatus) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *AutoUpdateStatusInlineStatus) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AutoUpdateStatusInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AutoUpdateStatusInlineStatus) UnmarshalBinary(b []byte) error {
	var res AutoUpdateStatusInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
