// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Autosupport autosupport
//
// swagger:model autosupport
type Autosupport struct {

	// A list of connectivity issues to the HTTPS/SMTP/AOD AutoSupport destinations on the nodes in the cluster along with the corrective actions.
	// Read Only: true
	AutosupportInlineIssues []*AutosupportIssues `json:"issues,omitempty"`

	// The names of the mail servers used to deliver AutoSupport messages via SMTP.
	// Example: ["mailhost1.example.com","mailhost2.example.com"]
	// Max Items: 5
	AutosupportInlineMailHosts []*strfmt.URI `json:"mail_hosts,omitempty"`

	// The list of partner addresses.
	// Example: ["user1@partner.com","user2@partner.com"]
	// Max Items: 5
	AutosupportInlinePartnerAddresses []*strfmt.Email `json:"partner_addresses,omitempty"`

	// The e-mail addresses to which the AutoSupport messages are sent.
	// Example: ["user1@example.com","user2@example.com"]
	// Max Items: 5
	AutosupportInlineTo []*strfmt.Email `json:"to,omitempty"`

	// Specifies whether to send the AutoSupport messages to vendor support.
	// Example: true
	ContactSupport *bool `json:"contact_support,omitempty"`

	// Specifies whether the AutoSupport daemon is enabled.  When this setting is disabled, delivery of all AutoSupport messages is turned off.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// The e-mail address from which the AutoSupport messages are sent. To generate node-specific 'from' addresses, enable '-node-specific-from' parameter via ONTAP CLI.
	// Example: postmaster@example.com
	// Format: email
	From *strfmt.Email `json:"from,omitempty"`

	// Specifies whether the system information is collected in compliant form, to remove private data or in complete form, to enhance diagnostics.
	// Example: true
	IsMinimal *bool `json:"is_minimal,omitempty"`

	// Specifies whether the AutoSupport OnDemand feature is enabled. When AutoSupport OnDemand is enabled, support personnel can remotely trigger new AutoSupport messages, resend existing AutoSupport messages, and decline the delivery of unwanted AutoSupport messages. When this option is disabled, the cluster does not respond to any AutoSupport OnDemand requests from support personnel.
	//
	// Example: true
	OndemandEnabled *bool `json:"ondemand_enabled,omitempty"`

	// Proxy server for AutoSupport message delivery via HTTPS. Optionally specify a username/password for authentication with the proxy server.
	// Example: proxy.company.com
	// Format: uri
	ProxyURL *strfmt.URI `json:"proxy_url,omitempty"`

	// The encryption protocol used to deliver AutoSupport messages via SMTP to the configured mail_hosts.
	//
	// Example: none
	// Enum: ["none","start_tls"]
	SMTPEncryption *string `json:"smtp_encryption,omitempty"`

	// The name of the transport protocol used to deliver AutoSupport messages. Note: 'http' transport is no longer supported by AutoSupport servers.
	//
	// Example: smtp
	// Enum: ["smtp","https"]
	Transport *string `json:"transport,omitempty"`
}

// Validate validates this autosupport
func (m *Autosupport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutosupportInlineIssues(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutosupportInlineMailHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutosupportInlinePartnerAddresses(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutosupportInlineTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSMTPEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Autosupport) validateAutosupportInlineIssues(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosupportInlineIssues) { // not required
		return nil
	}

	for i := 0; i < len(m.AutosupportInlineIssues); i++ {
		if swag.IsZero(m.AutosupportInlineIssues[i]) { // not required
			continue
		}

		if m.AutosupportInlineIssues[i] != nil {
			if err := m.AutosupportInlineIssues[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("issues" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Autosupport) validateAutosupportInlineMailHosts(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosupportInlineMailHosts) { // not required
		return nil
	}

	iAutosupportInlineMailHostsSize := int64(len(m.AutosupportInlineMailHosts))

	if err := validate.MaxItems("mail_hosts", "body", iAutosupportInlineMailHostsSize, 5); err != nil {
		return err
	}

	for i := 0; i < len(m.AutosupportInlineMailHosts); i++ {
		if swag.IsZero(m.AutosupportInlineMailHosts[i]) { // not required
			continue
		}

		if err := validate.FormatOf("mail_hosts"+"."+strconv.Itoa(i), "body", "uri", m.AutosupportInlineMailHosts[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (m *Autosupport) validateAutosupportInlinePartnerAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosupportInlinePartnerAddresses) { // not required
		return nil
	}

	iAutosupportInlinePartnerAddressesSize := int64(len(m.AutosupportInlinePartnerAddresses))

	if err := validate.MaxItems("partner_addresses", "body", iAutosupportInlinePartnerAddressesSize, 5); err != nil {
		return err
	}

	for i := 0; i < len(m.AutosupportInlinePartnerAddresses); i++ {
		if swag.IsZero(m.AutosupportInlinePartnerAddresses[i]) { // not required
			continue
		}

		if err := validate.FormatOf("partner_addresses"+"."+strconv.Itoa(i), "body", "email", m.AutosupportInlinePartnerAddresses[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (m *Autosupport) validateAutosupportInlineTo(formats strfmt.Registry) error {
	if swag.IsZero(m.AutosupportInlineTo) { // not required
		return nil
	}

	iAutosupportInlineToSize := int64(len(m.AutosupportInlineTo))

	if err := validate.MaxItems("to", "body", iAutosupportInlineToSize, 5); err != nil {
		return err
	}

	for i := 0; i < len(m.AutosupportInlineTo); i++ {
		if swag.IsZero(m.AutosupportInlineTo[i]) { // not required
			continue
		}

		if err := validate.FormatOf("to"+"."+strconv.Itoa(i), "body", "email", m.AutosupportInlineTo[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (m *Autosupport) validateFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.From) { // not required
		return nil
	}

	if err := validate.FormatOf("from", "body", "email", m.From.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Autosupport) validateProxyURL(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyURL) { // not required
		return nil
	}

	if err := validate.FormatOf("proxy_url", "body", "uri", m.ProxyURL.String(), formats); err != nil {
		return err
	}

	return nil
}

var autosupportTypeSMTPEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","start_tls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autosupportTypeSMTPEncryptionPropEnum = append(autosupportTypeSMTPEncryptionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// autosupport
	// Autosupport
	// smtp_encryption
	// SMTPEncryption
	// none
	// END DEBUGGING
	// AutosupportSMTPEncryptionNone captures enum value "none"
	AutosupportSMTPEncryptionNone string = "none"

	// BEGIN DEBUGGING
	// autosupport
	// Autosupport
	// smtp_encryption
	// SMTPEncryption
	// start_tls
	// END DEBUGGING
	// AutosupportSMTPEncryptionStartTLS captures enum value "start_tls"
	AutosupportSMTPEncryptionStartTLS string = "start_tls"
)

// prop value enum
func (m *Autosupport) validateSMTPEncryptionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autosupportTypeSMTPEncryptionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Autosupport) validateSMTPEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.SMTPEncryption) { // not required
		return nil
	}

	// value enum
	if err := m.validateSMTPEncryptionEnum("smtp_encryption", "body", *m.SMTPEncryption); err != nil {
		return err
	}

	return nil
}

var autosupportTypeTransportPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["smtp","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		autosupportTypeTransportPropEnum = append(autosupportTypeTransportPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// autosupport
	// Autosupport
	// transport
	// Transport
	// smtp
	// END DEBUGGING
	// AutosupportTransportSMTP captures enum value "smtp"
	AutosupportTransportSMTP string = "smtp"

	// BEGIN DEBUGGING
	// autosupport
	// Autosupport
	// transport
	// Transport
	// https
	// END DEBUGGING
	// AutosupportTransportHTTPS captures enum value "https"
	AutosupportTransportHTTPS string = "https"
)

// prop value enum
func (m *Autosupport) validateTransportEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, autosupportTypeTransportPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Autosupport) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(m.Transport) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransportEnum("transport", "body", *m.Transport); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this autosupport based on the context it is used
func (m *Autosupport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAutosupportInlineIssues(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Autosupport) contextValidateAutosupportInlineIssues(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "issues", "body", []*AutosupportIssues(m.AutosupportInlineIssues)); err != nil {
		return err
	}

	for i := 0; i < len(m.AutosupportInlineIssues); i++ {

		if m.AutosupportInlineIssues[i] != nil {
			if err := m.AutosupportInlineIssues[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("issues" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Autosupport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Autosupport) UnmarshalBinary(b []byte) error {
	var res Autosupport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
