// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AwsKms aws kms
//
// swagger:model aws_kms
type AwsKms struct {

	// links
	Links *AwsKmsInlineLinks `json:"_links,omitempty"`

	// AWS Access Key ID of the user that has appropriate access to AWS KMS.
	// Example: AKIATCFKZXU6GKUDQUWN
	AccessKeyID *string `json:"access_key_id,omitempty"`

	// amazon reachability
	AmazonReachability *AwsKmsInlineAmazonReachability `json:"amazon_reachability,omitempty"`

	// aws kms inline ekmip reachability
	// Read Only: true
	AwsKmsInlineEkmipReachability []*AwsKmsInlineEkmipReachabilityInlineArrayItem `json:"ekmip_reachability,omitempty"`

	// AWS KMS default domain.
	// Example: domainName
	DefaultDomain *string `json:"default_domain,omitempty"`

	// Additional layer of authentication and logging.
	// Example: aws:fsx:fs-id=fs-0785c8beceb895999
	EncryptionContext *string `json:"encryption_context,omitempty"`

	// AWS KMS host's hostname.
	// Example: aws-host.host.com
	Host *string `json:"host,omitempty"`

	// AWS Key ID.
	// Example: kmip-aws
	KeyID *string `json:"key_id,omitempty"`

	// Polling period in minutes.
	// Example: 55
	PollingPeriod *int64 `json:"polling_period,omitempty"`

	// AWS KMS port.
	// Example: 443
	Port *int64 `json:"port,omitempty"`

	// Proxy host.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: awskze-Jwjje2-WJJPer
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Proxy type.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// AWS region of the AWS KMS.
	// Example: us-east-1
	Region *string `json:"region,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// AWS Secret Access Key for the provided access key ID.
	// Example: tyb1kA/bSr5654LncZNwNcvAOR7hu1vPo0nPrtoG
	// Format: password
	SecretAccessKey *strfmt.Password `json:"secret_access_key,omitempty"`

	// AWS service type.
	// Example: dynamodb.*.amazonaws.com
	Service *string `json:"service,omitempty"`

	// Set to true to bypass verification of the user provided access_key_id
	// and secret_access_key. An error will be returned if 'skip_verify' is
	// provided but 'access_key_id' is not.
	//
	// Example: false
	SkipVerify *bool `json:"skip_verify,omitempty"`

	// state
	State *AwsKmsInlineState `json:"state,omitempty"`

	// svm
	Svm *AwsKmsInlineSvm `json:"svm,omitempty"`

	// AWS Connection timeout, in seconds.
	// Example: 20
	Timeout *int64 `json:"timeout,omitempty"`

	// A unique identifier for the AWS KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Set to true to verify the AWS KMS host.
	// Example: false
	Verify *bool `json:"verify,omitempty"`

	// Set to true to verify the AWS KMS host's hostname.
	// Example: true
	VerifyHost *bool `json:"verify_host,omitempty"`

	// Set to true to verify the AWS KMS host's IP address.
	// Example: false
	VerifyIP *bool `json:"verify_ip,omitempty"`
}

// Validate validates this aws kms
func (m *AwsKms) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAmazonReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAwsKmsInlineEkmipReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretAccessKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKms) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) validateAmazonReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.AmazonReachability) { // not required
		return nil
	}

	if m.AmazonReachability != nil {
		if err := m.AmazonReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("amazon_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) validateAwsKmsInlineEkmipReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.AwsKmsInlineEkmipReachability) { // not required
		return nil
	}

	for i := 0; i < len(m.AwsKmsInlineEkmipReachability); i++ {
		if swag.IsZero(m.AwsKmsInlineEkmipReachability[i]) { // not required
			continue
		}

		if m.AwsKmsInlineEkmipReachability[i] != nil {
			if err := m.AwsKmsInlineEkmipReachability[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var awsKmsTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		awsKmsTypeProxyTypePropEnum = append(awsKmsTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aws_kms
	// AwsKms
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// AwsKmsProxyTypeHTTP captures enum value "http"
	AwsKmsProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// aws_kms
	// AwsKms
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// AwsKmsProxyTypeHTTPS captures enum value "https"
	AwsKmsProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *AwsKms) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, awsKmsTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AwsKms) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProxyTypeEnum("proxy_type", "body", *m.ProxyType); err != nil {
		return err
	}

	return nil
}

var awsKmsTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		awsKmsTypeScopePropEnum = append(awsKmsTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aws_kms
	// AwsKms
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// AwsKmsScopeSvm captures enum value "svm"
	AwsKmsScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// aws_kms
	// AwsKms
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// AwsKmsScopeCluster captures enum value "cluster"
	AwsKmsScopeCluster string = "cluster"
)

// prop value enum
func (m *AwsKms) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, awsKmsTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AwsKms) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *AwsKms) validateSecretAccessKey(formats strfmt.Registry) error {
	if swag.IsZero(m.SecretAccessKey) { // not required
		return nil
	}

	if err := validate.FormatOf("secret_access_key", "body", "password", m.SecretAccessKey.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AwsKms) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms based on the context it is used
func (m *AwsKms) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAmazonReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAwsKmsInlineEkmipReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKms) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) contextValidateAmazonReachability(ctx context.Context, formats strfmt.Registry) error {

	if m.AmazonReachability != nil {
		if err := m.AmazonReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("amazon_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) contextValidateAwsKmsInlineEkmipReachability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ekmip_reachability", "body", []*AwsKmsInlineEkmipReachabilityInlineArrayItem(m.AwsKmsInlineEkmipReachability)); err != nil {
		return err
	}

	for i := 0; i < len(m.AwsKmsInlineEkmipReachability); i++ {

		if m.AwsKmsInlineEkmipReachability[i] != nil {
			if err := m.AwsKmsInlineEkmipReachability[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AwsKms) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *AwsKms) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *AwsKms) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKms) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKms) UnmarshalBinary(b []byte) error {
	var res AwsKms
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineAmazonReachability Indicates whether or not the Amazon KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model aws_kms_inline_amazon_reachability
type AwsKmsInlineAmazonReachability struct {

	// Code corresponding to the error message. Returns a 0 if Amazon KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message returned when 'reachable' is false.
	// Example: Amazon KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Amazon KMS is reachable from all nodes of the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this aws kms inline amazon reachability
func (m *AwsKmsInlineAmazonReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aws kms inline amazon reachability based on the context it is used
func (m *AwsKmsInlineAmazonReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineAmazonReachability) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineAmazonReachability) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineAmazonReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineEkmipReachabilityInlineArrayItem Provides the connectivity status for the given SVM on the given node to all EKMIP servers configured on all nodes of the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model aws_kms_inline_ekmip_reachability_inline_array_item
type AwsKmsInlineEkmipReachabilityInlineArrayItem struct {

	// Code corresponding to the error message. Returns a 0 if a given SVM is able to communicate to the EKMIP servers of all of the nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster-wide EKMIP server availability from the given SVM and node is false.
	// Example: embedded KMIP server status unavailable on node.
	Message *string `json:"message,omitempty"`

	// node
	Node *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode `json:"node,omitempty"`

	// Set to true if the given SVM on the given node is able to communicate to all EKMIP servers configured on all nodes in the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item based on the context it is used
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode aws kms inline ekmip reachability inline array item inline node
//
// swagger:model aws_kms_inline_ekmip_reachability_inline_array_item_inline_node
type AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode struct {

	// links
	Links *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item inline node
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item inline node based on the context it is used
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks aws kms inline ekmip reachability inline array item inline node inline links
//
// swagger:model aws_kms_inline_ekmip_reachability_inline_array_item_inline_node_inline__links
type AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item inline node inline links
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item inline node inline links based on the context it is used
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineLinks aws kms inline links
//
// swagger:model aws_kms_inline__links
type AwsKmsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline links
func (m *AwsKmsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline links based on the context it is used
func (m *AwsKmsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineState Indicates whether or not the Amazon Web Services Key Management Service (AWS KMS) key protection is available cluster-wide.
//
// swagger:model aws_kms_inline_state
type AwsKmsInlineState struct {

	// Set to true when AWS KMS key protection is available on all nodes of the cluster.
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Code corresponding to the message. Returns a 0 if AWS KMS key protection is available on all nodes of the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster_state is false.
	// Example: AWS KMS key protection is unavailable on the following nodes: node1, node2.
	Message *string `json:"message,omitempty"`
}

// Validate validates this aws kms inline state
func (m *AwsKmsInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aws kms inline state based on the context it is used
func (m *AwsKmsInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineState) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model aws_kms_inline_svm
type AwsKmsInlineSvm struct {

	// links
	Links *AwsKmsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aws kms inline svm
func (m *AwsKmsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline svm based on the context it is used
func (m *AwsKmsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineSvm) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AwsKmsInlineSvmInlineLinks aws kms inline svm inline links
//
// swagger:model aws_kms_inline_svm_inline__links
type AwsKmsInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline svm inline links
func (m *AwsKmsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline svm inline links based on the context it is used
func (m *AwsKmsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AwsKmsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AwsKmsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AwsKmsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
