// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AzureKeyVault azure key vault
//
// swagger:model azure_key_vault
type AzureKeyVault struct {

	// links
	Links *AzureKeyVaultInlineLinks `json:"_links,omitempty"`

	// Authentication method for the AKV instance.
	// Example: client_secret
	// Read Only: true
	// Enum: ["client_secret","certificate"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// azure key vault inline ekmip reachability
	// Read Only: true
	AzureKeyVaultInlineEkmipReachability []*AzureKeyVaultInlineEkmipReachabilityInlineArrayItem `json:"ekmip_reachability,omitempty"`

	// azure reachability
	AzureReachability *AzureKeyVaultInlineAzureReachability `json:"azure_reachability,omitempty"`

	// PKCS12 Certificate used by the application to prove its identity to AKV.
	// Example: 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
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV.
	// Example: aaaaaaaa-bbbb-aaaa-bbbb-aaaaaaaaaaaa
	ClientID *string `json:"client_id,omitempty"`

	// Secret used by the application to prove its identity to AKV.
	// Example: abcdef
	// Format: password
	ClientSecret *strfmt.Password `json:"client_secret,omitempty"`

	// configuration
	Configuration *AzureKeyVaultInlineConfiguration `json:"configuration,omitempty"`

	// Indicates whether the configuration is enabled.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Key Identifier of AKV key encryption key.
	// Example: https://keyvault1.vault.azure.net/keys/key1/12345678901234567890123456789012
	// Format: uri
	KeyID *strfmt.URI `json:"key_id,omitempty"`

	// Name of the deployed AKV that will be used by ONTAP for storing keys.
	// Example: https://kmip-akv-keyvault.vault.azure.net/
	// Format: uri
	Name *strfmt.URI `json:"name,omitempty"`

	// Open authorization server host name.
	// Example: login.microsoftonline.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// Authorization server and vault port number.
	// Example: 443
	Port *int64 `json:"port,omitempty"`

	// Proxy host.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Type of proxy.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// Set to true to skip the verification of the updated user credentials when updating credentials. The default value is false.
	// Example: false
	SkipVerification *bool `json:"skip_verification,omitempty"`

	// state
	State *AzureKeyVaultInlineState `json:"state,omitempty"`

	// svm
	Svm *AzureKeyVaultInlineSvm `json:"svm,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV.
	// Example: zzzzzzzz-yyyy-zzzz-yyyy-zzzzzzzzzzzz
	TenantID *string `json:"tenant_id,omitempty"`

	// A unique identifier for the Azure Key Vault (AKV).
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// AKV host subdomain.
	// Example: vault.azure.net
	VaultHost *string `json:"vault_host,omitempty"`

	// Verify the identity of the AKV host name.
	// Example: false
	VerifyHost *bool `json:"verify_host,omitempty"`

	// Verify the identity of the AKV IP address.
	// Example: false
	VerifyIP *bool `json:"verify_ip,omitempty"`
}

// Validate validates this azure key vault
func (m *AzureKeyVault) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzureKeyVaultInlineEkmipReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzureReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVault) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var azureKeyVaultTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["client_secret","certificate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		azureKeyVaultTypeAuthenticationMethodPropEnum = append(azureKeyVaultTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// authentication_method
	// AuthenticationMethod
	// client_secret
	// END DEBUGGING
	// AzureKeyVaultAuthenticationMethodClientSecret captures enum value "client_secret"
	AzureKeyVaultAuthenticationMethodClientSecret string = "client_secret"

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// authentication_method
	// AuthenticationMethod
	// certificate
	// END DEBUGGING
	// AzureKeyVaultAuthenticationMethodCertificate captures enum value "certificate"
	AzureKeyVaultAuthenticationMethodCertificate string = "certificate"
)

// prop value enum
func (m *AzureKeyVault) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, azureKeyVaultTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AzureKeyVault) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationMethodEnum("authentication_method", "body", *m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) validateAzureKeyVaultInlineEkmipReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureKeyVaultInlineEkmipReachability) { // not required
		return nil
	}

	for i := 0; i < len(m.AzureKeyVaultInlineEkmipReachability); i++ {
		if swag.IsZero(m.AzureKeyVaultInlineEkmipReachability[i]) { // not required
			continue
		}

		if m.AzureKeyVaultInlineEkmipReachability[i] != nil {
			if err := m.AzureKeyVaultInlineEkmipReachability[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AzureKeyVault) validateAzureReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureReachability) { // not required
		return nil
	}

	if m.AzureReachability != nil {
		if err := m.AzureReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("client_certificate", "body", "password", m.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) validateClientSecret(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("client_secret", "body", "password", m.ClientSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) validateConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.Configuration) { // not required
		return nil
	}

	if m.Configuration != nil {
		if err := m.Configuration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) validateKeyID(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyID) { // not required
		return nil
	}

	if err := validate.FormatOf("key_id", "body", "uri", m.KeyID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.FormatOf("name", "body", "uri", m.Name.String(), formats); err != nil {
		return err
	}

	return nil
}

var azureKeyVaultTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		azureKeyVaultTypeProxyTypePropEnum = append(azureKeyVaultTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// AzureKeyVaultProxyTypeHTTP captures enum value "http"
	AzureKeyVaultProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// AzureKeyVaultProxyTypeHTTPS captures enum value "https"
	AzureKeyVaultProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *AzureKeyVault) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, azureKeyVaultTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AzureKeyVault) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProxyTypeEnum("proxy_type", "body", *m.ProxyType); err != nil {
		return err
	}

	return nil
}

var azureKeyVaultTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		azureKeyVaultTypeScopePropEnum = append(azureKeyVaultTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// AzureKeyVaultScopeSvm captures enum value "svm"
	AzureKeyVaultScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// azure_key_vault
	// AzureKeyVault
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// AzureKeyVaultScopeCluster captures enum value "cluster"
	AzureKeyVaultScopeCluster string = "cluster"
)

// prop value enum
func (m *AzureKeyVault) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, azureKeyVaultTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AzureKeyVault) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault based on the context it is used
func (m *AzureKeyVault) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuthenticationMethod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAzureKeyVaultInlineEkmipReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAzureReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVault) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) contextValidateAuthenticationMethod(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "authentication_method", "body", m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) contextValidateAzureKeyVaultInlineEkmipReachability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ekmip_reachability", "body", []*AzureKeyVaultInlineEkmipReachabilityInlineArrayItem(m.AzureKeyVaultInlineEkmipReachability)); err != nil {
		return err
	}

	for i := 0; i < len(m.AzureKeyVaultInlineEkmipReachability); i++ {

		if m.AzureKeyVaultInlineEkmipReachability[i] != nil {
			if err := m.AzureKeyVaultInlineEkmipReachability[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AzureKeyVault) contextValidateAzureReachability(ctx context.Context, formats strfmt.Registry) error {

	if m.AzureReachability != nil {
		if err := m.AzureReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) contextValidateConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if m.Configuration != nil {
		if err := m.Configuration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *AzureKeyVault) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *AzureKeyVault) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVault) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVault) UnmarshalBinary(b []byte) error {
	var res AzureKeyVault
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineAzureReachability Indicates whether or not the AKV service is reachable from all the nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model azure_key_vault_inline_azure_reachability
type AzureKeyVaultInlineAzureReachability struct {

	// Code corresponding to the status message. Returns a 0 if AKV service is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when reachability is false.
	// Example: AKV service is not reachable from all nodes - reason.
	Message *string `json:"message,omitempty"`

	// Set to true when the AKV service is reachable from all nodes of the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this azure key vault inline azure reachability
func (m *AzureKeyVaultInlineAzureReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this azure key vault inline azure reachability based on the context it is used
func (m *AzureKeyVaultInlineAzureReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineAzureReachability) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineAzureReachability) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineAzureReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineConfiguration Security keystore object reference.
//
// swagger:model azure_key_vault_inline_configuration
type AzureKeyVaultInlineConfiguration struct {

	// links
	Links *AzureKeyVaultInlineConfigurationInlineLinks `json:"_links,omitempty"`

	// Name of the configuration.
	// Example: default
	Name *string `json:"name,omitempty"`

	// Keystore UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this azure key vault inline configuration
func (m *AzureKeyVaultInlineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineConfiguration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline configuration based on the context it is used
func (m *AzureKeyVaultInlineConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineConfiguration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineConfiguration) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineConfigurationInlineLinks azure key vault inline configuration inline links
//
// swagger:model azure_key_vault_inline_configuration_inline__links
type AzureKeyVaultInlineConfigurationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this azure key vault inline configuration inline links
func (m *AzureKeyVaultInlineConfigurationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineConfigurationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline configuration inline links based on the context it is used
func (m *AzureKeyVaultInlineConfigurationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineConfigurationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineConfigurationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineConfigurationInlineLinks) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineConfigurationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineEkmipReachabilityInlineArrayItem Provides the connectivity status for the given SVM on the given node to all EKMIP servers configured on all nodes of the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model azure_key_vault_inline_ekmip_reachability_inline_array_item
type AzureKeyVaultInlineEkmipReachabilityInlineArrayItem struct {

	// Code corresponding to the error message. Returns a 0 if a given SVM is able to communicate to the EKMIP servers of all of the nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster-wide EKMIP server availability from the given SVM and node is false.
	// Example: embedded KMIP server status unavailable on node.
	Message *string `json:"message,omitempty"`

	// node
	Node *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode `json:"node,omitempty"`

	// Set to true if the given SVM on the given node is able to communicate to all EKMIP servers configured on all nodes in the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this azure key vault inline ekmip reachability inline array item
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline ekmip reachability inline array item based on the context it is used
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineEkmipReachabilityInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode azure key vault inline ekmip reachability inline array item inline node
//
// swagger:model azure_key_vault_inline_ekmip_reachability_inline_array_item_inline_node
type AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode struct {

	// links
	Links *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this azure key vault inline ekmip reachability inline array item inline node
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline ekmip reachability inline array item inline node based on the context it is used
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks azure key vault inline ekmip reachability inline array item inline node inline links
//
// swagger:model azure_key_vault_inline_ekmip_reachability_inline_array_item_inline_node_inline__links
type AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this azure key vault inline ekmip reachability inline array item inline node inline links
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline ekmip reachability inline array item inline node inline links based on the context it is used
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineLinks azure key vault inline links
//
// swagger:model azure_key_vault_inline__links
type AzureKeyVaultInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this azure key vault inline links
func (m *AzureKeyVaultInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline links based on the context it is used
func (m *AzureKeyVaultInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineLinks) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineState Indicates whether or not the AKV wrapped internal key is available cluster wide.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model azure_key_vault_inline_state
type AzureKeyVaultInlineState struct {

	// Set to true when an AKV wrapped internal key is present on all nodes of the cluster.
	Available *bool `json:"available,omitempty"`

	// Code corresponding to the status message. Returns a 0 if AKV wrapped key is available on all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when top-level internal key protection key (KEK) availability on cluster is false.
	// Example: Top-level internal key protection key (KEK) is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this azure key vault inline state
func (m *AzureKeyVaultInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this azure key vault inline state based on the context it is used
func (m *AzureKeyVaultInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineState) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model azure_key_vault_inline_svm
type AzureKeyVaultInlineSvm struct {

	// links
	Links *AzureKeyVaultInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this azure key vault inline svm
func (m *AzureKeyVaultInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline svm based on the context it is used
func (m *AzureKeyVaultInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineSvm) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// AzureKeyVaultInlineSvmInlineLinks azure key vault inline svm inline links
//
// swagger:model azure_key_vault_inline_svm_inline__links
type AzureKeyVaultInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this azure key vault inline svm inline links
func (m *AzureKeyVaultInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this azure key vault inline svm inline links based on the context it is used
func (m *AzureKeyVaultInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AzureKeyVaultInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AzureKeyVaultInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AzureKeyVaultInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res AzureKeyVaultInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
