// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Barbican barbican
//
// swagger:model barbican
type Barbican struct {

	// links
	Links *BarbicanInlineLinks `json:"_links,omitempty"`

	// Keystone application credentials ID required to access the specified Barbican KMS.
	// Example: 63e3cb77f84f42b7a0395a3efb7636f9
	ApplicationCredID *string `json:"application_cred_id,omitempty"`

	// Keystone application credentials secret required to access the specified Barbican KMS. It is not audited.
	// Example: secret
	// Format: password
	ApplicationCredSecret *strfmt.Password `json:"application_cred_secret,omitempty"`

	// barbican reachability
	BarbicanReachability *BarbicanInlineBarbicanReachability `json:"barbican_reachability,omitempty"`

	// configuration
	Configuration *BarbicanInlineConfiguration `json:"configuration,omitempty"`

	// Indicates whether the configuration is enabled.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Key Identifier URL of the Barbican KMS key encryption key. Must be an HTTPS URL.
	// Example: https://172.29.58.184:9311/v1/secrets/5c610a4f-ea97-44b5-8682-f4daeafa9647
	// Format: uri
	KeyID *strfmt.URI `json:"key_id,omitempty"`

	// Keystone URL for the access token. Must be an HTTPS URL.
	// Example: https://keystoneip:5000/v3/auth/tokens
	// Format: uri
	KeystoneURL *strfmt.URI `json:"keystone_url,omitempty"`

	// Proxy host name.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	// Format: password
	ProxyPassword *strfmt.Password `json:"proxy_password,omitempty"`

	// Proxy port number.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Type of proxy.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// state
	State *BarbicanInlineState `json:"state,omitempty"`

	// svm
	Svm *BarbicanInlineSvm `json:"svm,omitempty"`

	// Connection timeout in seconds.
	// Example: 60
	Timeout *int64 `json:"timeout,omitempty"`

	// A unique identifier of the Barbican KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Verify the identity of the Barbican KMS.
	Verify *bool `json:"verify,omitempty"`

	// Verify the identity of the Barbican KMS host name.
	VerifyHost *bool `json:"verify_host,omitempty"`
}

// Validate validates this barbican
func (m *Barbican) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplicationCredSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBarbicanReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeystoneURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Barbican) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) validateApplicationCredSecret(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationCredSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("application_cred_secret", "body", "password", m.ApplicationCredSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) validateBarbicanReachability(formats strfmt.Registry) error {
	if swag.IsZero(m.BarbicanReachability) { // not required
		return nil
	}

	if m.BarbicanReachability != nil {
		if err := m.BarbicanReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("barbican_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) validateConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.Configuration) { // not required
		return nil
	}

	if m.Configuration != nil {
		if err := m.Configuration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) validateKeyID(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyID) { // not required
		return nil
	}

	if err := validate.FormatOf("key_id", "body", "uri", m.KeyID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) validateKeystoneURL(formats strfmt.Registry) error {
	if swag.IsZero(m.KeystoneURL) { // not required
		return nil
	}

	if err := validate.FormatOf("keystone_url", "body", "uri", m.KeystoneURL.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) validateProxyPassword(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyPassword) { // not required
		return nil
	}

	if err := validate.FormatOf("proxy_password", "body", "password", m.ProxyPassword.String(), formats); err != nil {
		return err
	}

	return nil
}

var barbicanTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		barbicanTypeProxyTypePropEnum = append(barbicanTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// barbican
	// Barbican
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// BarbicanProxyTypeHTTP captures enum value "http"
	BarbicanProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// barbican
	// Barbican
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// BarbicanProxyTypeHTTPS captures enum value "https"
	BarbicanProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *Barbican) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, barbicanTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Barbican) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProxyTypeEnum("proxy_type", "body", *m.ProxyType); err != nil {
		return err
	}

	return nil
}

var barbicanTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		barbicanTypeScopePropEnum = append(barbicanTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// barbican
	// Barbican
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// BarbicanScopeSvm captures enum value "svm"
	BarbicanScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// barbican
	// Barbican
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// BarbicanScopeCluster captures enum value "cluster"
	BarbicanScopeCluster string = "cluster"
)

// prop value enum
func (m *Barbican) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, barbicanTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Barbican) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this barbican based on the context it is used
func (m *Barbican) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBarbicanReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Barbican) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) contextValidateBarbicanReachability(ctx context.Context, formats strfmt.Registry) error {

	if m.BarbicanReachability != nil {
		if err := m.BarbicanReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("barbican_reachability")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) contextValidateConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if m.Configuration != nil {
		if err := m.Configuration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *Barbican) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Barbican) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Barbican) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Barbican) UnmarshalBinary(b []byte) error {
	var res Barbican
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineBarbicanReachability Indicates whether the Barbican KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET request or an instance GET request unless it is explicitly requested using the field's query parameter or GET for all advanced properties is enabled.
//
// swagger:model barbican_inline_barbican_reachability
type BarbicanInlineBarbicanReachability struct {

	// Code corresponding to the error message. Returns 0 if Barbican KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Set to the appropriate error message when 'reachable' is false.
	// Example: Barbican KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Barbican KMS is reachable from all nodes of the cluster.
	// Example: false
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this barbican inline barbican reachability
func (m *BarbicanInlineBarbicanReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this barbican inline barbican reachability based on the context it is used
func (m *BarbicanInlineBarbicanReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineBarbicanReachability) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineBarbicanReachability) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineBarbicanReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineConfiguration Security keystore object reference.
//
// swagger:model barbican_inline_configuration
type BarbicanInlineConfiguration struct {

	// links
	Links *BarbicanInlineConfigurationInlineLinks `json:"_links,omitempty"`

	// Name of the configuration.
	// Example: default
	Name *string `json:"name,omitempty"`

	// Keystore UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this barbican inline configuration
func (m *BarbicanInlineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineConfiguration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline configuration based on the context it is used
func (m *BarbicanInlineConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineConfiguration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineConfiguration) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineConfigurationInlineLinks barbican inline configuration inline links
//
// swagger:model barbican_inline_configuration_inline__links
type BarbicanInlineConfigurationInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this barbican inline configuration inline links
func (m *BarbicanInlineConfigurationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineConfigurationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline configuration inline links based on the context it is used
func (m *BarbicanInlineConfigurationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineConfigurationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineConfigurationInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineConfigurationInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineConfigurationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineLinks barbican inline links
//
// swagger:model barbican_inline__links
type BarbicanInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this barbican inline links
func (m *BarbicanInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline links based on the context it is used
func (m *BarbicanInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineState Indicates whether or not the SVM key encryption key (KEK) is available cluster wide.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model barbican_inline_state
type BarbicanInlineState struct {

	// Set to true when an SVM-KEK is present on all nodes of the cluster.
	// Example: false
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Code corresponding to the status message. Returns a 0 if the SVM-KEK is available on all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message returned when there's no SVM-KEK availability on the cluster.
	// Example: Top-level internal key encryption key is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this barbican inline state
func (m *BarbicanInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this barbican inline state based on the context it is used
func (m *BarbicanInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineState) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model barbican_inline_svm
type BarbicanInlineSvm struct {

	// links
	Links *BarbicanInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this barbican inline svm
func (m *BarbicanInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline svm based on the context it is used
func (m *BarbicanInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineSvm) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BarbicanInlineSvmInlineLinks barbican inline svm inline links
//
// swagger:model barbican_inline_svm_inline__links
type BarbicanInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this barbican inline svm inline links
func (m *BarbicanInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline svm inline links based on the context it is used
func (m *BarbicanInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BarbicanInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
