// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// BarbicanConnectivity Indicates whether the Barbican KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET request or an instance GET request unless it is explicitly requested using the field's query parameter or GET for all advanced properties is enabled.
//
// swagger:model barbican_connectivity
type BarbicanConnectivity struct {

	// Code corresponding to the error message. Returns 0 if Barbican KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Set to the appropriate error message when 'reachable' is false.
	// Example: Barbican KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Barbican KMS is reachable from all nodes of the cluster.
	// Example: false
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this barbican connectivity
func (m *BarbicanConnectivity) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this barbican connectivity based on context it is used
func (m *BarbicanConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanConnectivity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanConnectivity) UnmarshalBinary(b []byte) error {
	var res BarbicanConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
