// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// BarbicanState Indicates whether or not the SVM key encryption key (KEK) is available cluster wide.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
// swagger:model barbican_state
type BarbicanState struct {

	// Set to true when an SVM-KEK is present on all nodes of the cluster.
	// Example: false
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Code corresponding to the status message. Returns a 0 if the SVM-KEK is available on all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message returned when there's no SVM-KEK availability on the cluster.
	// Example: Top-level internal key encryption key is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this barbican state
func (m *BarbicanState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this barbican state based on context it is used
func (m *BarbicanState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BarbicanState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BarbicanState) UnmarshalBinary(b []byte) error {
	var res BarbicanState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
