// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BgpPeerGroup A BGP peer group between a local network interface and a router, for the purpose of announcing VIP interface locations for SVMs in this IPspace.
//
// swagger:model bgp_peer_group
type BgpPeerGroup struct {

	// ipspace
	Ipspace *BgpPeerGroupInlineIpspace `json:"ipspace,omitempty"`

	// local
	Local *BgpPeerGroupInlineLocal `json:"local,omitempty"`

	// Name of the peer group
	// Example: bgpv4peer
	Name *string `json:"name,omitempty"`

	// peer
	Peer *BgpPeerGroupInlinePeer `json:"peer,omitempty"`

	// State of the peer group
	// Read Only: true
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`

	// UUID of the peer group
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group
func (m *BgpPeerGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroup) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroup) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroup) validatePeer(formats strfmt.Registry) error {
	if swag.IsZero(m.Peer) { // not required
		return nil
	}

	if m.Peer != nil {
		if err := m.Peer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

var bgpPeerGroupTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		bgpPeerGroupTypeStatePropEnum = append(bgpPeerGroupTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// bgp_peer_group
	// BgpPeerGroup
	// state
	// State
	// up
	// END DEBUGGING
	// BgpPeerGroupStateUp captures enum value "up"
	BgpPeerGroupStateUp string = "up"

	// BEGIN DEBUGGING
	// bgp_peer_group
	// BgpPeerGroup
	// state
	// State
	// down
	// END DEBUGGING
	// BgpPeerGroupStateDown captures enum value "down"
	BgpPeerGroupStateDown string = "down"
)

// prop value enum
func (m *BgpPeerGroup) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, bgpPeerGroupTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BgpPeerGroup) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this bgp peer group based on the context it is used
func (m *BgpPeerGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroup) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroup) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroup) contextValidatePeer(ctx context.Context, formats strfmt.Registry) error {

	if m.Peer != nil {
		if err := m.Peer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroup) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *BgpPeerGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroup) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineIpspace Either the UUID or name is supplied on input.
//
// swagger:model bgp_peer_group_inline_ipspace
type BgpPeerGroupInlineIpspace struct {

	// links
	Links *BgpPeerGroupInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline ipspace
func (m *BgpPeerGroupInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline ipspace based on the context it is used
func (m *BgpPeerGroupInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineIpspace) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineIpspaceInlineLinks bgp peer group inline ipspace inline links
//
// swagger:model bgp_peer_group_inline_ipspace_inline__links
type BgpPeerGroupInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline ipspace inline links
func (m *BgpPeerGroupInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline ipspace inline links based on the context it is used
func (m *BgpPeerGroupInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocal Information describing the local interface that is being used to peer with a router using BGP. On a POST operation, an existing BGP interface is used by specifying the interface, or create a new one by specifying the port and IP address.
//
// swagger:model bgp_peer_group_inline_local
type BgpPeerGroupInlineLocal struct {

	// interface
	Interface *BgpPeerGroupInlineLocalInlineInterface `json:"interface,omitempty"`

	// ip
	IP *BgpPeerGroupInlineLocalInlineIP `json:"ip,omitempty"`

	// port
	Port *BgpPeerGroupInlineLocalInlinePort `json:"port,omitempty"`
}

// Validate validates this bgp peer group inline local
func (m *BgpPeerGroupInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocal) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocal) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocal) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local based on the context it is used
func (m *BgpPeerGroupInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocal) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocal) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocal) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocal) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlineIP IP information to create a new interface.
//
// swagger:model bgp_peer_group_inline_local_inline_ip
type BgpPeerGroupInlineLocalInlineIP struct {

	// address
	Address *IPAddress `json:"address,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this bgp peer group inline local inline ip
func (m *BgpPeerGroupInlineLocalInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlineIP) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline ip based on the context it is used
func (m *BgpPeerGroupInlineLocalInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlineIP) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineIP) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlineInterface A network interface. Either UUID or name may be supplied on input.
//
// swagger:model bgp_peer_group_inline_local_inline_interface
type BgpPeerGroupInlineLocalInlineInterface struct {

	// links
	Links *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// ip
	IP *BgpPeerGroupInlineLocalInlineInterfaceInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface
func (m *BgpPeerGroupInlineLocalInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface based on the context it is used
func (m *BgpPeerGroupInlineLocalInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterface) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlineInterfaceInlineIP IP information
//
// swagger:model bgp_peer_group_inline_local_inline_interface_inline_ip
type BgpPeerGroupInlineLocalInlineInterfaceInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface inline ip
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface inline ip based on the context it is used
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlineInterfaceInlineLinks bgp peer group inline local inline interface inline links
//
// swagger:model bgp_peer_group_inline_local_inline_interface_inline__links
type BgpPeerGroupInlineLocalInlineInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline local inline interface inline links
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline interface inline links based on the context it is used
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlinePort Port UUID along with readable names. Either the UUID or both names may be supplied on input.
//
// swagger:model bgp_peer_group_inline_local_inline_port
type BgpPeerGroupInlineLocalInlinePort struct {

	// links
	Links *BgpPeerGroupInlineLocalInlinePortInlineLinks `json:"_links,omitempty"`

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *BgpPeerGroupInlineLocalInlinePortInlineNode `json:"node,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this bgp peer group inline local inline port
func (m *BgpPeerGroupInlineLocalInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline port based on the context it is used
func (m *BgpPeerGroupInlineLocalInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePort) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlinePortInlineLinks bgp peer group inline local inline port inline links
//
// swagger:model bgp_peer_group_inline_local_inline_port_inline__links
type BgpPeerGroupInlineLocalInlinePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this bgp peer group inline local inline port inline links
func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this bgp peer group inline local inline port inline links based on the context it is used
func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlineLocalInlinePortInlineNode bgp peer group inline local inline port inline node
//
// swagger:model bgp_peer_group_inline_local_inline_port_inline_node
type BgpPeerGroupInlineLocalInlinePortInlineNode struct {

	// Name of node on which the port is located.
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this bgp peer group inline local inline port inline node
func (m *BgpPeerGroupInlineLocalInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this bgp peer group inline local inline port inline node based on context it is used
func (m *BgpPeerGroupInlineLocalInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlineLocalInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlineLocalInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// BgpPeerGroupInlinePeer Information describing the router to peer with
//
// swagger:model bgp_peer_group_inline_peer
type BgpPeerGroupInlinePeer struct {

	// Peer router address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Autonomous system number of peer
	Asn *int64 `json:"asn,omitempty"`

	// Use peer address as next hop.
	IsNextHop *bool `json:"is_next_hop,omitempty"`

	// Enable or disable TCP MD5 signatures per RFC 2385.
	// Example: true
	Md5Enabled *bool `json:"md5_enabled,omitempty"`

	// The shared TCP MD5 secret key. This can either be given as a password or hexadecimal key.
	// Example: SECRET_WORD
	// Max Length: 79
	// Min Length: 1
	Md5Secret *string `json:"md5_secret,omitempty"`
}

// Validate validates this bgp peer group inline peer
func (m *BgpPeerGroupInlinePeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMd5Secret(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BgpPeerGroupInlinePeer) validateMd5Secret(formats strfmt.Registry) error {
	if swag.IsZero(m.Md5Secret) { // not required
		return nil
	}

	if err := validate.MinLength("peer"+"."+"md5_secret", "body", *m.Md5Secret, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("peer"+"."+"md5_secret", "body", *m.Md5Secret, 79); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this bgp peer group inline peer based on context it is used
func (m *BgpPeerGroupInlinePeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BgpPeerGroupInlinePeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BgpPeerGroupInlinePeer) UnmarshalBinary(b []byte) error {
	var res BgpPeerGroupInlinePeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
