// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ByteLock byte lock
//
// swagger:model byte_lock
type ByteLock struct {

	// Indicates whether it is an exclusive bytelock.
	// Read Only: true
	Exclusive *bool `json:"exclusive,omitempty"`

	// Length of the bytelock starting from the offset.
	// Example: 10
	// Read Only: true
	Length *int64 `json:"length,omitempty"`

	// Indicates whether or not the bytelock is mandatory.
	// Read Only: true
	Mandatory *bool `json:"mandatory,omitempty"`

	// Starting offset for a bytelock.
	// Example: 100
	// Read Only: true
	Offset *int64 `json:"offset,omitempty"`

	// Indicates whether it is a soft bytelock.
	// Read Only: true
	Soft *bool `json:"soft,omitempty"`

	// Indicates whether it is a super bytelock.
	// Read Only: true
	Super *bool `json:"super,omitempty"`
}

// Validate validates this byte lock
func (m *ByteLock) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this byte lock based on the context it is used
func (m *ByteLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExclusive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLength(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMandatory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOffset(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSoft(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSuper(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ByteLock) contextValidateExclusive(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "exclusive", "body", m.Exclusive); err != nil {
		return err
	}

	return nil
}

func (m *ByteLock) contextValidateLength(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "length", "body", m.Length); err != nil {
		return err
	}

	return nil
}

func (m *ByteLock) contextValidateMandatory(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mandatory", "body", m.Mandatory); err != nil {
		return err
	}

	return nil
}

func (m *ByteLock) contextValidateOffset(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "offset", "body", m.Offset); err != nil {
		return err
	}

	return nil
}

func (m *ByteLock) contextValidateSoft(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "soft", "body", m.Soft); err != nil {
		return err
	}

	return nil
}

func (m *ByteLock) contextValidateSuper(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "super", "body", m.Super); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ByteLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ByteLock) UnmarshalBinary(b []byte) error {
	var res ByteLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
