// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CapacityPoolResponse Information on capacity pool licenses associated with the cluster.
//
// swagger:model capacity_pool_response
type CapacityPoolResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// capacity pool response inline records
	CapacityPoolResponseInlineRecords []*CapacityPoolResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this capacity pool response
func (m *CapacityPoolResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapacityPoolResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponse) validateCapacityPoolResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.CapacityPoolResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.CapacityPoolResponseInlineRecords); i++ {
		if swag.IsZero(m.CapacityPoolResponseInlineRecords[i]) { // not required
			continue
		}

		if m.CapacityPoolResponseInlineRecords[i] != nil {
			if err := m.CapacityPoolResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this capacity pool response based on the context it is used
func (m *CapacityPoolResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapacityPoolResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponse) contextValidateCapacityPoolResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CapacityPoolResponseInlineRecords); i++ {

		if m.CapacityPoolResponseInlineRecords[i] != nil {
			if err := m.CapacityPoolResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *CapacityPoolResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CapacityPoolResponse) UnmarshalBinary(b []byte) error {
	var res CapacityPoolResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CapacityPoolResponseInlineRecordsInlineArrayItem Information on a capacity pool license and how it is associated with the cluster.
//
// swagger:model capacity_pool_response_inline_records_inline_array_item
type CapacityPoolResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// license manager
	LicenseManager *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager `json:"license_manager,omitempty"`

	// Nodes in the cluster associated with this capacity pool.
	Nodes []*CapacityPoolResponseRecordsItems0NodesItems0 `json:"nodes"`

	// Serial number of the capacity pool license.
	// Example: 390000100
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this capacity pool response inline records inline array item
func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLicenseManager(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) validateLicenseManager(formats strfmt.Registry) error {
	if swag.IsZero(m.LicenseManager) { // not required
		return nil
	}

	if m.LicenseManager != nil {
		if err := m.LicenseManager.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license_manager")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) validateNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.Nodes) { // not required
		return nil
	}

	for i := 0; i < len(m.Nodes); i++ {
		if swag.IsZero(m.Nodes[i]) { // not required
			continue
		}

		if m.Nodes[i] != nil {
			if err := m.Nodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this capacity pool response inline records inline array item based on the context it is used
func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLicenseManager(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) contextValidateLicenseManager(ctx context.Context, formats strfmt.Registry) error {

	if m.LicenseManager != nil {
		if err := m.LicenseManager.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license_manager")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) contextValidateNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Nodes); i++ {

		if m.Nodes[i] != nil {
			if err := m.Nodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CapacityPoolResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CapacityPoolResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager License manager instance where this capacity pool license in installed.
//
// swagger:model capacity_pool_response_inline_records_inline_array_item_inline_license_manager
type CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-112233445566
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this capacity pool response inline records inline array item inline license manager
func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license_manager" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("license_manager"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this capacity pool response inline records inline array item inline license manager based on the context it is used
func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license_manager" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager) UnmarshalBinary(b []byte) error {
	var res CapacityPoolResponseInlineRecordsInlineArrayItemInlineLicenseManager
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CapacityPoolResponseRecordsItems0NodesItems0 Information on a node from the capacity licensing perspective.
//
// swagger:model CapacityPoolResponseRecordsItems0NodesItems0
type CapacityPoolResponseRecordsItems0NodesItems0 struct {

	// node
	Node *NodeReference `json:"node,omitempty"`

	// Capacity, in bytes, that is currently used by the node.
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this capacity pool response records items0 nodes items0
func (m *CapacityPoolResponseRecordsItems0NodesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseRecordsItems0NodesItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this capacity pool response records items0 nodes items0 based on the context it is used
func (m *CapacityPoolResponseRecordsItems0NodesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CapacityPoolResponseRecordsItems0NodesItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *CapacityPoolResponseRecordsItems0NodesItems0) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used_size", "body", m.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CapacityPoolResponseRecordsItems0NodesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CapacityPoolResponseRecordsItems0NodesItems0) UnmarshalBinary(b []byte) error {
	var res CapacityPoolResponseRecordsItems0NodesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
