// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsConnection cifs connection
//
// swagger:model cifs_connection
type CifsConnection struct {

	// cifs connection inline sessions
	CifsConnectionInlineSessions []*CifsConnectionInlineSessionsInlineArrayItem `json:"sessions,omitempty"`

	// Specifies IP of the client.
	//
	// Example: 10.74.7.182
	// Read Only: true
	ClientIP *string `json:"client_ip,omitempty"`

	// "A unique 32-bit unsigned number used to represent the port number of the connection".
	//
	// Example: 12345
	// Read Only: true
	ClientPort *int64 `json:"client_port,omitempty"`

	// A unique 32-bit unsigned number used to represent each SMB session's connection ID.
	//
	// Example: 22802
	// Read Only: true
	Identifier *int64 `json:"identifier,omitempty"`

	// A unique 32-bit unsigned number used to represent each SMB session's network context ID.
	//
	// Example: 22802
	// Read Only: true
	NetworkContextID *int64 `json:"network_context_id,omitempty"`

	// node
	Node *CifsConnectionInlineNode `json:"node,omitempty"`

	// Specifies the IP address of the SVM.
	//
	// Example: 10.140.78.248
	// Read Only: true
	ServerIP *string `json:"server_ip,omitempty"`

	// svm
	Svm *CifsConnectionInlineSvm `json:"svm,omitempty"`
}

// Validate validates this cifs connection
func (m *CifsConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifsConnectionInlineSessions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnection) validateCifsConnectionInlineSessions(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsConnectionInlineSessions) { // not required
		return nil
	}

	for i := 0; i < len(m.CifsConnectionInlineSessions); i++ {
		if swag.IsZero(m.CifsConnectionInlineSessions[i]) { // not required
			continue
		}

		if m.CifsConnectionInlineSessions[i] != nil {
			if err := m.CifsConnectionInlineSessions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sessions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsConnection) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *CifsConnection) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs connection based on the context it is used
func (m *CifsConnection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifsConnectionInlineSessions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClientIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClientPort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIdentifier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkContextID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnection) contextValidateCifsConnectionInlineSessions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CifsConnectionInlineSessions); i++ {

		if m.CifsConnectionInlineSessions[i] != nil {
			if err := m.CifsConnectionInlineSessions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sessions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsConnection) contextValidateClientIP(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "client_ip", "body", m.ClientIP); err != nil {
		return err
	}

	return nil
}

func (m *CifsConnection) contextValidateClientPort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "client_port", "body", m.ClientPort); err != nil {
		return err
	}

	return nil
}

func (m *CifsConnection) contextValidateIdentifier(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identifier", "body", m.Identifier); err != nil {
		return err
	}

	return nil
}

func (m *CifsConnection) contextValidateNetworkContextID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "network_context_id", "body", m.NetworkContextID); err != nil {
		return err
	}

	return nil
}

func (m *CifsConnection) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *CifsConnection) contextValidateServerIP(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "server_ip", "body", m.ServerIP); err != nil {
		return err
	}

	return nil
}

func (m *CifsConnection) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnection) UnmarshalBinary(b []byte) error {
	var res CifsConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsConnectionInlineNode cifs connection inline node
//
// swagger:model cifs_connection_inline_node
type CifsConnectionInlineNode struct {

	// links
	Links *CifsConnectionInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs connection inline node
func (m *CifsConnectionInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs connection inline node based on the context it is used
func (m *CifsConnectionInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnectionInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnectionInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsConnectionInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsConnectionInlineNodeInlineLinks cifs connection inline node inline links
//
// swagger:model cifs_connection_inline_node_inline__links
type CifsConnectionInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs connection inline node inline links
func (m *CifsConnectionInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs connection inline node inline links based on the context it is used
func (m *CifsConnectionInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnectionInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnectionInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsConnectionInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsConnectionInlineSessionsInlineArrayItem cifs connection inline sessions inline array item
//
// swagger:model cifs_connection_inline_sessions_inline_array_item
type CifsConnectionInlineSessionsInlineArrayItem struct {

	// A unique 64-bit unsigned number represented as string used to represent each SMB session's identifier.
	//
	// Example: 4622663542519103000
	// Read Only: true
	Identifier *int64 `json:"identifier,omitempty"`
}

// Validate validates this cifs connection inline sessions inline array item
func (m *CifsConnectionInlineSessionsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs connection inline sessions inline array item based on the context it is used
func (m *CifsConnectionInlineSessionsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIdentifier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineSessionsInlineArrayItem) contextValidateIdentifier(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "identifier", "body", m.Identifier); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnectionInlineSessionsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnectionInlineSessionsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsConnectionInlineSessionsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsConnectionInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model cifs_connection_inline_svm
type CifsConnectionInlineSvm struct {

	// links
	Links *CifsConnectionInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs connection inline svm
func (m *CifsConnectionInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs connection inline svm based on the context it is used
func (m *CifsConnectionInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnectionInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnectionInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsConnectionInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsConnectionInlineSvmInlineLinks cifs connection inline svm inline links
//
// swagger:model cifs_connection_inline_svm_inline__links
type CifsConnectionInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs connection inline svm inline links
func (m *CifsConnectionInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs connection inline svm inline links based on the context it is used
func (m *CifsConnectionInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsConnectionInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsConnectionInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsConnectionInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsConnectionInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
